/* game-window.c generated by valac 0.41.91, the Vala compiler
 * generated from game-window.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2015 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This file is part of a GNOME game.
 *
 * This application is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This application is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this application. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>


#define TYPE_GAME_WINDOW_FLAGS (game_window_flags_get_type ())

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;
typedef struct _GameWindowPrivate GameWindowPrivate;
enum  {
	GAME_WINDOW_0_PROPERTY,
	GAME_WINDOW_NUM_PROPERTIES
};
static GParamSpec* game_window_properties[GAME_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GAME_WINDOW_PLAY_SIGNAL,
	GAME_WINDOW_WAIT_SIGNAL,
	GAME_WINDOW_BACK_SIGNAL,
	GAME_WINDOW_UNDO_SIGNAL,
	GAME_WINDOW_REDO_SIGNAL,
	GAME_WINDOW_HINT_SIGNAL,
	GAME_WINDOW_NUM_SIGNALS
};
static guint game_window_signals[GAME_WINDOW_NUM_SIGNALS] = {0};

typedef enum  {
	GAME_WINDOW_FLAGS_SHOW_UNDO = 1 << 0,
	GAME_WINDOW_FLAGS_SHOW_REDO = 1 << 1,
	GAME_WINDOW_FLAGS_SHOW_HINT = 1 << 2,
	GAME_WINDOW_FLAGS_SHOW_START_BUTTON = 1 << 3
} GameWindowFlags;

struct _GameWindow {
	GtkApplicationWindow parent_instance;
	GameWindowPrivate * priv;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
};

struct _GameWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _GameWindowPrivate {
	gboolean tiled_state;
	gboolean maximized_state;
	gint window_width;
	gint window_height;
	gboolean game_finished;
	GtkHeaderBar* headerbar;
	GtkStack* stack;
	GtkButton* start_game_button;
	GtkButton* new_game_button;
	GtkButton* back_button;
	GtkBox* controls_box;
	GtkBox* game_box;
	GtkBox* new_game_box;
	GtkBox* side_box;
	GtkWidget* view;
	GSimpleAction* back_action;
};


static gint GameWindow_private_offset;
static gpointer game_window_parent_class = NULL;

GType game_window_flags_get_type (void) G_GNUC_CONST;
GType game_window_get_type (void) G_GNUC_CONST;
static void game_window_new_game_cb (GameWindow* self);
static void _game_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void game_window_start_game_cb (GameWindow* self);
static void _game_window_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void game_window_back_cb (GameWindow* self);
static void _game_window_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void game_window_undo_cb (GameWindow* self);
static void _game_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void game_window_redo_cb (GameWindow* self);
static void _game_window_redo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void game_window_hint_cb (GameWindow* self);
static void _game_window_hint_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
GameWindow* game_window_new (const gchar* css_resource,
                             const gchar* name,
                             gint width,
                             gint height,
                             gboolean maximized,
                             gboolean start_now,
                             GameWindowFlags flags,
                             GtkBox* new_game_screen,
                             GtkWidget* _view);
GameWindow* game_window_construct (GType object_type,
                                   const gchar* css_resource,
                                   const gchar* name,
                                   gint width,
                                   gint height,
                                   gboolean maximized,
                                   gboolean start_now,
                                   GameWindowFlags flags,
                                   GtkBox* new_game_screen,
                                   GtkWidget* _view);
static void game_window_size_allocate_cb (GameWindow* self);
static void _game_window_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                             GtkAllocation* allocation,
                                                             gpointer self);
static gboolean game_window_window_state_event_cb (GameWindow* self,
                                            GdkEventWindowState* event);
static gboolean _game_window_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                           GdkEventWindowState* event,
                                                                           gpointer self);
static void game_window_show_view (GameWindow* self);
static void game_window_show_new_game_screen (GameWindow* self);
void game_window_shutdown (GameWindow* self,
                           GSettings* settings);
void game_window_add_to_sidebox (GameWindow* self,
                                 GtkWidget* widget);
void game_window_cannot_undo_more (GameWindow* self);
void game_window_set_subtitle (GameWindow* self,
                               const gchar* subtitle);
void game_window_finish_game (GameWindow* self);
static void game_window_finalize (GObject * obj);

static const GActionEntry GAME_WINDOW_win_actions[6] = {{"new-game", _game_window_new_game_cb_gsimple_action_activate_callback}, {"start-game", _game_window_start_game_cb_gsimple_action_activate_callback}, {"back", _game_window_back_cb_gsimple_action_activate_callback}, {"undo", _game_window_undo_cb_gsimple_action_activate_callback}, {"redo", _game_window_redo_cb_gsimple_action_activate_callback}, {"hint", _game_window_hint_cb_gsimple_action_activate_callback}};

GType
game_window_flags_get_type (void)
{
	static volatile gsize game_window_flags_type_id__volatile = 0;
	if (g_once_init_enter (&game_window_flags_type_id__volatile)) {
		static const GFlagsValue values[] = {{GAME_WINDOW_FLAGS_SHOW_UNDO, "GAME_WINDOW_FLAGS_SHOW_UNDO", "show-undo"}, {GAME_WINDOW_FLAGS_SHOW_REDO, "GAME_WINDOW_FLAGS_SHOW_REDO", "show-redo"}, {GAME_WINDOW_FLAGS_SHOW_HINT, "GAME_WINDOW_FLAGS_SHOW_HINT", "show-hint"}, {GAME_WINDOW_FLAGS_SHOW_START_BUTTON, "GAME_WINDOW_FLAGS_SHOW_START_BUTTON", "show-start-button"}, {0, NULL, NULL}};
		GType game_window_flags_type_id;
		game_window_flags_type_id = g_flags_register_static ("GameWindowFlags", values);
		g_once_init_leave (&game_window_flags_type_id__volatile, game_window_flags_type_id);
	}
	return game_window_flags_type_id__volatile;
}


static inline gpointer
game_window_get_instance_private (GameWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GameWindow_private_offset);
}


static void
_game_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	game_window_new_game_cb ((GameWindow*) self);
}


static void
_game_window_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	game_window_start_game_cb ((GameWindow*) self);
}


static void
_game_window_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	game_window_back_cb ((GameWindow*) self);
}


static void
_game_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	game_window_undo_cb ((GameWindow*) self);
}


static void
_game_window_redo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	game_window_redo_cb ((GameWindow*) self);
}


static void
_game_window_hint_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	game_window_hint_cb ((GameWindow*) self);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
_game_window_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                        GtkAllocation* allocation,
                                                        gpointer self)
{
	game_window_size_allocate_cb ((GameWindow*) self);
}


static gboolean
_game_window_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                  GdkEventWindowState* event,
                                                                  gpointer self)
{
	gboolean result;
	result = game_window_window_state_event_cb ((GameWindow*) self, event);
	return result;
}


GameWindow*
game_window_construct (GType object_type,
                       const gchar* css_resource,
                       const gchar* name,
                       gint width,
                       gint height,
                       gboolean maximized,
                       gboolean start_now,
                       GameWindowFlags flags,
                       GtkBox* new_game_screen,
                       GtkWidget* _view)
{
	GameWindow * self = NULL;
	GtkWidget* _tmp4_;
	GAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GAction* _tmp9_;
	GSimpleAction* _tmp10_;
	GSimpleAction* _tmp11_;
	GSimpleAction* _tmp12_;
	GSimpleAction* _tmp13_;
	GtkHeaderBar* _tmp14_;
	GtkBox* _tmp15_;
	GtkBox* _tmp26_;
	GtkWidget* _tmp27_;
	GtkBox* _tmp28_;
	GtkWidget* _tmp29_;
	GtkWidget* _tmp30_;
	GtkWidget* _tmp31_;
	GtkWidget* _tmp32_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (new_game_screen != NULL, NULL);
	g_return_val_if_fail (_view != NULL, NULL);
	self = (GameWindow*) g_object_new (object_type, NULL);
	if (css_resource != NULL) {
		GtkCssProvider* css_provider = NULL;
		GtkCssProvider* _tmp0_;
		GtkCssProvider* _tmp1_;
		GdkScreen* _tmp2_;
		GtkCssProvider* _tmp3_;
		_tmp0_ = gtk_css_provider_new ();
		css_provider = _tmp0_;
		_tmp1_ = css_provider;
		gtk_css_provider_load_from_resource (_tmp1_, css_resource);
		_tmp2_ = gdk_screen_get_default ();
		_tmp3_ = css_provider;
		gtk_style_context_add_provider_for_screen (_tmp2_, (GtkStyleProvider*) _tmp3_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_g_object_unref0 (css_provider);
	}
	_tmp4_ = _g_object_ref0 (_view);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp4_;
	g_action_map_add_action_entries ((GActionMap*) self, GAME_WINDOW_win_actions, G_N_ELEMENTS (GAME_WINDOW_win_actions), self);
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) self, "back");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->back_action);
	self->priv->back_action = _tmp6_;
	_tmp7_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->undo_action);
	self->undo_action = _tmp8_;
	_tmp9_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->redo_action);
	self->redo_action = _tmp10_;
	_tmp11_ = self->priv->back_action;
	g_simple_action_set_enabled (_tmp11_, FALSE);
	_tmp12_ = self->undo_action;
	g_simple_action_set_enabled (_tmp12_, FALSE);
	_tmp13_ = self->redo_action;
	g_simple_action_set_enabled (_tmp13_, FALSE);
	gtk_window_set_title ((GtkWindow*) self, name);
	_tmp14_ = self->priv->headerbar;
	gtk_header_bar_set_title (_tmp14_, name);
	gtk_window_set_default_size ((GtkWindow*) self, width, height);
	if (maximized) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) _game_window_size_allocate_cb_gtk_widget_size_allocate, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "window-state-event", (GCallback) _game_window_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp15_ = self->priv->new_game_box;
	gtk_box_pack_start (_tmp15_, (GtkWidget*) new_game_screen, TRUE, TRUE, (guint) 0);
	if ((flags & GAME_WINDOW_FLAGS_SHOW_START_BUTTON) == GAME_WINDOW_FLAGS_SHOW_START_BUTTON) {
		GtkButton* _tmp16_;
		GtkButton* _tmp17_;
		GtkButton* _tmp18_;
		GtkButton* _tmp19_;
		GtkButton* _tmp20_;
		GtkButton* _tmp21_;
		GtkStyleContext* _tmp22_;
		GtkButton* _tmp23_;
		GtkBox* _tmp24_;
		GtkButton* _tmp25_;
		_tmp16_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Start Game"));
		g_object_ref_sink (_tmp16_);
		_g_object_unref0 (self->priv->start_game_button);
		self->priv->start_game_button = _tmp16_;
		_tmp17_ = self->priv->start_game_button;
		g_object_set ((GtkWidget*) _tmp17_, "width-request", 222, NULL);
		_tmp18_ = self->priv->start_game_button;
		g_object_set ((GtkWidget*) _tmp18_, "height-request", 60, NULL);
		_tmp19_ = self->priv->start_game_button;
		gtk_widget_set_halign ((GtkWidget*) _tmp19_, GTK_ALIGN_CENTER);
		_tmp20_ = self->priv->start_game_button;
		gtk_actionable_set_action_name ((GtkActionable*) _tmp20_, "win.start-game");
		_tmp21_ = self->priv->start_game_button;
		_tmp22_ = gtk_widget_get_style_context ((GtkWidget*) _tmp21_);
		gtk_style_context_add_class (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_style_context_get_type (), GtkStyleContext), "suggested-action");
		_tmp23_ = self->priv->start_game_button;
		gtk_widget_show ((GtkWidget*) _tmp23_);
		_tmp24_ = self->priv->new_game_box;
		_tmp25_ = self->priv->start_game_button;
		gtk_box_pack_end (_tmp24_, (GtkWidget*) _tmp25_, FALSE, FALSE, (guint) 0);
	}
	_tmp26_ = self->priv->game_box;
	_tmp27_ = self->priv->view;
	gtk_box_pack_start (_tmp26_, _tmp27_, TRUE, TRUE, (guint) 0);
	_tmp28_ = self->priv->game_box;
	_tmp29_ = self->priv->view;
	gtk_container_set_focus_child ((GtkContainer*) _tmp28_, _tmp29_);
	_tmp30_ = self->priv->view;
	gtk_widget_set_halign (_tmp30_, GTK_ALIGN_FILL);
	_tmp31_ = self->priv->view;
	gtk_widget_set_can_focus (_tmp31_, TRUE);
	_tmp32_ = self->priv->view;
	gtk_widget_show (_tmp32_);
	if ((flags & GAME_WINDOW_FLAGS_SHOW_UNDO) == GAME_WINDOW_FLAGS_SHOW_UNDO) {
		GtkBox* history_box = NULL;
		GtkBox* _tmp33_;
		GtkBox* _tmp34_;
		GtkStyleContext* _tmp35_;
		GtkButton* undo_button = NULL;
		GtkButton* _tmp36_;
		GtkButton* _tmp37_;
		GtkButton* _tmp38_;
		GtkButton* _tmp39_;
		GtkButton* _tmp40_;
		GtkBox* _tmp41_;
		GtkButton* _tmp42_;
		GtkBox* _tmp43_;
		GtkBox* _tmp44_;
		GtkBox* _tmp45_;
		_tmp33_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
		g_object_ref_sink (_tmp33_);
		history_box = _tmp33_;
		_tmp34_ = history_box;
		_tmp35_ = gtk_widget_get_style_context ((GtkWidget*) _tmp34_);
		gtk_style_context_add_class (_tmp35_, "linked");
		_tmp36_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-undo-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
		g_object_ref_sink (_tmp36_);
		undo_button = _tmp36_;
		_tmp37_ = undo_button;
		gtk_actionable_set_action_name ((GtkActionable*) _tmp37_, "win.undo");
		_tmp38_ = undo_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp38_, _ ("Undo your most recent move"));
		_tmp39_ = undo_button;
		gtk_widget_set_valign ((GtkWidget*) _tmp39_, GTK_ALIGN_CENTER);
		_tmp40_ = undo_button;
		gtk_widget_show ((GtkWidget*) _tmp40_);
		_tmp41_ = history_box;
		_tmp42_ = undo_button;
		gtk_box_pack_start (_tmp41_, (GtkWidget*) _tmp42_, TRUE, TRUE, (guint) 0);
		_tmp43_ = history_box;
		gtk_widget_show ((GtkWidget*) _tmp43_);
		_tmp44_ = self->priv->controls_box;
		_tmp45_ = history_box;
		gtk_box_pack_start (_tmp44_, (GtkWidget*) _tmp45_, TRUE, TRUE, (guint) 0);
		_g_object_unref0 (undo_button);
		_g_object_unref0 (history_box);
	}
	if (start_now) {
		game_window_show_view (self);
	} else {
		game_window_show_new_game_screen (self);
	}
	return self;
}


GameWindow*
game_window_new (const gchar* css_resource,
                 const gchar* name,
                 gint width,
                 gint height,
                 gboolean maximized,
                 gboolean start_now,
                 GameWindowFlags flags,
                 GtkBox* new_game_screen,
                 GtkWidget* _view)
{
	return game_window_construct (TYPE_GAME_WINDOW, css_resource, name, width, height, maximized, start_now, flags, new_game_screen, _view);
}


static void
game_window_size_allocate_cb (GameWindow* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->maximized_state;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = self->priv->tiled_state;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		return;
	}
	gtk_window_get_size ((GtkWindow*) self, &_tmp3_, &_tmp4_);
	self->priv->window_width = _tmp3_;
	self->priv->window_height = _tmp4_;
}


static gboolean
game_window_window_state_event_cb (GameWindow* self,
                                   GdkEventWindowState* event)
{
	gboolean result = FALSE;
	GdkWindowState _tmp0_;
	GdkWindowState _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->changed_mask;
	if ((_tmp0_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkWindowState _tmp1_;
		_tmp1_ = event->new_window_state;
		self->priv->maximized_state = (_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	_tmp2_ = event->changed_mask;
	if ((_tmp2_ & GDK_WINDOW_STATE_TILED) != 0) {
		GdkWindowState _tmp3_;
		_tmp3_ = event->new_window_state;
		self->priv->tiled_state = (_tmp3_ & GDK_WINDOW_STATE_TILED) != 0;
	}
	result = FALSE;
	return result;
}


void
game_window_shutdown (GameWindow* self,
                      GSettings* settings)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	_tmp0_ = self->priv->window_width;
	g_settings_set_int (settings, "window-width", _tmp0_);
	_tmp1_ = self->priv->window_height;
	g_settings_set_int (settings, "window-height", _tmp1_);
	_tmp2_ = self->priv->maximized_state;
	g_settings_set_boolean (settings, "window-is-maximized", _tmp2_);
	gtk_widget_destroy ((GtkWidget*) self);
}


void
game_window_add_to_sidebox (GameWindow* self,
                            GtkWidget* widget)
{
	GtkBox* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->side_box;
	gtk_box_pack_start (_tmp0_, widget, FALSE, FALSE, (guint) 0);
}


void
game_window_cannot_undo_more (GameWindow* self)
{
	GSimpleAction* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->undo_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	_tmp1_ = self->priv->view;
	gtk_widget_grab_focus (_tmp1_);
}


void
game_window_set_subtitle (GameWindow* self,
                          const gchar* subtitle)
{
	GtkHeaderBar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->headerbar;
	gtk_header_bar_set_subtitle (_tmp0_, subtitle);
}


void
game_window_finish_game (GameWindow* self)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->game_finished = TRUE;
	_tmp0_ = self->priv->new_game_button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}


static void
game_window_show_new_game_screen (GameWindow* self)
{
	GtkHeaderBar* _tmp0_;
	GtkStack* _tmp1_;
	GtkBox* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->headerbar;
	gtk_header_bar_set_subtitle (_tmp0_, NULL);
	_tmp1_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp1_, "start-box");
	_tmp2_ = self->priv->controls_box;
	gtk_widget_hide ((GtkWidget*) _tmp2_);
	_tmp4_ = self->priv->game_finished;
	if (!_tmp4_) {
		GtkButton* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->back_button;
		_tmp6_ = gtk_widget_get_visible ((GtkWidget*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GtkButton* _tmp8_;
		_tmp8_ = self->priv->back_button;
		gtk_widget_grab_focus ((GtkWidget*) _tmp8_);
	} else {
		GtkButton* _tmp9_;
		_tmp9_ = self->priv->start_game_button;
		if (_tmp9_ != NULL) {
			GtkButton* _tmp10_;
			_tmp10_ = self->priv->start_game_button;
			gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
		}
	}
}


static void
game_window_show_view (GameWindow* self)
{
	GtkStack* _tmp0_;
	GtkButton* _tmp1_;
	GtkBox* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp0_, "frame");
	_tmp1_ = self->priv->back_button;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->controls_box;
	gtk_widget_show ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->game_finished;
	if (_tmp3_) {
		GtkButton* _tmp4_;
		_tmp4_ = self->priv->new_game_button;
		gtk_widget_grab_focus ((GtkWidget*) _tmp4_);
	} else {
		GtkWidget* _tmp5_;
		_tmp5_ = self->priv->view;
		gtk_widget_grab_focus (_tmp5_);
	}
}


static void
game_window_new_game_cb (GameWindow* self)
{
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	GtkStack* _tmp2_;
	GtkStack* _tmp3_;
	GtkButton* _tmp4_;
	GSimpleAction* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
		return;
	}
	g_signal_emit (self, game_window_signals[GAME_WINDOW_WAIT_SIGNAL], 0);
	_tmp2_ = self->priv->stack;
	gtk_stack_set_transition_type (_tmp2_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT);
	_tmp3_ = self->priv->stack;
	gtk_stack_set_transition_duration (_tmp3_, (guint) 800);
	_tmp4_ = self->priv->back_button;
	gtk_widget_show ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->back_action;
	g_simple_action_set_enabled (_tmp5_, TRUE);
	game_window_show_new_game_screen (self);
}


static void
game_window_start_game_cb (GameWindow* self)
{
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GtkStack* _tmp4_;
	GtkStack* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	if (g_strcmp0 (_tmp1_, "start-box") != 0) {
		return;
	}
	self->priv->game_finished = FALSE;
	_tmp2_ = self->undo_action;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	_tmp3_ = self->redo_action;
	g_simple_action_set_enabled (_tmp3_, FALSE);
	g_signal_emit (self, game_window_signals[GAME_WINDOW_PLAY_SIGNAL], 0);
	_tmp4_ = self->priv->stack;
	gtk_stack_set_transition_type (_tmp4_, GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN);
	_tmp5_ = self->priv->stack;
	gtk_stack_set_transition_duration (_tmp5_, (guint) 1000);
	game_window_show_view (self);
}


static void
game_window_back_cb (GameWindow* self)
{
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	GtkStack* _tmp2_;
	GtkStack* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	if (g_strcmp0 (_tmp1_, "start-box") != 0) {
		return;
	}
	_tmp2_ = self->priv->stack;
	gtk_stack_set_transition_type (_tmp2_, GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT);
	_tmp3_ = self->priv->stack;
	gtk_stack_set_transition_duration (_tmp3_, (guint) 800);
	game_window_show_view (self);
	g_signal_emit (self, game_window_signals[GAME_WINDOW_BACK_SIGNAL], 0);
}


static void
game_window_undo_cb (GameWindow* self)
{
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	GtkButton* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GSimpleAction* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
		return;
	}
	self->priv->game_finished = FALSE;
	_tmp2_ = self->priv->new_game_button;
	g_object_get ((GtkWidget*) _tmp2_, "is-focus", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GtkWidget* _tmp5_;
		_tmp5_ = self->priv->view;
		gtk_widget_grab_focus (_tmp5_);
	}
	_tmp6_ = self->redo_action;
	g_simple_action_set_enabled (_tmp6_, TRUE);
	g_signal_emit (self, game_window_signals[GAME_WINDOW_UNDO_SIGNAL], 0);
}


static void
game_window_redo_cb (GameWindow* self)
{
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	GtkButton* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GSimpleAction* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
		return;
	}
	_tmp2_ = self->priv->new_game_button;
	g_object_get ((GtkWidget*) _tmp2_, "is-focus", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GtkWidget* _tmp5_;
		_tmp5_ = self->priv->view;
		gtk_widget_grab_focus (_tmp5_);
	}
	_tmp6_ = self->undo_action;
	g_simple_action_set_enabled (_tmp6_, TRUE);
	g_signal_emit (self, game_window_signals[GAME_WINDOW_REDO_SIGNAL], 0);
}


static void
game_window_hint_cb (GameWindow* self)
{
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
		return;
	}
	g_signal_emit (self, game_window_signals[GAME_WINDOW_HINT_SIGNAL], 0);
}


static void
game_window_class_init (GameWindowClass * klass)
{
	game_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GameWindow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = game_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/iagno/ui/game-window.ui");
	game_window_signals[GAME_WINDOW_PLAY_SIGNAL] = g_signal_new ("play", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_window_signals[GAME_WINDOW_WAIT_SIGNAL] = g_signal_new ("wait", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_window_signals[GAME_WINDOW_BACK_SIGNAL] = g_signal_new ("back", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_window_signals[GAME_WINDOW_UNDO_SIGNAL] = g_signal_new ("undo", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_window_signals[GAME_WINDOW_REDO_SIGNAL] = g_signal_new ("redo", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_window_signals[GAME_WINDOW_HINT_SIGNAL] = g_signal_new ("hint", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "new_game_button", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, new_game_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_button", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, back_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "controls_box", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, controls_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "game_box", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, game_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "new_game_box", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, new_game_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "side_box", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, side_box));
}


static void
game_window_instance_init (GameWindow * self)
{
	self->priv = game_window_get_instance_private (self);
	self->priv->game_finished = FALSE;
	self->priv->start_game_button = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void
game_window_finalize (GObject * obj)
{
	GameWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_WINDOW, GameWindow);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->start_game_button);
	_g_object_unref0 (self->priv->new_game_button);
	_g_object_unref0 (self->priv->back_button);
	_g_object_unref0 (self->priv->controls_box);
	_g_object_unref0 (self->priv->game_box);
	_g_object_unref0 (self->priv->new_game_box);
	_g_object_unref0 (self->priv->side_box);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->back_action);
	_g_object_unref0 (self->undo_action);
	_g_object_unref0 (self->redo_action);
	G_OBJECT_CLASS (game_window_parent_class)->finalize (obj);
}


GType
game_window_get_type (void)
{
	static volatile gsize game_window_type_id__volatile = 0;
	if (g_once_init_enter (&game_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameWindow), 0, (GInstanceInitFunc) game_window_instance_init, NULL };
		GType game_window_type_id;
		game_window_type_id = g_type_register_static (gtk_application_window_get_type (), "GameWindow", &g_define_type_info, 0);
		GameWindow_private_offset = g_type_add_instance_private (game_window_type_id, sizeof (GameWindowPrivate));
		g_once_init_leave (&game_window_type_id__volatile, game_window_type_id);
	}
	return game_window_type_id__volatile;
}



