<?php
// File           script_end.inc.php / ibWebAdmin
// Purpose        output the whole html source for the page
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <00/10/18 09:12:24 lb>
//
// $Id: script_end.inc.php,v 1.22 2004/05/30 16:43:24 lbrueckner Exp $


// Varibles:   $title    title string for the page
//             $panels   panel array for the page

$title = build_title ($menu_strings[$active]);

echo html_head($title);
echo html_body();

require('./inc/show_menu.inc.php');


// display the panels on the active page
foreach ($panels as $nr => $panel) {

    // take respect for the $HIDE_PANELS configuration
    if (in_array($panel[0], $HIDE_PANELS)
    &&  ($s_login['user'] != 'SYSDBA'  ||  SYSDBA_GET_ALL == FALSE  ||  $s_connected == FALSE)) {

        continue;
    }

    echo '<div id="p'.$nr."\">\n";
    if ($panel[2] == 'open'  ||
        ($panel[0] == 'info'  &&  critical_error())) {

        include('./panels/open_panel.php');
    }
    else {

        echo get_closed_panel($panel[1], $active, $nr, $open_icon);
    }

    echo "</div>\n";
}

echo $js_stack;

if ($s_use_jsrs == TRUE) {
    echo js_jsrs_client();
    echo js_jsrs_close_panel();
}

// close the db connection
if (isset($dbhandle)  &&  is_resource($dbhandle)) {
    // ibase_close() chrashes the apache-process,
    // this was a bug in some revisions of the ibase-module
    //    ibase_close($dbhandle);
}



if (DEBUG === TRUE) {
    echo "<div align=\"left\">\n";

    show_time_consumption($start_time, microtime());

    // see http://xdebug.derickrethans.nl/
    if (function_exists('xdebug_memory_usage')) {
        echo 'memory usage: '.xdebug_memory_usage()."<br>\n";
    }

    // display links to display the session, post or get variables
    $session_url = url_session('./inc/display_variable.php?var=SESSION');
    echo '<a href="'.$session_url.'" target="_blank">[ Session ]</a>'."\n";

    $post_url = url_session('./inc/display_variable.php?var=POST');
    echo '<a href="'.$post_url.'" target="_blank">[ POST ]</a>'."\n";

    $get_url = url_session('./inc/display_variable.php?var=GET');
    echo '<a href="'.$get_url.'" target="_blank">[ GET ]</a>'."\n";

    echo '<a href="./inc/phpinfo.php" target="_blank">[ phpinfo ]</a>'."\n";

    $kill_url = url_session('./inc/kill_session.php');
    echo '<a href="'.$kill_url.'">[ kill session ]</a>'."\n";

    // Inhalt von $_POST und $_GET in der Session hinterlegen
    $s_POST = $HTTP_POST_VARS;
    $s_GET  = $HTTP_GET_VARS;

    echo "</div>\n";
}


if (DEBUG_HTML) {
    $fname = TMPPATH.substr_replace(basename($HTTP_SERVER_VARS['PHP_SELF']), 'html', -3);
    write_output_buffer($fname);

//     if (in_array('tidy', get_loaded_extensions())) {
//         $tidy = tidy_parse_file($fname);
//         debug_var(tidy_get_error_buffer($tidy));
//     }
}


echo html_bottom();

globalize_session_vars();


//
// check the global error-variables
//
function critical_error() {

    return !empty($GLOBALS['error'])  ||
           !empty($GLOBALS['ib_error'])  ||
           !empty($GLOBALS['php_error'])  ||
           !empty($GLOBALS['externcmd']);
}

?>
