<?php
// File           adm_restore.php / ibWebAdmin
// Purpose        restore a database from a backup file
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <02/12/26 12:59:02 lb>
//
// $Id: adm_restore.php,v 1.4 2004/03/07 17:08:37 lbrueckner Exp $

if ($s_connected == TRUE) {

?>
<form method="post" action="<?php echo $HTTP_SERVER_VARS['PHP_SELF']; ?>" name="adm_restore">
<?php hidden_session_field(); ?>
<table border cellpadding="3" cellspacing="0">
<tr>
   <th colspan="2" align="left"><?php echo $adm_strings['RSource']; ?></th>
</tr>
<tr>
   <td>
      <?php echo $adm_strings['FDName']; ?>
   </td>
   <td>
      <?php if (defined('BACKUP_DIR')  &&  BACKUP_DIR !== '') echo BACKUP_DIR.'<br>'; ?>
      <input type="text" size="50" maxlength="256" name="adm_re_source" value="<?php echo $s_restore['source']; ?>">
   </td>
</tr>
<tr>
   <td>
      <?php echo $adm_strings['ServiceMgr']; ?>
   </td>
   <td>
      <input type="text" size="30" maxlength="256" name="adm_re_servicemgr" value="<?php echo $s_restore['servicemgr']; ?>">
   </td>
</tr>
</table>

<table border cellpadding="3" cellspacing="0">
<tr>
   <th colspan="3" align="left"><?php echo $adm_strings['RTarget']; ?></th>
</tr>
<tr>
   <td>
      <?php echo $adm_strings['TargetDB']; ?>
   </td>
   <td colspan="2">
      <input type="text" size="50" maxlength="256" name="adm_re_target" value="<?php echo $s_restore['target']; ?>">
   </td>
</tr>
   <td>
      <input type="radio" name="adm_re_overwrite" value="no"<?php if ($s_restore['overwrite'] == 'no') echo ' checked'; ?>>&nbsp;
      <?php echo  $adm_strings['NewFile']; ?>
   </td>
   <td>
      <input type="radio" name="adm_re_overwrite" value="yes"<?php if ($s_restore['overwrite'] == 'yes') echo ' checked'; ?>>&nbsp;
      <?php echo  $adm_strings['RestFile']; ?>
   </td>
</tr>
<tr>
   <td>
      <?php 
          echo $adm_strings['PageSize'].'&nbsp;';
          echo get_selectlist('adm_re_pagesize', $pagesizes, $s_restore['pagesize'], TRUE);
      ?>
  </td>
  <td>
      <?php echo $adm_strings['Buffers']; ?>&nbsp;
      <input type="text"  size="6" maxlength="5" name="adm_re_buffers" value="<?php echo $s_restore['buffers']; ?>">
  </td>
  <td>
      <?php
         echo $adm_strings['AccessMode'].'&nbsp;';
         echo get_selectlist('adm_re_amode', array($adm_strings['ReadWrite'], $adm_strings['ReadOnly']), $s_restore['amode'], TRUE);
      ?>
   </td>
</tr>
</table>

<table border cellpadding="3" cellspacing="0">
<tr>
   <th align="left"><?php echo $adm_strings['Options']; ?></th>
</tr>
<tr>
   <td>
      <input type="checkbox" name="adm_re_inactive" value="yes"<?php if ($s_restore['inactive'] == 'yes') echo ' checked'; ?>>
      <?php echo $adm_strings['IdxInact']; ?>&nbsp;
   </td>
</tr>
<tr>
   <td>
      <input type="checkbox" name="adm_re_oneattime" value="yes"<?php if ($s_restore['oneattime'] == 'yes') echo ' checked'; ?>>
      <?php echo $adm_strings['OneAtTime']; ?>&nbsp;
   </td>
</tr>
<tr>
   <td>
      <input type="checkbox" name="adm_re_useall" value="yes"<?php if ($s_restore['useall'] == 'yes') echo ' checked'; ?>>
      <?php echo $adm_strings['UseAll']; ?>&nbsp;
   </td>
</tr>
<tr>
   <td>
      <input type="checkbox" name="adm_re_novalidity" value="yes"<?php if ($s_restore['novalidity'] == 'yes') echo ' checked'; ?>>
      <?php echo $adm_strings['NoValidity']; ?>&nbsp;
   </td>
</tr>
<tr>
   <td>
      <input type="checkbox" name="adm_re_kill" value="yes"<?php if ($s_restore['kill'] == 'yes') echo ' checked'; ?>>
      <?php echo $adm_strings['KillShad']; ?>&nbsp;
   </td>
</tr>
</table>
<br>
<input type="checkbox" name="adm_re_connect" value="yes"<?php if ($s_restore['connect'] == 'yes') echo ' checked'; ?>>
<?php echo $adm_strings['ConnAfter']; ?><br><br>

<input type="submit" name="adm_restore_doit" value="<?php echo $button_strings['Restore']; ?>">
</form>

<?php

}

?>
