from string import join
from gtk import *
from GDK import Escape, Return


ICON_STOP = 0
ICON_ALERT = 1
ICON_INFO = 2
ICON_QUESTION = 3


class _MessageBox(GtkDialog):
    def __init__(self, title="Message", message="", buttons=("Ok",),
                 pixmap=ICON_INFO, modal=TRUE):
        """
        message: either a string or a list of strings
        pixmap: either a filename string, or one of: ICON_STOP, ICON_ALERT,
                ICON_INFO or ICON_QUESTION, or None

        """
        GtkDialog.__init__(self)
        self.set_title(title)
        self.connect("destroy", self.quit)
        self.connect("delete_event", self.quit)
        self.connect("key-press-event", self.__press)
        self.modal = modal
        if self.modal:
            grab_add(self)
        hbox = GtkHBox(spacing=5)
        hbox.set_border_width(10)
        self.vbox.pack_start(hbox)
        hbox.show()
        if pixmap:
            self.realize()
            if type(pixmap) == type(""):
                pic = GtkPixmap(self, pixmap)
            else:
                p, m = create_pixmap_from_xpm_d(self, None, icons[pixmap])
                pic = GtkPixmap(p, m)
            pic.set_alignment(0.5, 0.0)
            hbox.pack_start(pic, expand=FALSE)
            pic.show()
        if type(message) == type(""):
            label = GtkLabel(message)
        else:
            label = GtkLabel(join(message, "\n"))
        label.set_justify(JUSTIFY_LEFT)
        hbox.pack_start(label)
        label.show()
        if not buttons:
            buttons = ("Ok",)
        for text in buttons:
            b = GtkButton(text)
            if text == buttons[0]:
                # the first button will always be the default button:
                b.set_flags(CAN_FOCUS|CAN_DEFAULT|HAS_FOCUS|HAS_DEFAULT)
            b.set_flags(CAN_DEFAULT)
            b.set_data("user_data", text)
            b.connect("clicked", self.__click)
            self.action_area.pack_start(b)
            b.show()
        self.default = buttons[0]
        self.ret = None

    def quit(self, *args):
        if self.modal:
            grab_remove(self)
        self.hide()
        self.destroy()
        mainquit()

    def __click(self, button):
        self.ret = button.get_data("user_data")
        self.quit()

    def __press(self, widget, event):
        if event.keyval == GDK.Escape:
            self.quit()
        elif event.keyval == GDK.Return:
            self.ret = self.default
            self.quit()


def message(title="Message", message="", buttons=("Ok",),
            pixmap=ICON_INFO, modal=TRUE):
    "create a message box, and return which button was pressed"
    win = _MessageBox(title, message, buttons, pixmap, modal)
    win.show()
    mainloop()
    return win.ret


################################################################################
# some icons that can be used for the dialog
################################################################################

icon_stop = [
"48 48 5 1",
"  c #000000",
". c #a0a0a4",
"X c #c0c0c0",
"o c #ffffff",
"O c None",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOO        OOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOO            OOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOO                OOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOO                  OOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOO                    .OOOOOOOOOOOOOO",
"OOOOOOOOOOOO                      .OOOOOOOOOOOOO",
"OOOOOOOOOOO                        .OOOOOOOOOOOO",
"OOOOOOOOOO       o          o       .OOOOOOOOOOO",
"OOOOOOOOOO      ooo        ooo      .OOOOOOOOOOO",
"OOOOOOOOO      ooooo      ooooo      .OOOOOOOOOO",
"OOOOOOOOO       ooooo    ooooo       .OOOOOOOOOO",
"OOOOOOOO         ooooo  ooooo         .OOOOOOOOO",
"OOOOOOOO          oooooooooo          .OOOOOOOOO",
"OOOOOOOO           oooooooo           ..OOOOOOOO",
"OOOOOOOO            oooooo            ..OOOOOOOO",
"OOOOOOOO            oooooo            ..OOOOOOOO",
"OOOOOOOO           oooooooo           ..OOOOOOOO",
"OOOOOOOO          oooooooooo          ..OOOOOOOO",
"OOOOOOOO         ooooo  ooooo         ..OOOOOOOO",
"OOOOOOOOO       ooooo    ooooo       ..OOOOOOOOO",
"OOOOOOOOO      ooooo      ooooo      ..OOOOOOOOO",
"OOOOOOOOOO      ooo        ooo      ...OOOOOOOOO",
"OOOOOOOOOO       o          o       ..OOOOOOOOOO",
"OOOOOOOOOOO                        ...OOOOOOOOOO",
"OOOOOOOOOOOO                      ...OOOOOOOOOOO",
"OOOOOOOOOOOO.                    ...OOOOOOOOOOOO",
"OOOOOOOOOOOOO.                  ...OOOOOOOOOOOOO",
"OOOOOOOOOOOOOO.                ...OOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOO..            ....OOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOO..        .....OOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOO...........OOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOO.......OOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO"
]

icon_alert = [
"51 50 5 1",
"  c #000000",
". c #a0a0a4",
"X c #c0c0c0",
"o c #ffffff",
"O c None",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOO   OOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOO ooo OOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOO ooooo .OOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOO ooooo ..OOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOO ooooooo ..OOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOO ooooooo ..OOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOO ooooooooo ..OOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOO ooooooooo ..OOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOO ooooooooooo ..OOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOO oooo   oooo ..OOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOO oooo     oooo ..OOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOO oooo     oooo ..OOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOO ooooo     ooooo ..OOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOO ooooo     ooooo ..OOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOO oooooo     oooooo ..OOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOO oooooo     oooooo ..OOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOO oooooooo   oooooooo ..OOOOOOOOOOOOOOO",
"OOOOOOOOOOOOO oooooooo   oooooooo ..OOOOOOOOOOOOOOO",
"OOOOOOOOOOOO ooooooooo   ooooooooo ..OOOOOOOOOOOOOO",
"OOOOOOOOOOOO oooooooooo oooooooooo ..OOOOOOOOOOOOOO",
"OOOOOOOOOOO ooooooooooo ooooooooooo ..OOOOOOOOOOOOO",
"OOOOOOOOOOO ooooooooooooooooooooooo ..OOOOOOOOOOOOO",
"OOOOOOOOOO oooooooooooo  ooooooooooo ..OOOOOOOOOOOO",
"OOOOOOOOOO ooooooooooo    oooooooooo ..OOOOOOOOOOOO",
"OOOOOOOOO oooooooooooo    ooooooooooo ..OOOOOOOOOOO",
"OOOOOOOOO ooooooooooooo  oooooooooooo ..OOOOOOOOOOO",
"OOOOOOOOO ooooooooooooooooooooooooooo ...OOOOOOOOOO",
"OOOOOOOOO ooooooooooooooooooooooooooo ...OOOOOOOOOO",
"OOOOOOOOOO ooooooooooooooooooooooooo ....OOOOOOOOOO",
"OOOOOOOOOOO                         .....OOOOOOOOOO",
"OOOOOOOOOOOOO...........................OOOOOOOOOOO",
"OOOOOOOOOOOOOO.........................OOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO"
]

icon_info = [
"48 48 5 1",
"  c #000000",
". c #a0a0a4",
"X c #c0c0c0",
"o c #ffffff",
"O c None",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOO........OOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOO...oooooooo...OOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOO..oooooooooooooo..OOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOO.oooooooooooooooooo.OOOOOOOOOOOOOOO",
"OOOOOOOOOOOO.oooooooo    oooooooo OOOOOOOOOOOOOO",
"OOOOOOOOOOO.oooooooo      oooooooo OOOOOOOOOOOOO",
"OOOOOOOOOO.ooooooooo      ooooooooo OOOOOOOOOOOO",
"OOOOOOOOO.ooooooooooo    ooooooooooo OOOOOOOOOOO",
"OOOOOOOOO.oooooooooooooooooooooooooo .OOOOOOOOOO",
"OOOOOOOO.oooooooooooooooooooooooooooo .OOOOOOOOO",
"OOOOOOOO.oooooooooo       ooooooooooo .OOOOOOOOO",
"OOOOOOOO.oooooooooooo     ooooooooooo ..OOOOOOOO",
"OOOOOOOO.oooooooooooo     ooooooooooo ..OOOOOOOO",
"OOOOOOOO.oooooooooooo     ooooooooooo ..OOOOOOOO",
"OOOOOOOO.oooooooooooo     ooooooooooo ..OOOOOOOO",
"OOOOOOOO.oooooooooooo     ooooooooooo ..OOOOOOOO",
"OOOOOOOOO.ooooooooooo     oooooooooo ...OOOOOOOO",
"OOOOOOOOO.ooooooooooo     oooooooooo ...OOOOOOOO",
"OOOOOOOOOO.oooooooooo     ooooooooo ...OOOOOOOOO",
"OOOOOOOOOOO ooooooo         oooooo ....OOOOOOOOO",
"OOOOOOOOOOOO oooooooooooooooooooo ....OOOOOOOOOO",
"OOOOOOOOOOOOO oooooooooooooooooo ....OOOOOOOOOOO",
"OOOOOOOOOOOOOO  oooooooooooooo  ....OOOOOOOOOOOO",
"OOOOOOOOOOOOOOO.   oooooooo   .....OOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOO...   oooo .......OOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOO.... ooo .....OOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOO. ooo ..OOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOO oo ..OOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOO o ..OOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOO  ..OOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOO...OOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOO..OOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO"
]

icon_question = [
"48 48 5 1",
"  c #000000",
". c #a0a0a4",
"X c #c0c0c0",
"o c #ffffff",
"O c None",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOO........OOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOO...oooooooo...OOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOO..oooooooooooooo..OOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOO.oooooooooooooooooo.OOOOOOOOOOOOOOO",
"OOOOOOOOOOOO.oooooooo     ooooooo OOOOOOOOOOOOOO",
"OOOOOOOOOOO.oooooooo oooo  ooooooo OOOOOOOOOOOOO",
"OOOOOOOOOO.oooooooo   oooo  ooooooo OOOOOOOOOOOO",
"OOOOOOOOO.ooooooooo    ooo  oooooooo OOOOOOOOOOO",
"OOOOOOOOO.oooooooooo  ooo   oooooooo .OOOOOOOOOO",
"OOOOOOOO.ooooooooooooooo    ooooooooo .OOOOOOOOO",
"OOOOOOOO.oooooooooooooo    oooooooooo .OOOOOOOOO",
"OOOOOOOO.oooooooooooo      oooooooooo ..OOOOOOOO",
"OOOOOOOO.oooooooooooo     ooooooooooo ..OOOOOOOO",
"OOOOOOOO.oooooooooooo   ooooooooooooo ..OOOOOOOO",
"OOOOOOOO.oooooooooooo  oooooooooooooo ..OOOOOOOO",
"OOOOOOOO.oooooooooooo ooooooooooooooo ..OOOOOOOO",
"OOOOOOOOO.ooooooooooo oooooooooooooo ...OOOOOOOO",
"OOOOOOOOO.oooooooooooooooooooooooooo ...OOOOOOOO",
"OOOOOOOOOO.oooooooooo  oooooooooooo ...OOOOOOOOO",
"OOOOOOOOOOO oooooooo    oooooooooo ....OOOOOOOOO",
"OOOOOOOOOOOO oooooooo  oooooooooo ....OOOOOOOOOO",
"OOOOOOOOOOOOO oooooooooooooooooo ....OOOOOOOOOOO",
"OOOOOOOOOOOOOO  oooooooooooooo  ....OOOOOOOOOOOO",
"OOOOOOOOOOOOOOO.   oooooooo   .....OOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOO...   oooo .......OOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOO.... ooo .....OOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOO. ooo ..OOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOO oo ..OOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOO o ..OOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOO  ..OOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOO...OOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOO..OOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO"
]


icons = [ icon_stop, icon_alert, icon_info, icon_question ]


#############################################################################
# test case
#############################################################################

if __name__ == "__main__":
    ret = message("Test MessageBox #1",
                  ["This is a test for the message box.", "", "Enjoy."])
    print "ret =", ret
    ret = message("Test MessageBox #2",
                  "This is the second test for the message box.\n"
                  "Have fun.\n"
                  "Enjoy.\n"
                  "Stay cool.\n"
                  "\n"
                  "This is getting long, isn't it?\n",
                  ("Ok", "Cancel"),
                  ICON_ALERT,
                  FALSE)
    print "ret =", ret

