#include "fileread.h"

/* read_all_of_file:
 *   Read all of file into memory, returning the allocated memory.
 */
void *
read_all_of_file (FILE *file, int *total_size)
{
	char *memory = NULL;
	int chunk = 32768;
	int size = 0;
	int read;

	do {
		/* allocate more memory */
		memory = realloc(memory, size+chunk);
		if (memory == NULL)
			malloc_failure();

		/* read more */
		read = fread(memory, 1, chunk, file);
		size += read;
	} while (read == chunk);

	/* if eof reached, return memory */
	if (feof(file)) {
		*total_size = size;
		return memory;
	}

	if (memory != NULL)
		free(memory);
	return NULL;
}

/* check_offset:
 *   Check if a chunk of data (determined by offset and size)
 *   is within the bounds of the WinLibrary file.
 *   Usually not called directly.
 */
boolean
check_offset(char *memory, int total_size, char *name, void *offset, int size)
{
	int need_size = (int) ((char *) offset - memory + size);

	debug_printf("check_offset: size=%x vs %x offset=%x size=%x\n",
		need_size, total_size, (char *) offset - memory, size);

	if (need_size < 0 || need_size > total_size) {
		P_OBJ_ERROR(name, "premature end");
		return FALSE;
	}

	return TRUE;
}

/* open_file_stdin:
 *   Open named file for `rb' access. If filename is `-',
 *   open STDIN instead.
 *   Returns FILE, or NULL if open failed (in which case
 *   errors will be printed).
 */
FILE *
open_file_stdin (char *name)
{
	FILE *file;

	if (!strcmp(name, "-")) {
		file = stdin;
		if (file == NULL)
			P_GEN_ERROR("standard input not available");
	} else {
		file = fopen(name, "rb");
		if (file == NULL)
			P_OBJ_SYS_ERROR(name);
	}

	return file;
}
