/* win32-endian.h
 * 
 * Copyright (C) 1998-2001  Oskar Liljeblad
 *
 * This file is part of icoutils.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file "LICENSE" for
 * details.
 */

#ifndef __WIN32_ENDIAN_H__
#define __WIN32_ENDIAN_H__

#include "../common/win32.h"

/*
 *
 * Function declarations
 *
 */

#ifdef WORDS_BIGENDIAN
void fix_win32_cursor_icon_file_dir_endian(Win32CursorIconFileDir *obj);
void fix_win32_bitmap_info_header_endian(Win32BitmapInfoHeader *obj);
void fix_win32_cursor_icon_file_dir_entry_endian(Win32CursorIconFileDirEntry *obj);
void fix_win32_image_data_directory(Win32ImageDataDirectory *obj);
void fix_os2_image_header_endian(OS2ImageHeader *obj);
void fix_win32_image_section_header(Win32ImageSectionHeader *obj);
void fix_win32_image_header_endian(Win32ImageNTHeaders *obj);
#else
#define fix_win32_bitmap_info_header_endian(x)
#define fix_win32_cursor_icon_file_dir_endian(x)
#define fix_win32_cursor_icon_file_dir_entry_endian(x)
#define fix_win32_image_data_directory(x)
#define fix_os2_image_header_endian(x)
#define fix_win32_image_section_header(x)
#define fix_win32_image_header_endian(x)
#endif /* WORDS_BIGENDIAN */

#endif /* __WIN32_ENDIAN_H__ */
