/* vim:tabstop=4:expandtab:shiftwidth=4
 * 
 * Idesk -- DesktopIconConfig.cpp
 *
 * Copyright (c) 2002, Chris (nikon) (nikon@sc.rr.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *      Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *      
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *      
 *      Neither the name of the <ORGANIZATION> nor the names of its
 *      contributors may be used to endorse or promote products derived from
 *      this software without specific prior written permission.
 *
 * (See the included file COPYING / BSD )
 */

#include "DesktopIconConfig.h"

DesktopIconConfig::DesktopIconConfig(const string & fName, CommonOptions * parentData)
{
    iconFilename = fName;

    common = new CommonOptions;
    common->setDefaultsFromParent(*parentData);

    Database *db;
    Table    *table;

    db = new Database(iconFilename);

    if(!(table = db->Query("Icon")))
        delete db;
    else
    {
        common->setOptions(table);
        setIconOptions(table);
        
        delete table;
        delete db;
    }
}

DesktopIconConfig::~DesktopIconConfig()
{
    cout << "HERE!!!\n";
    //No cleanup necessary
}

void DesktopIconConfig::setIconOptions(Table * table)
{
    pictureFilename = table->Query("Icon");
    picExtension = getExtension(pictureFilename);
    caption = table->Query("Caption");
    x = atoi(table->Query("X").c_str());
    y = atoi(table->Query("Y").c_str());
    width = atoi(table->Query("Width").c_str());
    height = atoi(table->Query("Height").c_str());

    if (table->ArrayExists("Command"))
        commandArray = table->QueryArray("Command");
    else if (table->Query("Command") != "")  //for a single command (non-array)
        commandArray.push_back(table->Query("Command"));
}

void DesktopIconConfig::saveIcon(int xCord, int yCord)
{
    x = xCord;
    y = yCord;

    Database *db;
    Table    *table;
    //char     Num[10];

    db = new Database(iconFilename);
    
    if(!(table = db->Query("Icon"))) return;
    
    table->Set("X", itos(xCord));
    table->Set("Y", itos(yCord));
    db->Write();

    delete db;
}

string DesktopIconConfig::getExtension(const string & file)
{
    string returnString;
    int pos = file.rfind('.', file.size() - 1); //search for '.' from the end

    if (pos == string::npos      || //no '.' is string
        pos == (file.size() - 1) || // '.' is at end of string
        pos == file.size() )        // '.' is at beginning of string 
    {
        cout << "Cannot determine file extension of: " << file << endl;
        returnString = "?";
    }
    else  //grab all of the string that is after the '.'
        returnString = getUpper(file.substr(pos + 1, file.size() - pos));

    return returnString;
}

/***************************************************************************\
 * CommonOptions class                                                     *
\***************************************************************************/ 

CommonOptions::CommonOptions()
{
}

CommonOptions::~CommonOptions()
{
    cout << "killing commonOptions\n";
    delete table;
}

void CommonOptions::setCommonDefaults()
{
    fontName = "Arial";
    fontSize = 16;
    fontColor = "#ffffff";

    transparency = 0;
    clickDelay = 200;

    shadowColor = "#000000";
    shadowX = 1;
    shadowY = 1;
    
    isBold = false;

    shadowOn = false;
    snapShadow = false;
    snapShadowTrans = -1;

    captionOnHover = false;
}

void CommonOptions::setDefaultsFromParent(CommonOptions & other)
{
    fontName = other.fontName;
    fontSize = other.fontSize;
    fontColor = other.fontColor;

    transparency = other.transparency;
    clickDelay = other.clickDelay;

    shadowColor = other.shadowColor;
    shadowX = other.shadowX;
    shadowY = other.shadowY;
    
    isBold = other.isBold;

    shadowOn = other.shadowOn;
    snapShadow = other.snapShadow;
    snapShadowTrans = other.snapShadowTrans;

    captionOnHover = other.captionOnHover;
}

void CommonOptions::setOptions(Table * t)
{
    table = t;

    //font options
    if (table->Query("FontName") != "")
        fontName = table->Query("FontName"); 
    if (table->Query("FontSize") != "")
        fontSize = atoi(table->Query("FontSize").c_str()); 
    if (table->Query("FontColor") != "")
        fontColor = table->Query("FontColor"); 

    //transparency
    if (table->Query("Transparency") != "")
        transparency = atoi(table->Query("Transparency").c_str());

    //click options
    if (table->Query("ClickDelay") != "")
        clickDelay = atoi(table->Query("ClickDelay").c_str());

    //shadow fonts
    if (getUpper(table->Query("Shadow")) == "TRUE")
        shadowOn = true;
    else if (getUpper(table->Query("Shadow")) == "FALSE")
        shadowOn = false;

    if (table->Query("ShadowColor") != "")
        shadowColor = table->Query("ShadowColor");
    if (table->Query("ShadowX") != "")
        shadowX = atoi(table->Query("ShadowX").c_str());
    if (table->Query("ShadowY") != "")
        shadowY = atoi(table->Query("ShadowY").c_str());
    
    //boldness
    if (getUpper(table->Query( "Bold" )) == "TRUE")
        isBold = true;
    else if (getUpper(table->Query( "Bold" )) == "FALSE")
        isBold = false;

    //snap shadow
    if (getUpper(table->Query("SnapShadow")) == "TRUE")
        snapShadow = true;
    else if (getUpper(table->Query("SnapShadow")) == "FALSE")
        snapShadow = false;

    if (table->Query("SnapShadowTrans") != "")
        snapShadowTrans = atoi(table->Query("SnapShadowTrans").c_str());

    //captionOnHover
    if (getUpper(table->Query("CaptionOnHover")) == "TRUE")
        captionOnHover = true;
    else if (getUpper(table->Query("CaptionOnHover")) == "FALSE")
        captionOnHover = false;

}   

