/*
 *  IHU -- I Hear U, easy VoIP application using Speex and Qt
 *
 *  Copyright (C) 2003-2008 Matteo Trotta - <mrotta@users.sourceforge.net>
 *
 *  http://ihu.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

#ifndef RING_SOUNDS_H
#define RING_SOUNDS_H

#define SIZE_RING_32 3200

static const short ring_32[SIZE_RING_32] =
{
	0x6d, 0xa56, 0x160b, 0x20de, 0x27c0, 0x2806, 0x2036, 0x1074, 0xfa9c, 0xe200, 
	0xca96, 0xb821, 0xad5c, 0xab6a, 0xb19d, 0xbdd6, 0xcd3c, 0xdcd8, 0xea8a, 0xf54e, 
	0xfd78, 0x453, 0xbad, 0x1512, 0x2170, 0x30aa, 0x4180, 0x520b, 0x5ff7, 0x690e, 
	0x6bc7, 0x65db, 0x5b24, 0x4a28, 0x3536, 0x1f46, 0xb58, 0xfbbf, 0xf1c4, 0xed56, 
	0xed13, 0xee84, 0xef04, 0xec15, 0xe42f, 0xd72d, 0xc663, 0xb437, 0xa3fb, 0x98d4, 
	0x9534, 0x9a4e, 0xa7b0, 0xbb6b, 0xd27d, 0xe96d, 0xfcf9, 0xae9, 0x1262, 0x1406, 
	0x11bb, 0xe43, 0xc81, 0xecc, 0x1674, 0x2365, 0x3440, 0x467e, 0x571a, 0x6313, 
	0x6811, 0x64e7, 0x59bd, 0x4813, 0x3284, 0x1c16, 0x7e3, 0xf843, 0xee7d, 0xea88, 
	0xeb0d, 0xedbe, 0xefda, 0xeedb, 0xe90f, 0xdde2, 0xce43, 0xbc59, 0xab18, 0x9db8, 
	0x96ea, 0x9857, 0xa234, 0xb33d, 0xc8ed, 0xe008, 0xf546, 0x601, 0x10b6, 0x1548, 
	0x14f9, 0x1206, 0xf39, 0xf24, 0x13a2, 0x1d6a, 0x2bd0, 0x3d0b, 0x4e5b, 0x5ccf, 
	0x65b3, 0x6729, 0x6094, 0x52ab, 0x3f67, 0x2993, 0x144a, 0x248, 0xf572, 0xee61, 
	0xec61, 0xed7d, 0xef2c, 0xeeb6, 0xea0a, 0xe035, 0xd1a0, 0xc023, 0xae82, 0xa004, 
	0x9794, 0x972a, 0x9f56, 0xaf1e, 0xc43f, 0xdb85, 0xf19e, 0x3ab, 0xfe6, 0x15cd, 
	0x1661, 0x1393, 0x1015, 0xe81, 0x10e5, 0x1862, 0x24c2, 0x34bb, 0x45f8, 0x55b6, 
	0x612f, 0x6632, 0x6395, 0x5958, 0x48d2, 0x3454, 0x1ed1, 0xb26, 0xfbb0, 0xf1ba, 
	0xed36, 0xecd2, 0xee35, 0xeec4, 0xebfc, 0xe467, 0xd7bb, 0xc740, 0xb564, 0xa54d, 
	0x9a2d, 0x966d, 0x9b47, 0xa84c, 0xbbb8, 0xd28a, 0xe968, 0xfd2a, 0xb93, 0x13a9, 
	0x15da, 0x13dd, 0x102b, 0xd80, 0xe32, 0x13bb, 0x1e7f, 0x2d74, 0x3eac, 0x4f7f, 
	0x5d02, 0x64c6, 0x6522, 0x5dac, 0x4f36, 0x3bc7, 0x2628, 0x1162, 0x16, 0xf40f, 
	0xedbe, 0xec47, 0xedaa, 0xef29, 0xee34, 0xe8bc, 0xde04, 0xcec2, 0xbcf5, 0xaba8, 
	0x9e1e, 0x9733, 0x989f, 0xa29c, 0xb3dd, 0xc9c7, 0xe108, 0xf64a, 0x6e9, 0x1161, 
	0x159c, 0x14dd, 0x115f, 0xde0, 0xce6, 0x105d, 0x1901, 0x2673, 0x3710, 0x486e, 
	0x57b3, 0x622a, 0x65d2, 0x61af, 0x5610, 0x447e, 0x2f7a, 0x1a04, 0x6f4, 0xf884, 
	0xefb1, 0xec33, 0xec6d, 0xedf6, 0xee08, 0xea5a, 0xe1a2, 0xd3fa, 0xc2f4, 0xb149, 
	0xa234, 0x98d7, 0x9759, 0x9e8d, 0xadb1, 0xc28b, 0xd9ef, 0xf07b, 0x327, 0xffb, 
	0x1652, 0x170b, 0x1401, 0xfea, 0xd72, 0xecf, 0x1540, 0x20d4, 0x305c, 0x41a3, 
	0x51ed, 0x5e64, 0x64b4, 0x6370, 0x5a67, 0x4ab2, 0x368b, 0x20d7, 0xc88, 0xfc38, 
	0xf161, 0xec31, 0xeb83, 0xed1b, 0xee3f, 0xec5b, 0xe5b7, 0xd9d8, 0xc9ce, 0xb7f1, 
	0xa76d, 0x9b77, 0x96b7, 0x9a8a, 0xa6cb, 0xb9c1, 0xd08f, 0xe7d9, 0xfc59, 0xbab, 
	0x14a3, 0x178c, 0x15ed, 0x1224, 0xeef, 0xec1, 0x1336, 0x1cd7, 0x2af0, 0x3bad, 
	0x4c83, 0x5a9d, 0x636c, 0x651a, 0x5ef7, 0x51a7, 0x3eea, 0x2972, 0x143e, 0x21a, 
	0xf4fa, 0xed95, 0xeb40, 0xec29, 0xedb7, 0xed2e, 0xe872, 0xde89, 0xcfef, 0xbe79, 
	0xad19, 0x9f1f, 0x9763, 0x97da, 0xa0eb, 0xb179, 0xc706, 0xde55, 0xf40c, 0xd1c, 
	0x1493, 0x1640, 0x13ec, 0x101a, 0xd74, 0xe49, 0x1400, 0x1ed3, 0x2dcc, 0x3eef, 
	0x4f80, 0x5cbf, 0x6435, 0x644e, 0x5c9c, 0x4e04, 0x3a8f, 0x2508, 0x1066, 0xff59, 
	0xf38d, 0xed70, 0xec12, 0xed5a, 0xeea1, 0xed40, 0xe743, 0xdc17, 0xcc76, 0xba9d, 
	0xa996, 0x9cb1, 0x96ad, 0x992b, 0xa440, 0xb669, 0xcce6, 0xe45d, 0xf97d, 0x9a7, 
	0x1384, 0x1722, 0x15eb, 0x1229, 0xe9d, 0xdd6, 0x1194, 0x1a87, 0x282c, 0x38cf, 
	0x49eb, 0x58b3, 0x6275, 0x6540, 0x6041, 0x53d8, 0x41b5, 0x2c69, 0x16f4, 0x436, 
	0xf63e, 0xee07, 0xeb0e, 0xebb0, 0xed65, 0xed5a, 0xe969, 0xe04e, 0xd24b, 0xc11e, 
	0xaf81, 0xa0cc, 0x980c, 0x9756, 0x9f60, 0xaf3c, 0xc49a, 0xdc41, 0xf2bf, 0x520, 
	0x1182, 0x176c, 0x17c4, 0x1495, 0x1089, 0xe50, 0x1012, 0x16f6, 0x22eb, 0x32a2, 
	0x43da, 0x53cb, 0x5fa2, 0x64e5, 0x5e2f, 0x5053, 0x3d45, 0x27b5, 0x12aa, 0xdc, 
	0xf42c, 0xed2b, 0xeb24, 0xec2a, 0xed92, 0xecb6, 0xe78d, 0xdd37, 0xce45, 0xbcb9, 
	0xab78, 0x9ddc, 0x96be, 0x97e8, 0xa1b5, 0xb2d8, 0xc8d3, 0xe055, 0xf5fe, 0x71d, 
	0x1212, 0x16bb, 0x163b, 0x12ca, 0xf1a, 0xdb9, 0x10aa, 0x18cc, 0x25be, 0x360e, 
	0x474d, 0x56ae, 0x6177, 0x658c, 0x61e3, 0x56ae, 0x4562, 0x3076, 0x1ade, 0x787, 
	0xf8b3, 0xef7f, 0xebba, 0xebd4, 0xed70, 0xedc7, 0xea7d, 0xe22d, 0xd4e2, 0xc40a, 
	0xb245, 0xa2d1, 0x98d2, 0x968e, 0x9cfa, 0xab74, 0xbfe2, 0xd72f, 0xeded, 0x10f, 
	0xe7d, 0x1579, 0x16aa, 0x13ef, 0xfe3, 0xd3d, 0xe44, 0x1458, 0x1f9b, 0x2efa, 
	0x4056, 0x50e9, 0x5ddb, 0x64c0, 0x6404, 0x5b71, 0x4bfb, 0x37d8, 0x21e8, 0xd43, 
	0xfc76, 0xf12e, 0xebb0, 0xeae6, 0xeca0, 0xee25, 0xecc6, 0xe6b0, 0xdb4c, 0xcb82, 
	0xb999, 0xa8b4, 0x9c1c, 0x968f, 0x998e, 0xa51b, 0xb7a2, 0xce51, 0xe5c8, 0xfab1, 
	0xa7c, 0x13ea, 0x170f, 0x1569, 0x1156, 0xda3, 0xcd6, 0x10bc, 0x19fd, 0x27f1, 
	0x38d8, 0x4a27, 0x58e6, 0x626f, 0x64d2, 0x5f49, 0x5259, 0x3fbf, 0x2a32, 0x14bc, 
	0x23e, 0xf4bf, 0xed0c, 0xea99, 0xeb97, 0xed69, 0xed4c, 0xe913, 0xdfa0, 0xd151, 
	0xbfec, 0xae58, 0x9fda, 0x9780, 0x9748, 0x9fc9, 0xafff, 0xc58c, 0xdd2a, 0xf372, 
	0x57e, 0x1176, 0x16fa, 0x16ff, 0x139d, 0xf8a, 0xd74, 0xf76, 0x16b5, 0x2307, 
	0x330e, 0x447b, 0x5476, 0x602b, 0x6556, 0x62b9, 0x585e, 0x4792, 0x32b9, 0x1cd1, 
	0x8d8, 0xf92f, 0xef35, 0xead0, 0xeaa4, 0xec5b, 0xed2a, 0xea9c, 0xe328, 0xd68d, 
	0xc621, 0xb45a, 0xa468, 0x9986, 0x9621, 0x9b60, 0xa8d3, 0xbc94, 0xd3b5, 0xeabe, 
	0xfe99, 0xcfa, 0x14f3, 0x1706, 0x14d7, 0x10f3, 0xe17, 0xe93, 0x13ef, 0x1e7d, 
	0x2d54, 0x3e75, 0x4f3a, 0x5cbe, 0x647f, 0x64d5, 0x5d4d, 0x4ebe, 0x3b21, 0x2549, 
	0x1043, 0xfeba, 0xf278, 0xebfb, 0xea64, 0xeba8, 0xed24, 0xec2d, 0xe6c2, 0xdc26, 
	0xcd0a, 0xbb72, 0xaa75, 0x9d3a, 0x96a3, 0x9862, 0xa2b0, 0xb439, 0xca60, 0xe1d2, 
	0xf743, 0x803, 0x128e, 0x16d3, 0x1605, 0x126d, 0xeb5, 0xd87, 0x10bd, 0x1931, 
	0x2676, 0x36f6, 0x4845, 0x5776, 0x61d1, 0x6549, 0x60e2, 0x54f4, 0x4311, 0x2dc9, 
	0x182f, 0x527, 0xf6f2, 0xee7c, 0xeb77, 0xec32, 0xee27, 0xee84, 0xeaf8, 0xe243, 
	0xd477, 0xc339, 0xb14a, 0xa200, 0x9868, 0x96c8, 0x9dee, 0xad14, 0xc1fe, 0xd985, 
	0xf032, 0x2fe, 0xfe6, 0x1650, 0x16fe, 0x13df, 0xfa2, 0xd03, 0xe37, 0x1495, 
	0x2028, 0x2fc5, 0x412e, 0x51a3, 0x5e45, 0x64a8, 0x6364, 0x5a42, 0x4a64, 0x360e, 
	0x2021, 0xbb5, 0xfb55, 0xf07c, 0xeb65, 0xead4, 0xec8c, 0xedcf, 0xec03, 0xe568, 
	0xd991, 0xc98e, 0xb7ab, 0xa723, 0x9b38, 0x967d, 0x9a64, 0xa6bc, 0xb9cc, 0xd0bf, 
	0xe821, 0xfcb4, 0xc03, 0x14e9, 0x17a7, 0x15c1, 0x11bf, 0xe4f, 0xe00, 0x1276, 
	0x1c36, 0x2a87, 0x3b92, 0x4ca6, 0x5ae2, 0x63a6, 0x6521, 0x5ea6, 0x50e0, 0x3daf, 
	0x27d7, 0x1270, 0x4b, 0xf34d, 0xec2f, 0xea3d, 0xeb86, 0xed62, 0xed10, 0xe871, 
	0xde8e, 0xcfde, 0xbe53, 0xace0, 0x9ec7, 0x970f, 0x979a, 0xa0e1, 0xb1b1, 0xc79b, 
	0xdf4e, 0xf562, 0x709, 0x1291, 0x17a3, 0x1764, 0x13f5, 0x1010, 0xe50, 0x10cf, 
	0x187d, 0x2524, 0x3546, 0x468c, 0x5615, 0x6121, 0x657f, 0x620f, 0x5706, 0x45bd, 
	0x30b6, 0x1af1, 0x75a, 0xf849, 0xeedf, 0xeaf9, 0xeb15, 0xeccb, 0xed5f, 0xea58, 
	0xe254, 0xd542, 0xc485, 0xb2b7, 0xa31d, 0x98cf, 0x9639, 0x9c4d, 0xaa89, 0xbee4, 
	0xd64b, 0xed53, 0xdf, 0xec1, 0x162b, 0x17ac, 0x151e, 0x1106, 0xe34, 0xef6, 
	0x14b2, 0x1fad, 0x2edf, 0x4029, 0x50d5, 0x5e02, 0x6533, 0x64d8, 0x5c92, 0x4d63, 
	0x3965, 0x236c, 0xe9d, 0xfd81, 0xf1d7, 0xebe7, 0xeabb, 0xec31, 0xed92, 0xec3d, 
	0xe651, 0xdb2c, 0xcba2, 0xb9e6, 0xa90b, 0x9c4f, 0x9670, 0x990a, 0xa421, 0xb64a, 
	0xccc1, 0xe42e, 0xf948, 0x975, 0x1364, 0x1716, 0x15e9, 0x1239, 0xeb8, 0xdfb, 
	0x11ce, 0x1adc, 0x28a0, 0x3962, 0x4a93, 0x5955, 0x62fa, 0x6589, 0x6032, 0x536e, 
	0x40f2, 0x2b66, 0x15df, 0x333, 0xf576, 0xed93, 0xeafc, 0xebf3, 0xeddc, 0xedf8, 
	0xea0d, 0xe0e1, 0xd2c4, 0xc16b, 0xafa7, 0xa0c8, 0x97e0, 0x9701, 0x9ee4, 0xae9c, 
	0xc3da, 0xdb74, 0xf1f2, 0x45f, 0x10d9, 0x16d6, 0x173f, 0x140c, 0x1000, 0xdc2, 
	0xf80, 0x166d, 0x2277, 0x3255, 0x43ba, 0x53d7, 0x5fc5, 0x6546, 0x62ff, 0x58ed, 
	0x4858, 0x339d, 0x1daf, 0x9a0, 0xf9dc, 0xefc9, 0xeb60, 0xeb4f, 0xed3b, 0xee5e, 
	0xec28, 0xe505, 0xd8a0, 0xc832, 0xb639, 0xa5e0, 0x9a6c, 0x966c, 0x9b13, 0xa816, 
	0xbba0, 0xd2c4, 0xea02, 0xfe2f, 0xcf5, 0x153c, 0x1772, 0x1540, 0x1125, 0xdec, 
	0xdfa, 0x12fa, 0x1d3d, 0x2bfa, 0x3d33, 0x4e30, 0x5c15, 0x644d, 0x6516, 0x5def, 
	0x4f9e, 0x3c25, 0x2644, 0x111b, 0xff60, 0xf2e3, 0xec37, 0xea88, 0xebd9, 0xed7c, 
	0xecc6, 0xe7a0, 0xdd49, 0xce4f, 0xbcb8, 0xab81, 0x9def, 0x96e4, 0x981f, 0xa205, 
	0xb33f, 0xc947, 0xe0da, 0xf686, 0x79d, 0x1290, 0x1730, 0x16a2, 0x132f, 0xf7e, 
	0xe37, 0x114e, 0x199b, 0x26c7, 0x3739, 0x487c, 0x57b1, 0x621d, 0x65a9, 0x6154, 
	0x556b, 0x438d, 0x2e39, 0x1881, 0x551, 0xf6d9, 0xee26, 0xeae4, 0xeb6e, 0xed4b, 
	0xedbb, 0xea5e, 0xe1e5, 0xd465, 0xc366, 0xb192, 0xa231, 0x985d, 0x9652, 0x9cfb, 
	0xabaf, 0xc040, 0xd79f, 0xee60, 0x17a, 0xed7, 0x15c8, 0x16f3, 0x144e, 0x105b, 
	0xde0, 0xf20, 0x156e, 0x20dd, 0x305c, 0x41b0, 0x5223, 0x5ec6, 0x6542, 0x6420, 
	0x5b28, 0x4b73, 0x3738, 0x215e, 0xce9, 0xfc6e, 0xf167, 0xec0f, 0xeb39, 0xecb8, 
	0xedd4, 0xec00, 0xe574, 0xd9be, 0xc9cf, 0xb800, 0xa760, 0x9b37, 0x9619, 0x997e, 
	0xa551, 0xb7f2, 0xce95, 0xe5e4, 0xfa90, 0xa29, 0x1370, 0x168b, 0x14fa, 0x1121, 
	0xdc1, 0xd5d, 0x11ae, 0x1b50, 0x298f, 0x3a9e, 0x4bda, 0x5a5d, 0x6379, 0x655e, 
	0x5f48, 0x51dd, 0x3ef8, 0x2951, 0x13fa, 0x1c3, 0xf49f, 0xed52, 0xeb1e, 0xec39, 
	0xedf5, 0xed9f, 0xe912, 0xdf4d, 0xd0bc, 0xbf3f, 0xadac, 0x9f5a, 0x972e, 0x9722, 
	0x9fc2, 0xaff3, 0xc55e, 0xdcb4, 0xf2b0, 0x46a, 0x1020, 0x1584, 0x1588, 0x1249, 
	0xe7d, 0xcc7, 0xf3a, 0x16e4, 0x2393, 0x33d6, 0x4559, 0x5534, 0x60a9, 0x656f, 
	0x6260, 0x5799, 0x4684, 0x318d, 0x1bc1, 0x80e, 0xf8d9, 0xef61, 0xeb73, 0xeba1, 
	0xed8b, 0xee67, 0xebb8, 0xe407, 0xd72d, 0xc67c, 0xb483, 0xa47c, 0x9997, 0x963a, 
	0x9b88, 0xa911, 0xbced, 0xd416, 0xeb22, 0xfeee, 0xd3a, 0x1513, 0x16f9, 0x149b, 
	0x108d, 0xd8d, 0xe06, 0x136e, 0x1e2b, 0x2d2e, 0x3e81, 0x4f5c, 0x5cdb, 0x646e, 
	0x647d, 0x5c95, 0x4da5, 0x39c9, 0x23e1, 0xefb, 0xfdca, 0xf1f4, 0xebf5, 0xeabe, 
	0xec3e, 0xedbc, 0xec96, 0xe6e1, 0xdbec, 0xcc85, 0xbac6, 0xa9bf, 0x9cb4, 0x966a, 
	0x9880, 0xa323, 0xb4ef, 0xcb31, 0xe29b, 0xf7e4, 0x864, 0x12a7, 0x16a9, 0x15b4, 
	0x120d, 0xe76, 0xd7f, 0x1108, 0x19d9, 0x2775, 0x3837, 0x498e, 0x589a, 0x629d, 
	0x6597, 0x6099, 0x541c, 0x41be, 0x2c2b, 0x1676, 0x37a, 0xf560, 0xed16, 0xea26, 
	0xeadc, 0xecb6, 0xecea, 0xe938, 0xe061, 0xd29f, 0xc18d, 0xafeb, 0xa0f4, 0x97bb, 
	0x9658, 0x9da6, 0xacc3, 0xc192, 0xd8e9, 0xef69, 0x217, 0xf08, 0x1588, 0x1673, 
	0x13ae, 0xfd5, 0xda2, 0xf40, 0x15fd, 0x21d3, 0x3190, 0x42f9, 0x533b, 0x5f7b, 
	0x6558, 0x6380, 0x59cd, 0x4974, 0x34da, 0x1edd, 0xa98, 0xfa7f, 0xeffe, 0xeb29, 
	0xeac3, 0xec6f, 0xed87, 0xeb71, 0xe489, 0xd870, 0xc852, 0xb67f, 0xa622, 0x9a6f, 
	0x95ef, 0x99ff, 0xa65d, 0xb95a, 0xd01d, 0xe746, 0xfb9c, 0xac4, 0x138f, 0x164f, 
	0x1482, 0x10a3, 0xd71, 0xd62, 0x121d, 0x1c26, 0x2aba, 0x3bef, 0x4d1e, 0x5b53, 
	0x63f8, 0x6537, 0x5e7e, 0x507a, 0x3d27, 0x2748, 0x11f5, 0xfff7, 0xf338, 0xec46, 
	0xea67, 0xeba5, 0xed52, 0xecbe, 0xe7dd, 0xddc4, 0xceff, 0xbd7b, 0xac33, 0x9e52, 
	0x96df, 0x9796, 0xa0ec, 0xb1b4, 0xc774, 0xdee8, 0xf4b4, 0x612, 0x1160, 0x164c, 
	0x15f8, 0x1294, 0xec9, 0xd48, 0x1016, 0x1823, 0x2529, 0x35a6, 0x4726, 0x56b8, 
	0x61a5, 0x65b3, 0x61d4, 0x5649, 0x4493, 0x2f3d, 0x1959, 0x5dc, 0xf706, 0xedf6, 
	0xea6a, 0xead5, 0xecb4, 0xed53, 0xea48, 0xe22f, 0xd508, 0xc443, 0xb27a, 0xa2ee, 
	0x98b3, 0x9620, 0x9c29, 0xaa44, 0xbe6c, 0xd596, 0xec5b, 0xffb4, 0xd77, 0x14cc, 
	0x165c, 0x13e6, 0xffa, 0xd5c, 0xe5b, 0x1461, 0x1f9f, 0x2f04, 0x4074, 0x5127, 
	0x5e28, 0x6515, 0x6457, 0x5ba9, 0x4c1b, 0x37dd, 0x21d3, 0xd1a, 0xfc3f, 0xf0e1, 
	0xeb3f, 0xea46, 0xebca, 0xed12, 0xeb88, 0xe565, 0xda0d, 0xca70, 0xb8c7, 0xa815, 
	0x9b94, 0x95f7, 0x98c4, 0xa3f1, 0xb613, 0xcc6b, 0xe3b2, 0xf8a2, 0x8b5, 0x128f, 
	0x1642, 0x1523, 0x118f, 0xe38, 0xdad, 0x11b4, 0x1afe, 0x28f4, 0x39e7, 0x4b33, 
	0x59f9, 0x6384, 0x65e2, 0x6048, 0x533f, 0x4086, 0x2acd, 0x1536, 0x28c, 0xf4e4, 
	0xed07, 0xea6c, 0xeb3e, 0xecf7, 0xecc8, 0xe889, 0xdf2d, 0xd0fd, 0xbfbf, 0xae40, 
	0x9fc5, 0x9749, 0x96c9, 0x9ee6, 0xaea1, 0xc3b4, 0xdaf1, 0xf102, 0x310, 0xf4e, 
	0x1550, 0x15f0, 0x132d, 0xf92, 0xdaf, 0xf8f, 0x164e, 0x21d7, 0x3108, 0x41cb, 
	0x518d, 0x5db8, 0x640e, 0x631e, 0x5a98, 0x4b1f, 0x3676, 0x1eea, 0x71e, 0xf18a, 
	0xe010, 0xd3d2, 0xccf7, 0xcaea, 0xcc6d, 0xd01a, 0xd486, 0xd8b2, 0xdc07, 0xde76, 
	0xe04d, 0xe1fe, 0xe400, 0xe69e, 0xe9e7, 0xeda5, 0xf19c, 0xf566, 0xf8b9, 0xfb6d, 
	0xfd7c, 0xfee9, 0xffd0, 0x45, 0x58, 0x21, 0xffa6, 0xfef7, 0xfe40, 0xfda9, 
	0xfd63, 0xfd86, 0xfe24, 0xff2d, 0x86, 0x1e8, 0x330, 0x431, 0x4d9, 0x531, 
	0x557, 0x578, 0x5c1, 0x64f, 0x72e, 0x85b, 0x9b4, 0xb0e, 0xc3d, 0xd11, 
	0xd70, 0xd4a, 0xca0, 0xb8e, 0xa32, 0x8bb, 0x753, 0x620, 0x53d, 0x498, 
	0x430, 0x3de, 0x37a, 0x2d7, 0x1dd, 0x8c, 0xfee6, 0xfd19, 0xfb53, 0xf9d1, 
	0xf8bb, 0xf825, 0xf813, 0xf87c, 0xf928, 0xf9e9, 0xfa93, 0xfafd, 0xfb1b, 0xfae5, 
	0xfa81, 0xf9fd, 0xf98d, 0xf958, 0xf96d, 0xf9d5, 0xfa91, 0xfb85, 0xfc98, 0xfd9a, 
	0xfe6c, 0xfeff, 0xff4a, 0xff4c, 0xff1f, 0xfee6, 0xfebe, 0xfec1, 0xff0c, 0xff98, 
	0x5b, 0x137, 0x205, 0x2a4, 0x2f7, 0x2f5, 0x2a2, 0x212, 0x163, 0xbc, 
	0x47, 0x15, 0x2f, 0x80, 0xfe, 0x17a, 0x1d2, 0x1ee, 0x1b4, 0x13b, 
	0x8f, 0xffd7, 0xff42, 0xfee7, 0xfee2, 0xff1e, 0xff8e, 0xfffa, 0x4a, 0x60, 
	0x34, 0xffe3, 0xff8f, 0xff5f, 0xff6e, 0xffc3, 0x3e, 0xb2, 0xf2, 0xec, 
	0xad, 0x6a, 0x75, 0x10f, 0x244, 0x3e4, 0x56b, 0x630, 0x598, 0x34b, 
	0xff92, 0xfb54, 0xf7e5, 0xf6db, 0xf97d, 0x4e, 0xab1, 0x16f1, 0x2267, 0x2a2a, 
	0x2ba4, 0x2551, 0x1740, 0x312, 0xebbb, 0xd4c9, 0xc1ac, 0xb4e7, 0xaf83, 0xb127, 
	0xb821, 0xc230, 0xcd07, 0xd6f6, 0xdf34, 0xe5e1, 0xebe9, 0xf251, 0xfa13, 0x391, 
	0xeb5, 0x1ad9, 0x271d, 0x32bd, 0x3d19, 0x45ef, 0x4d57, 0x535e, 0x57ff, 0x5b03, 
	0x5bee, 0x5a17, 0x54ed, 0x4c19, 0x3fb4, 0x3052, 0x1eff, 0xd1b, 0xfc0a, 0xed23, 
	0xe152, 0xd927, 0xd4a5, 0xd353, 0xd459, 0xd691, 0xd8be, 0xd9a7, 0xd850, 0xd427, 
	0xcd15, 0xc393, 0xb8b8, 0xade8, 0xa4cd, 0x9ef0, 0x9d89, 0xa145, 0xaa0f, 0xb73a, 
	0xc780, 0xd94f, 0xeb06, 0xfb35, 0x8cc, 0x133d, 0x1a6a, 0x1e9b, 0x2065, 0x2078, 
	0x1f97, 0x1e86, 0x1df8, 0x1e9c, 0x20e8, 0x2555, 0x2bf9, 0x34aa, 0x3ed7, 0x498f, 
	0x53a4, 0x5bb1, 0x607d, 0x6114, 0x5cef, 0x5434, 0x4785, 0x37f7, 0x26f1, 0x15e1, 
	0x60c, 0xf87c, 0xedcb, 0xe63a, 0xe1ab, 0xdfa2, 0xdf7a, 0xe049, 0xe109, 0xe0b0, 
	0xde5c, 0xd960, 0xd18a, 0xc735, 0xbb44, 0xaf2b, 0xa497, 0x9d3f, 0x9a94, 0x9d65, 
	0xa5b5, 0xb2d7, 0xc34d, 0xd55e, 0xe730, 0xf71d, 0x418, 0xd98, 0x13b6, 0x1700, 
	0x183a, 0x185e, 0x1853, 0x18d7, 0x1a96, 0x1e05, 0x2377, 0x2af1, 0x3441, 0x3edd, 
	0x49d5, 0x5402, 0x5c18, 0x60de, 0x615d, 0x5d2a, 0x5460, 0x47c6, 0x387c, 0x27f3, 
	0x1796, 0x898, 0xfbdf, 0xf1d8, 0xeaa8, 0xe614, 0xe3b3, 0xe2e8, 0xe2fb, 0xe31e, 
	0xe26f, 0xe00c, 0xdb53, 0xd3e2, 0xc9e2, 0xbe12, 0xb1be, 0xa6a8, 0x9e91, 0x9b0b, 
	0x9d10, 0xa4c0, 0xb178, 0xc1b4, 0xd3ab, 0xe567, 0xf540, 0x22c, 0xbbb, 0x1213, 
	0x15cc, 0x17b9, 0x189a, 0x191d, 0x19bd, 0x1ae9, 0x1cf5, 0x2044, 0x2534, 0x2bf4, 
	0x3486, 0x3e80, 0x491b, 0x5324, 0x5b3b, 0x6004, 0x607d, 0x5c17, 0x52f8, 0x45db, 
	0x35fa, 0x24d2, 0x13e4, 0x481, 0xf799, 0xedb7, 0xe6f9, 0xe30a, 0xe164, 0xe12f, 
	0xe16b, 0xe10f, 0xdf1d, 0xdacc, 0xd3be, 0xca02, 0xbe5f, 0xb217, 0xa6d0, 0x9e52, 
	0x9a2a, 0x9b52, 0xa214, 0xadd2, 0xbd47, 0xceb8, 0xe053, 0xf06d, 0xfdf1, 0x85c, 
	0xfb1, 0x1469, 0x1730, 0x18ac, 0x1983, 0x1a1d, 0x1aea, 0x1c56, 0x1eb8, 0x2294, 
	0x2848, 0x2fff, 0x3980, 0x4418, 0x4ebb, 0x57f8, 0x5e56, 0x609a, 0x5e00, 0x566c, 
	0x4a71, 0x3b2d, 0x2a20, 0x18e6, 0x8e9, 0xfb42, 0xf096, 0xe91d, 0xe4a6, 0xe297, 
	0xe237, 0xe289, 0xe285, 0xe125, 0xdd9d, 0xd760, 0xce5f, 0xc325, 0xb6c6, 0xaac4, 
	0xa0f2, 0x9aeb, 0x99ee, 0x9e92, 0xa883, 0xb6c1, 0xc7b2, 0xd971, 0xea48, 0xf8df, 
	0x477, 0xcde, 0x126b, 0x15bc, 0x1790, 0x1885, 0x1928, 0x19d6, 0x1afb, 0x1ced, 
	0x201f, 0x24fa, 0x2bc3, 0x347c, 0x3eaa, 0x496c, 0x5383, 0x5b79, 0x5ffc, 0x5ff7, 
	0x5aff, 0x514b, 0x43a6, 0x3369, 0x2217, 0x112c, 0x20b, 0xf591, 0xec3f, 0xe621, 
	0xe2e9, 0xe1e2, 0xe227, 0xe2a0, 0xe228, 0xdfc7, 0xdabd, 0xd2bb, 0xc819, 0xbbb6, 
	0xaf17, 0xa407, 0x9c46, 0x9959, 0x9c0a, 0xa45e, 0xb176, 0xc1d6, 0xd3a1, 0xe4f0, 
	0xf447, 0xb7, 0x9ec, 0x1024, 0x1406, 0x1646, 0x179b, 0x188b, 0x197c, 0x1ac6, 
	0x1ca9, 0x1f89, 0x23ce, 0x29d9, 0x31b5, 0x3b35, 0x45a1, 0x4fde, 0x5888, 0x5e3b, 
	0x5fca, 0x5c99, 0x548f, 0x484f, 0x38fe, 0x2811, 0x170d, 0x74f, 0xf9e1, 0xef62, 
	0xe810, 0xe3b2, 0xe1d0, 0xe19f, 0xe221, 0xe244, 0xe0f5, 0xdd4b, 0xd6c4, 0xcd62, 
	0xc1bf, 0xb515, 0xa917, 0x9f97, 0x9a4c, 0x9a5c, 0xa02b, 0xab4a, 0xba69, 0xcbd4, 
	0xdd96, 0xedef, 0xfbad, 0x628, 0xd73, 0x1203, 0x14a2, 0x1616, 0x1704, 0x17f1, 
	0x1931, 0x1b14, 0x1de3, 0x21fe, 0x27b2, 0x2f33, 0x3859, 0x42a7, 0x4d29, 0x569c, 
	0x5d99, 0x60df, 0x60a5, 0x5c4b, 0x532b, 0x460d, 0x361d, 0x24e0, 0x13e0, 0x474, 
	0xf796, 0xedc2, 0xe722, 0xe367, 0xe1f5, 0xe1e9, 0xe251, 0xe209, 0xe012, 0xdba5, 
	0xd45a, 0xca5c, 0xbe76, 0xb1ef, 0xa686, 0x9e10, 0x9a0c, 0x9b8c, 0xa2b2, 0xaeed, 
	0xbece, 0xd092, 0xe245, 0xf255, 0xff9b, 0x9a2, 0x1089, 0x14de, 0x1752, 0x18ae, 
	0x198d, 0x1a5a, 0x1b73, 0x1d22, 0x1fcd, 0x23ce, 0x2989, 0x311e, 0x3a64, 0x44b3, 
	0x4f16, 0x5823, 0x5e6b, 0x60c1, 0x5e5a, 0x5716, 0x4b72, 0x3c82, 0x2bba, 0x1aa3, 
	0xaaa, 0xfcec, 0xf216, 0xea5c, 0xe5a8, 0xe372, 0xe2f8, 0xe344, 0xe346, 0xe1fc, 
	0xde83, 0xd83f, 0xcf33, 0xc3da, 0xb745, 0xab12, 0xa10f, 0x9aed, 0x99f9, 0x9eb5, 
	0xa8e1, 0xb771, 0xc8ad, 0xdab4, 0xebba, 0xfa60, 0x5dd, 0xe0e, 0x135b, 0x165e, 
	0x17f0, 0x18b8, 0x1942, 0x1a04, 0x1b48, 0x1d7a, 0x20f5, 0x2619, 0x2d21, 0x3606, 
	0x4046, 0x4afd, 0x54f2, 0x5ca7, 0x60d2, 0x6072, 0x5b2a, 0x5132, 0x436f, 0x3336, 
	0x2213, 0x117d, 0x2c5, 0xf6b5, 0xedca, 0xe7fc, 0xe4e2, 0xe3d6, 0xe3f3, 0xe428, 
	0xe362, 0xe0b4, 0xdb65, 0xd33e, 0xc888, 0xbc26, 0xaf82, 0xa468, 0x9c94, 0x9988, 
	0x9c0e, 0xa43b, 0xb13a, 0xc18e, 0xd361, 0xe4dd, 0xf45d, 0x101, 0xa5f, 0x10b7, 
	0x149a, 0x16d3, 0x1820, 0x1905, 0x19fb, 0x1b58, 0x1d58, 0x206a, 0x24e5, 0x2b14, 
	0x331d, 0x3cba, 0x4744, 0x5197, 0x5a56, 0x6015, 0x61b0, 0x5e6e, 0x564f, 0x49e6, 
	0x3a59, 0x292b, 0x17f3, 0x812, 0xfa9b, 0xf035, 0xe901, 0xe4d1, 0xe307, 0xe2cb, 
	0xe31d, 0xe2e2, 0xe11a, 0xdcf6, 0xd600, 0xcc4c, 0xc085, 0xb3e6, 0xa819, 0x9ee4, 
	0x99ed, 0x9a4d, 0xa061, 0xabb2, 0xbaff, 0xcc90, 0xde7d, 0xef10, 0xfd15, 0x7df, 
	0xf84, 0x1466, 0x1744, 0x18de, 0x19d7, 0x1aa9, 0x1bb4, 0x1d42, 0x1fb4, 0x2362, 
	0x28b3, 0x2fda, 0x38c4, 0x42e9, 0x4d57, 0x56cb, 0x5dd0, 0x6121, 0x5fcd, 0x5994, 
	0x4ec5, 0x4055, 0x2fa6, 0x1e48, 0xdb1, 0xff16, 0xf353, 0xeac3, 0xe553, 0xe2a3, 
	0xe1f4, 0xe25a, 0xe2bc, 0xe204, 0xdf40, 0xd9bb, 0xd148, 0xc650, 0xb9d5, 0xad5b, 
	0xa2c3, 0x9bc8, 0x99e0, 0x9db7, 0xa725, 0xb538, 0xc64d, 0xd873, 0xe9ce, 0xf8e8, 
	0x4d8, 0xd74, 0x130d, 0x1655, 0x1816, 0x1906, 0x19b7, 0x1a96, 0x1be6, 0x1dfe, 
	0x2139, 0x25eb, 0x2c67, 0x34b4, 0x3e7a, 0x48ed, 0x52e0, 0x5af8, 0x5fc4, 0x6043, 
	0x5bdf, 0x52ba, 0x4599, 0x35b3, 0x248f, 0x13b0, 0x46e, 0xf7b8, 0xee1e, 0xe7a9, 
	0xe41e, 0xe2dc, 0xe301, 0xe38d, 0xe368, 0xe191, 0xdd30, 0xd5e3, 0xcbce, 0xbfb8, 
	0xb2f0, 0xa740, 0x9e76, 0x9a32, 0x9b7b, 0xa284, 0xaea6, 0xbe8a, 0xd052, 0xe21e, 
	0xf234, 0xff7b, 0x979, 0x1048, 0x1479, 0x16d0, 0x1809, 0x18cb, 0x198c, 0x1aa3, 
	0x1c65, 0x1f2d, 0x2356, 0x2937, 0x30f7, 0x3a58, 0x44ca, 0x4f38, 0x584f, 0x5ea3, 
	0x60f7, 0x5e8c, 0x574b, 0x4ba7, 0x3cb6, 0x2be6, 0x1ac3, 0xab1, 0xfcd6, 0xf1dc, 
	0xea0b, 0xe53b, 0xe2f7, 0xe272, 0xe2c7, 0xe2e3, 0xe1ae, 0xde52, 0xd832, 0xcf38, 
	0xc3ee, 0xb75e, 0xab30, 0xa127, 0x9b06, 0x9a0a, 0x9ec7, 0xa8ee, 0xb778, 0xc8a7, 
	0xda99, 0xeb83, 0xfa0d, 0x56f, 0xd93, 0x12e0, 0x15fe, 0x17ba, 0x18cb, 0x19a3, 
	0x1aaf, 0x1c44, 0x1ea3, 0x223b, 0x2755, 0x2e42, 0x36f1, 0x40f6, 0x4b74, 0x5532, 
	0x5cc2, 0x60d3, 0x6069, 0x5b18, 0x5119, 0x4354, 0x3300, 0x21c2, 0x110a, 0x223, 
	0xf5e5, 0xecda, 0xe6e4, 0xe3b3, 0xe299, 0xe2ab, 0xe2e3, 0xe22c, 0xdf97, 0xda7a, 
	0xd278, 0xc7f1, 0xbbbe, 0xaf46, 0xa44d, 0x9c8b, 0x9984, 0x9c05, 0xa42c, 0xb125, 
	0xc185, 0xd373, 0xe515, 0xf4d8, 0x1b7, 0xb56, 0x11de, 0x15eb, 0x1833, 0x196e, 
	0x1a49, 0x1b29, 0x1c66, 0x1e59, 0x2162, 0x25cf, 0x2c05, 0x33fc, 0x3d80, 0x47d0, 
	0x51d5, 0x5a2e, 0x5f87, 0x60b7, 0x5d24, 0x54bc, 0x4832, 0x389e, 0x2784, 0x166a, 
	0x6a7, 0xf949, 0xeef0, 0xe7c3, 0xe399, 0xe1de, 0xe1be, 0xe241, 0xe24b, 0xe0d5, 
	0xdd0f, 0xd667, 0xcced, 0xc150, 0xb4bc, 0xa8e6, 0x9f93, 0x9a84, 0x9ac2, 0xa0c1, 
	0xac08, 0xbb51, 0xcce5, 0xded4, 0xef5b, 0xfd44, 0x7ed, 0xf5c, 0x1404, 0x16a5, 
	0x1807, 0x18d5, 0x1992, 0x1a95, 0x1c34, 0x1ec5, 0x22a5, 0x282b, 0x2f85, 0x388a, 
	0x42c0, 0x4d28, 0x567d, 0x5d50, 0x6061, 0x5ee4, 0x5882, 0x4da1, 0x3f3e, 0x2eb4, 
	0x1d8c, 0xd3d, 0xfef2, 0xf379, 0xeb23, 0xe5e5, 0xe34d, 0xe2a6, 0xe301, 0xe34a, 
	0xe272, 0xdf88, 0xd9e9, 0xd164, 0xc663, 0xb9e9, 0xad76, 0xa2d3, 0x9bca, 0x99be, 
	0x9d5c, 0xa685, 0xb453, 0xc520, 0xd716, 0xe84e, 0xf76c, 0x371, 0xc25, 0x11de, 
	0x153b, 0x170f, 0x1808, 0x18c4, 0x19ac, 0x1b20, 0x1d6b, 0x20e7, 0x25eb, 0x2cac, 
	0x3535, 0x3f1f, 0x4998, 0x5379, 0x5b6c, 0x6019, 0x6072, 0x5c00, 0x52d8, 0x45c7, 
	0x35f7, 0x24f7, 0x1422, 0x4e7, 0xf829, 0xee6f, 0xe7cf, 0xe407, 0xe286, 0xe267, 
	0xe2b5, 0xe25a, 0xe056, 0xdbdc, 0xd491, 0xca90, 0xbea0, 0xb20d, 0xa68d, 0x9deb, 
	0x99c0, 0x9b0f, 0xa20c, 0xae24, 0xbdf6, 0xcfbe, 0xe18c, 0xf1bd, 0xff2d, 0x956, 
	0x104c, 0x14a0, 0x170b, 0x1846, 0x1909, 0x19cf, 0x1ae9, 0x1cbd, 0x1f9b, 0x23df, 
	0x29db, 0x31a8, 0x3b0e, 0x4563, 0x4fa5, 0x587c, 0x5e84, 0x6099, 0x5dea, 0x5671, 
	0x4aa9, 0x3ba7, 0x2ad8, 0x19c6, 0x9d4, 0xfc18, 0xf141, 0xe98e, 0xe4da, 0xe29a, 
	0xe21d, 0xe262, 0xe264, 0xe120, 0xddaa, 0xd77e, 0xce84, 0xc341, 0xb6d7, 0xaad1, 
	0xa0f8, 0x9afd, 0x9a28, 0x9f05, 0xa93d, 0xb7c9, 0xc901, 0xdaf6, 0xebeb, 0xfa88, 
	0x605, 0xe3b, 0x139a, 0x16ba, 0x1870, 0x195b, 0x1a15, 0x1afe, 0x1c67, 0x1eae, 
	0x223a, 0x2764, 0x2e56, 0x3712, 0x4121, 0x4b8c, 0x5524, 0x5c74, 0x6038, 0x5f6e, 
	0x59c6, 0x4f7e, 0x417a, 0x3117, 0x1fd9, 0xf40, 0x89, 0xf499, 0xebd2, 0xe627, 
	0xe341, 0xe26b, 0xe2b4, 0xe320, 0xe28d, 0xe00e, 0xdaf5, 0xd2fb, 0xc86f, 0xbc2e, 
	0xafb2, 0xa4b2, 0x9cf7, 0x99f9, 0x9c89, 0xa4b5, 0xb1a8, 0xc1f0, 0xd3b6, 0xe51c, 
	0xf49b, 0x13a, 0xa92, 0x10f1, 0x14d7, 0x1713, 0x1851, 0x1929, 0x1a0c, 0x1b4e, 
	0x1d3c, 0x203f, 0x24aa, 0x2adf, 0x32e5, 0x3c7b, 0x46f5, 0x512b, 0x59be, 0x5f48, 
	0x609b, 0x5d1f, 0x54c8, 0x4838, 0x38a3, 0x2781, 0x1663, 0x6ac, 0xf96b, 0xef34, 
	0xe839, 0xe42c, 0xe285, 0xe268, 0xe2db, 0xe2be, 0xe115, 0xdd17, 0xd63c, 0xcca5, 
	0xc0f5, 0xb45d, 0xa88c, 0x9f44, 0x9a27, 0x9a56, 0xa03c, 0xab5b, 0xba82, 0xcbf5, 
	0xddce, 0xee60, 0xfc63, 0x736, 0xed7, 0x13b4, 0x1688, 0x180d, 0x18f6, 0x19c5, 
	0x1ae0, 0x1c91, 0x1f3b, 0x2336, 0x28d3, 0x303a, 0x394d, 0x4381, 0x4dd8, 0x5713, 
	0x5dcc, 0x60c0, 0x5f1e, 0x58a2, 0x4da1, 0x3f21, 0x2e7c, 0x1d3f, 0xcdb, 0xfe7f, 
	0xf2f4, 0xea96, 0xe54c, 0xe2b2, 0xe202, 0xe25e, 0xe2a2, 0xe1cd, 0xdeee, 0xd958, 
	0xd0e3, 0xc5fd, 0xb996, 0xad3a, 0xa2a9, 0x9bad, 0x999d, 0x9d36, 0xa65e, 0xb41f, 
	0xc4f1, 0xd6f6, 0xe84c, 0xf78a, 0x3bd, 0xca9, 0x1295, 0x161a, 0x1806, 0x190d, 
	0x19c8, 0x1aa3, 0x1c00, 0x1e2c, 0x2186, 0x2671, 0x2d1b, 0x358a, 0x3f61, 0x49cc, 
	0x5397, 0x5b66, 0x5fe4, 0x600c, 0x5b5a, 0x51f2, 0x44a2, 0x3499, 0x236a, 0x1288, 
	0x34d, 0xf69f, 0xed05, 0xe69a, 0xe305, 0xe1b2, 0xe1c1, 0xe22b, 0xe1e7, 0xdff2, 
	0xdb89, 0xd44a, 0xca5e, 0xbe7e, 0xb209, 0xa6a2, 0x9e16, 0x9a03, 0x9b5a, 0xa257, 
	0xae6d, 0xbe38, 0xcff4, 0xe1c4, 0xf1fe, 0xff7b, 0x9b5, 0x10c2, 0x1522, 0x1790, 
	0x18d1, 0x1980, 0x1a2d, 0x1b33, 0x1ceb, 0x1fb9, 0x23f2, 0x29ee, 0x31bd, 0x3b22, 
	0x4580, 0x4fbd, 0x588e, 0x5e83, 0x6075, 0x5db0, 0x5613, 0x4a32, 0x3b1e, 0x2a41, 
	0x1932, 0x953, 0xfbb4, 0xf105, 0xe982, 0xe4fb, 0xe2ed, 0xe29b, 0xe2fe, 0xe315, 
	0xe1da, 0xde5b, 0xd826, 0xcf19, 0xc3c7, 0xb746, 0xab24, 0xa133, 0x9b1e, 0x9a2e, 
	0x9eec, 0xa90c, 0xb786, 0xc8b0, 0xdaa5, 0xeba1, 0xfa4a, 0x5d2, 0xe15, 0x1378, 
	0x1698, 0x1844, 0x192a, 0x19dd, 0x1ac2, 0x1c3f, 0x1ea7, 0x2257, 0x27a5, 0x2ec4, 
	0x379a, 0x41ad, 0x4c1a, 0x55a2, 0x5ce4, 0x608e, 0x5c90, 0x53fa, 0x474c, 0x37b4, 
	0x26a9, 0x15b0, 0x626, 0xf905, 0xeef0, 0xe801, 0xe403, 0xe260, 0xe23c, 0xe2a6, 
	0xe285, 0xe0db, 0xdcd7, 0xd605, 0xcc76, 0xc0d0, 0xb450, 0xa88f, 0x9f64, 0x9a6b, 
	0x9abf, 0xa0bc, 0xabef, 0xbb29, 0xccad, 0xde9c, 0xef3b, 0xfd50, 0x835, 0xfde, 
	0x14c6, 0x1793, 0x1912, 0x19e0, 0x1a95, 0x1b90, 0x1d26, 0x1fb8, 0x23aa, 0x293f, 
	0x30a5, 0x39b4, 0x43e0, 0x4e21, 0x5738, 0x5dbb, 0x6078, 0x5e93, 0x57cf, 0x4ca0, 
	0x3dfc, 0x2d45, 0x1c0c, 0xbbd, 0xfd81, 0xf224, 0xe9ef, 0xe4d2, 0xe253, 0xe1c2, 
	0xe227, 0xe273, 0xe19f, 0xdeba, 0xd929, 0xd0bf, 0xc5e4, 0xb98e, 0xad4e, 0xa2dc, 
	0x9bf7, 0x9a08, 0x9daf, 0xa6e2, 0xb4aa, 0xc57d, 0xd772, 0xe8c0, 0xf7f3, 0x41c, 
	0xcf6, 0x12d1, 0x164d, 0x1822, 0x1913, 0x19ba, 0x1a89, 0x1bd5, 0x1dfb, 0x2161, 
	0x264d, 0x2d11, 0x3595, 0x3f78, 0x49e6, 0x53b2, 0x5b70, 0x5fdc, 0x5fdc, 0x5b09, 
	0x5189, 0x4427, 0x3422, 0x2300, 0x1242, 0x33b, 0xf6c8, 0xed71, 0xe73c, 0xe3d3, 
	0xe290, 0xe2a2, 0xe2fc, 0xe28d, 0xe06d, 0xdbd5, 0xd46f, 0xca68, 0xbe80, 0xb206, 
	0xa6a5, 0x9e2a, 0x9a18, 0x9b6d, 0xa268, 0xae6d, 0xbe24, 0xcfd1, 0xe19b, 0xf1d4, 
	0xff56, 0x9a4, 0x10c3, 0x1531, 0x17b1, 0x18f9, 0x19b9, 0x1a6b, 0x1b7d, 0x1d49, 
	0x202c, 0x2480, 0x2a8a, 0x3265, 0x3bcc, 0x461b, 0x5046, 0x58f8, 0x5ecb, 0x60a7, 
	0x5dc8, 0x561c, 0x4a21, 0x3af4, 0x29fb, 0x18c9, 0x8c8, 0xfb0b, 0xf04d, 0xe8ca, 
	0xe44a, 0xe24c, 0xe1f6, 0xe259, 0xe25c, 0xe0f9, 0xdd6f, 0xd72a, 0xce3d, 0xc321, 
	0xb6ea, 0xab19, 0xa160, 0x9b57, 0x9a46, 0x9ebf, 0xa8a6, 0xb70a, 0xc863, 0xdadd, 
	0xec8f, 0xfbd9, 0x7ae, 0xfa1, 0x13e8, 0x1551, 0x1506, 0x1450, 0x1457, 0x1601, 
	0x19c2, 0x1f83, 0x26c4, 0x2e9f, 0x360f, 0x3bfe, 0x3fa7, 0x408e, 0x3ec4, 0x3ab1, 
	0x3529, 0x2f00, 0x2919, 0x240a, 0x2000, 0x1ce8, 0x1a55, 0x17c9, 0x14d2, 0x1124, 
	0xccb, 0x7fd, 0x324, 0xfea1, 0xfacc, 0xf7cd, 0xf584, 0xf3c9, 0xf24f, 0xf0e3, 
	0xef56, 0xedaf, 0xec06, 0xea7d, 0xe93c, 0xe860, 0xe7df, 0xe7b3, 0xe7af, 0xe7cd, 
	0xe7f4, 0xe821, 0xe868, 0xe8d9, 0xe982, 0xea75, 0xeba7, 0xed10, 0xeea7, 0xf049, 
	0xf1fc, 0xf3b1, 0xf565, 0xf71c, 0xf8db, 0xfa9c, 0xfc5b, 0xfe18, 0xffc8, 0x161, 
	0x2da, 0x437, 0x568, 0x66f, 0x753, 0x80b, 0x899, 0x90e, 0x966, 0x9b0, 
	0x9e6, 0xa17, 0xa3d, 0xa53, 0xa52, 0xa36, 0x9f9, 0x999, 0x919, 0x880, 
	0x7d9, 0x72d, 0x683, 0x5db, 0x549, 0x4bf, 0x442, 0x3d1, 0x362, 0x2fd, 
	0x298, 0x22e, 0x1ba, 0x142, 0xc6, 0x4c, 0xffda, 0xff75, 0xff2d, 0xff05, 
	0xfefb, 0xff0f, 0xff37, 0xff55, 0xff74, 0xff75, 0xff60, 0xff35, 0x2, 0x0, 
	0xffff, 0x1, 0x1, 0x0, 0x0, 0xffff, 0x2, 0x0, 0xffff, 0x0, 
	0x3, 0xffff, 0xfffe, 0x1, 0x1, 0xffff, 0x2, 0x1, 0xffff, 0x0
};

#endif
