/* IIWU Synth  A soundfont synthesizer
 *
 * Copyright (C)  2001 Peter Hanappe
 * Author: Peter Hanappe, peter@hanappe.com
 *
 * This file is part of the IIWU program. 
 * IIWU is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 *
 */
#ifndef _IIWUSYNTH_PRIV_H
#define _IIWUSYNTH_PRIV_H

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#ifdef WIN32
#include "config_win32.h"
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "iiwusynth.h"


typedef enum {
  IIWU_OK = 0,
  IIWU_FAILED = 1
} iiwu_status;


/***************************************************************
 *
 *                      SYSTEM INTERFACE
 */
typedef FILE*  iiwu_file;

#define IIWU_MALLOC(n)              malloc(n)
#define IIWU_NEW(t)                 (t*)malloc(sizeof(t))
#define IIWU_ARRAY(t,n)             (t*)malloc(n*sizeof(t))
#define IIWU_FREE(p)                free(p)
#define IIWU_FOPEN(f,m)             fopen(f,m)
#define IIWU_FCLOSE(f)              fclose(f)
#define IIWU_FREAD(p,s,n,f)         fread(p,s,n,f)
#define IIWU_FSEEK(f,n,set)         fseek(f,n,set)
#define IIWU_MEMCPY(dst,src,n)      memcpy(dst,src,n)
#define IIWU_MEMSET(s,c,n)          memset(s,c,n)
#define IIWU_STRLEN(s)              strlen(s)                  
#define IIWU_STRCMP(s,t)            strcmp(s,t)
#define IIWU_STRNCMP(s,t,n)         strncmp(s,t,n)
#define IIWU_STRCPY(dst,src)        strcpy(dst,src)
#define IIWU_SPRINTF                sprintf

#if WITH_FTS
#define IIWU_PRINTF                 post
#else
#define IIWU_PRINTF                 printf
#endif


#if DEBUG
#define IIWU_LOG                    IIWU_PRINTF("%s:%d: ", __FILE__, __LINE__); iiwu_log
#else
#define IIWU_LOG                    iiwu_log
#endif

#define IIWU_ASSERT(a,b)
#define IIWU_ASSERT_P(a,b)

/***************************************************************
 *
 *                   LOG
 */

enum iiwu_log_level { 
  PANIC,   /* the synth can't function correctly any more */
  ERR,     /* the synth can function, but with serious limitation */
  WARN,    /* the synth might not function as expected */
  DBG      /* debugging messages */
};

int iiwu_log(int level, char * fmt, ...);

#ifdef WIN32
/** Get the handle to the instance of the application. Returns
    whatever was set by iiwu_set_hinstance. */
void* iiwu_get_hinstance(void);
#endif

#endif /* _IIWUSYNTH_PRIV_H */
