""" Group picker implementation

    begin                : Sat Dec 14 2002
    author               : (C) 2002 by Ricardo Niederberger Cabral
    email                : nieder|at|mail.ru
    $Id: GroupPickerWnd.py,v 1.18 2003/09/07 14:00:06 niederberger Exp $        

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
__version__ = "$Revision: 1.18 $"

from string import *
import time,traceback

import Error

try:
    from qt import *
except:
    Error.qtImportError()
try:
    from GroupPickerForm import GroupPickerForm
#    import Settings        
except:
    print "GroupPickerForm: Unable to import some imgSeek modules. Some features will not work."

class GroupPickerWnd(GroupPickerForm):
    def __init__(self,parent,callback,env): 
        GroupPickerForm.__init__(self, parent,"",1)
        self.env = env
        self.curdb = self.env.curdb
        self.callback = callback
        self.group = -1
        self.BrowseCategListView.clear()
        for gid in self.curdb.groups.keys():
            self.groupCombo.insertItem(self.curdb.groups[gid][0])
            if self.curdb.groups[gid][2]==-1: #root group
                self.addGroupToView(self.BrowseCategListView,gid)
        
        self.show()
    def addGroupToView(self,parent,gid):
        lvi = QListViewItem(parent,self.curdb.groups[gid][0],str(len(self.curdb.groups[gid][3]))+" file(s) / "+str(len(self.curdb.groups[gid][4]))+" group(s)")
        lvi.groupid = gid
        lvi.setPixmap(0,self.env.wnd.bookicon)
        for chid in self.curdb.groups[gid][4]:
            try:
                self.addGroupToView(lvi,chid)
            except:
                traceback.print_exc()
    def okbtn_clicked(self):
        self.callback(self.group)
        self.close()
    def groupCombo_activated(self,a0):
        self.group = self.curdb.groups.keys()[a0]
    def createGroupbtn_clicked(self):
        text = str(QInputDialog.getText("imgSeek","New group name:" ,QLineEdit.Normal, time.asctime(time.localtime()))[0])
        if text:            
            nid = self.curdb.newGroup(text)
            if  nid == -1:
                QMessageBox.information( self,"Group name already exists. Please try another.")
                return                              
            self.addGroupToView(self.BrowseCategListView,nid)
            self.groupCombo.insertItem(text)
            self.groupCombo.setCurrentText(text)            
    def BrowseCategListView_clicked(self,a0):
        if not a0:return
        self.group = a0.groupid
        self.groupCombo.setCurrentText(self.curdb.groups[self.group][0])
