# -*- coding: iso-8859-1 -*-
""" Transform editor implementation

    begin                : Sat Dec 14 2002
    author               : (C) 2002 by Ricardo Niederberger Cabral
    email                : nieder|at|mail.ru
    $Id: TransformWnd.py,v 1.41 2004/05/01 15:26:16 niederberger Exp $

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
__version__ = "$Revision: 1.41 $"

from string import *
import traceback,os
import Error

try:
    from qt import *
except:
    Error.qtImportError()
try:
    from TransformForm import *
    from Transforms import Transforms
except:
    print "Unable to import some imgSeek modules. Some features will not work."
try:
    import imgdb
except:
    traceback.print_exc()
    print "Warning: Unable to load the C++ extension \"imgdb.so\" module. Make sure you installed imgSeek correctly, and email any install bug to \"imgseek-devel@lists.sourceforge.net\"."

class TransformWnd(TransformForm):
    def __init__(self, parent,env,ifile = None):
        self.env = env
        self.curdb = self.env.curdb
        TransformForm.__init__(self, parent)
        self.imgIdx = 0
        self.callback = None
        self.curfid = None
        self.curfidname = None
        self.curdb.cbs["Batch"].append(self.syncBatchCombo)
        self.curBatch = -1
        self.syncBatchCombo()
        if ifile: # requested file to be shown immediately
            self.showFile(ifile)
        else: #simple show first file on dbase
            self.showFile(self.curdb.meta.keys()[0])
        # Generic controls
        self.controls = [[self.slideLabel1,self.slider1,self.value1Edit],
                       [self.slideLabel2,self.slider2,self.value2Edit],
                       [self.slideLabel3,self.slider3,self.value3Edit],
                       [self.textLabel1,self.lineEdit1],
                       [self.comboLabel1,self.comboBox1],
                       [self.comboLabel2,self.comboBox2],
                       [self.checkBox1],
                       [self.checkBox2]
                       ]
        self.intControls = [0,1,2]        # index of the controls on self.controls that can control ints
        self.textControls = [3]
        self.checkControls = [6,7]
        self.comboControls = [4,5]

        self.initTransforms()
        self.saveMenu = QPopupMenu(self)
        self.saveMenu.insertItem ( self.parent().globalslide.iconSet(),"&Preview with full size", self.onPreviewFull )
        self.saveMenu.insertSeparator()
        self.saveMenu.insertItem ( self.parent().fileSaveAction.iconSet(),"&Overwrite file", self.onSave )
        self.saveMenu.insertItem ( self.parent().fileSaveAsAction.iconSet(), "&Save as another file", self.onSaveAs )

    def initTransforms(self):
        self.transform = Transforms(self)
        self.transformList = self.transform.getTransforms()
        for t in self.transformList:
            self.transfCombo.insertItem(t[0])
        self.setupTransform(0)

    def setupTransform(self,t):
        """ hide controls according to transform being done. t is an index in the list of transforms returned by tf.getTransforms()
        also set callback
        """
        self.callback = self.transformList[t][1]

        for sli in self.controls:
            for cl in sli:
                cl.hide()
        intCount = 0
        textCount = 0
        comboCount = 0
        for sl in self.transformList[t][2]:
            if sl[0]=="Int":
                for cl in self.controls[self.intControls[intCount]]: cl.show()
                self.controls[self.intControls[intCount]][0].setText(sl[1])
		self.controls[self.intControls[intCount]][1].setMinValue(sl[2])
		self.controls[self.intControls[intCount]][1].setMaxValue(sl[3])
                intCount = intCount+1
            if sl[0]=="Text":
                for cl in self.controls[self.textControls[textCount]]: cl.show()
                self.controls[self.textControls[textCount]][0].setText(sl[1])
                textCount = textCount+1
            if sl[0]=="Combo":
                for cl in self.controls[self.comboControls[comboCount]]: cl.show()
                self.controls[self.comboControls[comboCount]][1].clear()
                for prm in sl[2]:
                    self.controls[self.comboControls[comboCount]][1].insertItem(prm)
                self.controls[self.comboControls[comboCount]][0].setText(sl[1])
                comboCount = comboCount+1
        self.callback()

    def showFile(self,fid):
        """show thumbnail of a file

        @param fid: file id
        """
        if not fid: return
        if type(fid)==int:              # show db image
            self.imgIdx = self.curdb.img.keys().index(fid)
            self.curfid = fid
            self.curfidname = self.curdb.img[fid][0]
            self.indexLabel.setText(str(self.imgIdx+1)+" / "+str(len(self.curdb.img.keys())))
            self.thumbLabel.setPixmap(QPixmap(self.curdb.getThumbDB(fid)))
        else:                           # show system image
            self.imgIdx = 0
            self.curfid = 0
            self.curfidname = fid
            self.indexLabel.setText(fid)
            self.thumbLabel.setPixmap(QPixmap(self.curdb.getThumb(self.curfidname)))
        if self.callback:self.callback()

    def previousBtn_clicked(self):
        self.imgIdx = self.imgIdx-1
        if self.imgIdx<0:self.imgIdx = len(self.curdb.img.keys()) -1
        self.showFile(self.curdb.img.keys()[self.imgIdx])

    def nextButton_clicked(self):
        self.imgIdx = self.imgIdx+1
        if self.imgIdx>=len(self.curdb.img.keys()):
            self.imgIdx = 0
        self.showFile(self.curdb.img.keys()[self.imgIdx])

    def syncBatchCombo(self,what = None):
        """call it to sync curdb batch list to what the ui shows """
        self.batchcombo.clear()
        for bid in self.curdb.batches.keys():
            self.batchcombo.insertItem(self.curdb.batches[bid][0])

    def onSave(self):
        filename = self.curdb.img[self.curfid][0]

        (base,ext) = os.path.splitext(filename)
        fext = ext[1:].lower()

        origfname = filename[:]
        if fext in self.env.magick_ext:
            imgdb.convert(self.curfidname,self.env.curdb.thdir2+".cache.bmp")
            filename = self.env.curdb.thdir2+".cache.bmp"

        self.callback(a0 = int(self.slider1.value()),real = filename)
        if fext in self.env.magick_ext:
            filename = origfname[:]
            imgdb.convert(self.env.curdb.thdir2+".cache.bmp",filename)

        # re-create thumb for this recently changed img
        self.curdb.getThumbDB(self.curfid,force = 1)

        QMessageBox.information( self, "imgSeek",filename+" saved.")

    def onSaveAs(self):
        filename = str(QFileDialog.getSaveFileName("", "*.*", self, "Choose filename for the new image."))
        if not filename: return

        (base,ext) = os.path.splitext(filename)
        fext = ext[1:].lower()

        origfname = filename[:]
        if fext in self.env.magick_ext:
            imgdb.convert(self.curfidname,self.env.curdb.thdir2+".cache.bmp")
            filename = self.env.curdb.thdir2+".cache.bmp"

        self.callback(a0 = int(self.slider1.value()),real = filename)
        if fext in self.env.magick_ext:
            filename = origfname[:]
            imgdb.convert(self.env.curdb.thdir2+".cache.bmp",filename)

        QMessageBox.information( self, "imgSeek",filename+" saved.")

    def ApplyBtn_clicked(self):
        if self.targettab.currentPageIndex() == 0: # image
            self.saveMenu.popup(self.ApplyBtn.mapToGlobal(QPoint(0,0)))
        else:                           # batch
            flist = []                    # list of filenames to change
            bid = self.curdb.batches.keys()[self.batchcombo.currentItem()]
            self.curdb.crawlBatchForFile(bid,flist)
            if not flist:
                QMessageBox.information( self, "imgSeek","This batch has no images in it.")
                return
            res = QMessageBox.information( self, "imgSeek","You are about to apply this Transform to %d image(s), are you sure ?"%len(flist),   QString("A&pply"), QString("Cancel"))
            if res: return
            for fil in flist:
                try:
                    self.curfidname = fil
                    self.callback(a0 = int(self.slider1.value()),real = fil)
		    # re-create thumb for fil
	            self.curdb.getThumb(fil,force = 1)

                except:
                    traceback.print_exc()
                    QMessageBox.information( self, "imgSeek","Error applying transform to batch.")
            QMessageBox.information( self, "imgSeek","Transform applied to batch.")

    def onPreviewFull(self):
        fname = self.parent().dbdir+".cacheprev.bmp"
        #TODO7: should I delete this cacheprev.bmp after usage ?
        self.callback(real = fname)
        from SlideShowDialog import SlideShowDialog
        ds = SlideShowDialog(self,self.env)
        ds.showImg(fname)

    def targettab_selected(self,a0):
        pass

    def targettab_currentChanged(self,a0):
        if self.targettab.currentPageIndex() == 0: # image
            self.thumbLabel.show()
            self.showFile(self.curfid)
        else:                           # batch
            self.thumbLabel.hide()

    def showbatcheditor_clicked(self):
        wnd = self.parent()
        wnd.editcategaction_activated()

    def batchcombo_activated(self,a0):
        pass

    def refreshbtn_clicked(self):
        res = QMessageBox.information( self, "imgSeek","Are you sure you want to revert to saved image ?",   QString("&Revert to what is saved"), QString("Cancel"))
        if res: return
        self.showFile(self.curfid)

    def hideEvent(self,e):
        return

    def slider1_valueChanged(self,a0):
        self.value1Edit.setText(str(a0))
        self.callback(0,a0)

    def slider2_valueChanged(self,a0):
        self.value2Edit.setText(str(a0))
        self.callback(1,a0)

    def slider3_valueChanged(self,a0):
        self.value3Edit.setText(str(a0))
        self.callback(2,a0)

    def value2Edit_textChanged(self,a0):
        try:
            self.slider2.setValue(int(str(a0)))
        except:
            pass


    def value1Edit_textChanged(self,a0):
        try:
            self.slider1.setValue(int(str(a0)))
        except:
            pass


    def value3Edit_textChanged(self,a0):
        try:
            self.slider3.setValue(int(str(a0)))
        except:
            pass

    def transfCombo_activated(self,a0):
        self.setupTransform(a0)
