# -*- coding: iso-8859-1 -*-
###############################################################################
# begin                : Sat Dec 14 2002
# copyright            : (C) 2003 by Ricardo Niederberger Cabral
# email                : nieder at mail dot ru
###############################################################################
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
###############################################################################

"""imgSeek application module

    Main app module. Responsible for startup, shutdown, gui callbacks, dialog creation, interaction with main db
"""

app_title = "imgSeek"
print "Starting imgSeek, please wait ..."

############## Core Modules
try:
    from string import *                # eek :(
    import sys,os.path,traceback,time
    from imgSeekLib import Error, ImgDB, dbCallbacks, customWidgets
    from imgSeekLib import __version__ as imgSeekLib__version__
    from imgSeekLib.Settings import Env, LoadConfig, WriteConfig, ConfigDefault
    from imgSeekLib.MainForm import MainForm
    print "Version ",imgSeekLib__version__
except:
    traceback.print_exc()
    print "imgSeek: Unable to find one of the modules required. Make sure imgSeek was installed properly. "
    sys.exit()
try:
    from qt import *
except:
    Error.qtImportError()

############## Main Window
class DlgMain (MainForm):
    """main dialog. napp parameter is a QApplication object holding current global qapp """

    def __init__(self, napp,parent = None,name = None,modal = 0,fl = 0):
        MainForm.__init__(self, parent, name, fl)
        self.env = Env(self)
        ### Resize some widgets
        try:
            self.BrowseDirListView.setColumnWidthMode(1,QListView.Manual)
            self.BrowseDirListView.setColumnWidth(1,50)
            self.BrowseDirListView.setTreeStepSize(10)
            self.showTheseListView.startDragDistance = napp.startDragDistance()
            self.showTheseListView.env = self.env
            self.dontShowTheseListView.startDragDistance = napp.startDragDistance()
            self.dontShowTheseListView.env = self.env
            self.AvailableGroupsListView.startDragDistance = napp.startDragDistance()
            self.AvailableGroupsListView.env = self.env
            self.BrowseCategListView.startDragDistance = napp.startDragDistance()
            self.BrowseCategListView.env = self.env
        except:
            Error.PrintTB("Setting listview properties")
        ## make sure ~/.imgseek exists
        self.dbdir = os.path.expanduser(os.path.join("~",".imgseek",""))
        if not os.path.exists(self.dbdir): # make sure "~/.imgseek" exists
            try:
                os.mkdir(self.dbdir)
            except:
                Error.PrintTB("Error creating ~/.imgseek for storing config and database. imgSeek will use ~/ instead")
                self.dbdir = os.path.expanduser(os.path.join("~",""))
        try:
            self.loadPixmaps()
        except:
            Error.PrintTB("Loading GUI pixmaps")

        self.BrowseSysDirListView.wnd = self
        self.BrowseSysDirListView.env = self.env
        self.BrowseSysDirListView.createMenus()
        customWidgets.env = self.env
        self.lastSearch = []              # holds [source,results] of last search: source is id or fname and results is list of ids
        self.hiddenIcons = []
        ########## Forms pointers used later
        self.MetaForm = None
        self.AlbumForm = None
        self.BatchMgrFrm = None
        self.DuplicateForm = None
        self.RenameForm = None
        self.ExportForm = None
        self.ImportForm = None
        self.TransformForm = None
        ########## Tab Icons, only available on QT 3
        try:
            self.MainTabWidget.setTabIconSet ( self.MainTabWidget.page(0), self.bookaction.iconSet() )
            self.MainTabWidget.setTabIconSet ( self.MainTabWidget.page(1), self.fileNewAction.iconSet() )
            self.MainTabWidget.setTabIconSet ( self.MainTabWidget.page(2), self.findduplicatemenu.iconSet() )
            self.MainTabWidget.setTabIconSet ( self.MainTabWidget.page(3), self.rescanim.iconSet() )
        except:
            Error.PrintTB("PYQT 3.4 error, please install PyQT 3.5. Some icons will be missing.")
        ########## Load DB
        self.curdb = ImgDB.ImgDB(self.env)
        ########## populate callback lists
        self.curdb.app = napp
        self.curdb.wnd = self
        self.curdb.sysdirbmCb.append(self.onsysBookmarkChanged)
        self.addImageEdit.cb = self.addImageBtn_clicked # set what should be called when user press Enter on this combo box
        dbCallbacks.wnd = self
        dbCallbacks.curdb = self.curdb
        dbCallbacks.env = self.env
        self.curdb.cbs["Group"].append(dbCallbacks.cbGroup)
        self.curdb.cbs["Dir"].append(dbCallbacks.cbDir)
        self.curdb.cbs["SimGroup"].append(dbCallbacks.cbSimGroup)
        self.curdb.cbs["Volume"].append(dbCallbacks.cbVolume)
        self.curdb.cbs["Meta"].append(dbCallbacks.cbMeta)
        self.curdb.cbs["Img"].append(dbCallbacks.cbImg)
        self.curdb.cbs["Batch"].append(dbCallbacks.cbBatch)
        self.curdb.cbs["Database"].append(dbCallbacks.cbDatabase)
        # Misc callbacks
        self.lastIconDisplayAction = None # this should be [updateFunction, parm_to_apply]
        ######## Win32 adjusts
        if sys.platform.find('win') != -1:  # windows platform
            self.seeAsGqviewCollection.setVisible(0)
            self.gohomebtn.hide() #TODO3: implement this on win32 one day
        ######## Statusbar
        sbar = self.statusBar()
        self.dbsizeLabel = QLabel(sbar)
        sbar.addWidget(self.dbsizeLabel)
        self.setCaption(app_title)
        self.queryfname = ""              # filename of the currently selected query result
        self.tempQueryImage = None        # QImage with image to be queried. Should be passed to QueryEngine
        self.selectedResult = None        # QIconViewItem currently selected
        self.displayedFiles = []          # list of filenames currently displayed on an iconview. Useful for slideshowing the curr dir
        self.app = napp                   # global QApplication obj
        self.sketchhistory = []           # list of filenames found on ~/.imgseek/sketch/foobar.png
        self.metalist = []                # meta tags used so far
        self.querycombos = []             # holds all comboboxes on the keyword query tab
        self.historytextcombos = [self.SearchImportcombo,self.addImageEdit] # text combos I want to have their history tracked
        self.selectedIDs = []             # list of selected ids on a iconview or listview. List of dictionaries:
        # "id":db id,
        # "item":listview item
        # "type":File, Dir,SysDir,Group, etc
        ### Draw query widgets

        self.dontshowtheselist = []     # list of group id's
        self.showtheselist = []         # list of group id's

        #self.images_updated = 0
        self.lastMoreThumbTime = 0      # last time() more thumbnails were added, in order to avoid multiple subsequent additions, freezing everything

        self.DrawQueryColorPixmap.callBack = self.onDrawColorChange
        self.DrawQueryPixmap.dlg = self
        self.FullView.infolabel = self.fullviewLabel
        self.FullView.env = self.env
        self.FullView.pixlabel.env = self.env
        self.FullView.pixlabel.createMenus()
        self.FullView.MainTabWidget = self.MainTabWidget

        self.FullView2.infolabel = self.fullviewLabel2
        self.FullView2.env = self.env
        self.FullView2.pixlabel.env = self.env
        self.FullView2.pixlabel.createMenus()
        self.FullView2.pixlabel.querycb = self.queryImgByFilename
        self.FullView2.MainTabWidget = self.MainTabWidget

        self.updateQueryCombos()
        self.querytable.setColumnStretchable(1,1)
        ########## Menus and popups
        #self.scrollTTip = QToolTip(self.BrowseIconView)
        ## Hide/show menu options
        # setVisible isn't supported by PyQt ????
        self.ignoredoccheck.setEnabled(self.env.hasImMagick)
        self.transformimage.setEnabled(self.env.hasPIL)
        self.ExportAction.setEnabled(self.env.hasExport)
        self.ImportAction.setEnabled(self.env.hasExport)
        self.extractiptccheck.setEnabled(self.env.hasIPTC)
        ## Create popups
        try:
            self.createPopups()
        except:
            traceback.print_exc()
            self.info("Error creating popup menus.")
        ### Populate other stuff
        # combo listing available clustering criteria
        # ** NOTE ** If you change this strings, also change ImgDB.py:updateGroups
        self.groupByCombo.insertItem("Color (Fast)")
        self.groupByCombo.insertItem("Content (Slow/Accurate)")
        self.groupByCombo.insertItem("Date")
        self.groupByCombo.insertItem("Filename")
        ########## default configs
        print "Loading preferences..."
        self.configFile = self.dbdir+"imgSeek.ini"
        self.env.options = LoadConfig(self.configFile,ConfigDefault)
        try: # i really don't know why, but this setCurrentPage didnt' work on syncConfigtoUI, and the splitters either
            self.browsevsplit.setSizes([int(self.env.options["view.vsplit1"]),int(self.env.options["view.vsplit2"])])
            self.browsehsplit.setSizes([int(self.env.options["view.hsplit1"]),int(self.env.options["view.hsplit2"])])
            self.searchsplitter.setSizes([int(self.env.options["view.ssplit1"]),int(self.env.options["view.ssplit2"])])
            self.search2splitter.setSizes([int(self.env.options["view.s2split1"]),int(self.env.options["view.s2split2"])])
            self.MainTabWidget.setCurrentPage(int(self.env.options["view.maintab"]))
            self.browsetab.setCurrentPage(int(self.env.options["view.browsetab"]))
            self.resize(int(self.env.options["view.mainwidth"]),int(self.env.options["view.mainheight"]))
        except:
            Error.PrintTB( "Error setting preferences.")
        #open default db
        print "Done."
        try:
            self.env.options["database.autoopen"] = os.path.expanduser(self.env.options["database.autoopen"])
            self.curdb.opendb(self.env.options["database.autoopen"])
        except:
            try:
                self.curdb.opendb(self.dbdir+"img-db.iqd")
            except:
                print "Error opening default database"
        self.env.wnd = self
        self.env.curdb = self.curdb
        self.env.app = self.app
        self.updateStatusInfo()
        self.updateCategoryView()
        if int(self.env.options["database.agressive"]):
            self.curdb.agressive = 1
        else:
            self.curdb.agressive = 0
        #########
        self.recentMenu = None            # loadRecentDatabase() will try to delete it if it's non-null
        customWidgets.options = self.env.options
        try:
            self.syncConfigToUI()
        except:
            Error.PrintTB( "Error setting preferences.")
        print "Loading history..."
        try:
            self.loadHistory()
        except:
            Error.PrintTB( "Error setting preferences.")
        self.loadRecentDatabases()
        ########### SysDirTree init
        self.sysDirTreeInit()
        ######## Misc stuff
        self.doingAdd = 0                 # flag to refuse requests to add files when it's already adding files
        self.abortedAdd = 0               # set to 1 so AddDir stops adding files
        self.progressGroup.hide()
        self.BrowseDirListView.setSorting(999,0) # to disable automatic sorting. The user has to click on the header column to sort. This way I can place dirs first.
        self.brushsizeslider_valueChanged(self.brushsizeslider.value())
        self.BrowseIconView.shownID = -1 # dir/group being currently displayed / id of the group currently displayed on thumbnail icon view (for drag&drop move action)
        self.BrowseIconView.shownIDName = "" #
        # first letter of the group currently shown. This is to make sure that the id on shownGroup is the same as of the
        # group name on the thumbnail view info label text
        ######## Conditional actions for startup
        if int(self.env.options["database.autoscannew"]):
            self.refreshdbase_activated()
        print "Done."

    def sysDirTreeInit(self):
        customWidgets.folderLocked = QPixmap( customWidgets.folder_locked )
        customWidgets.folderClosed = QPixmap( customWidgets.folder_closed_xpm )
        customWidgets.folderOpen = QPixmap( customWidgets.folder_open_xpm ) # TODO2: this pixmap is b0rked, fix it
        customWidgets.fileNormal = QPixmap( customWidgets.pix_file )
        self.BrowseSysDirListView.setTreeStepSize( 20 )
        self.BrowseSysDirListView.cb = self.sysDirCallback
        self.BrowseSysDirListView.curdb = self.curdb
        self.BrowseSysDirListView.addDircb = self.sysDirAddCallback

        def dirPopulate(root_drive = os.sep): # on *NIX, the default of '/' is used and the one and only drive
            cur_drive = None
            try:
                cur_drive = customWidgets.Directory(self.BrowseSysDirListView,root_drive,root_drive)
                for file in os.listdir(root_drive):
                    if os.path.isdir(file):
                        dummy = customWidgets.Directory(cur_drive,file,file)
            except WindowsError:
                print 'Error listing "%s", ignore it if this drive is not mounted.' % root_drive
                return
            except:
                traceback.print_exc()
                self.info("Error populating system directory tree widget.")
            return cur_drive

        if sys.platform.find('win') != -1:  #windows platform
            try:
                import win32api, win32file
            except:
                print "Unable to import necessary windows modules for python. Make sure you have Python Windows Extensions installed."
            else:
                try:
                    drives = [drive for drive in win32api.GetLogicalDriveStrings().split('\x00')[:-1] if win32file.GetDriveType(drive) in [win32file.DRIVE_FIXED,win32file.DRIVE_CDROM, win32file.DRIVE_REMOVABLE]]
                    for drive in drives:
                        dirPopulate(drive)
                except:
                    Error.PrintTB( "win32file error")
                    nixPopulate()       # populate only with drive C
        else: # *nix
            try:
                for file in os.listdir(os.sep):
                    file = os.sep+file
                    if os.path.isdir(file):
                        dummy = customWidgets.Directory(self.BrowseSysDirListView,file,file)
            except:
                traceback.print_exc()
                self.info("Error populating system directory tree widget.")

            #rootIcon.setOpen(1)
            # expand root dir
            #self.BrowseSysDirListView.showPath(os.sep)

    def loadPixmaps(self):
        ########## Icons
        # color.png is loaded separately by QT here because opening this colorful bitmap from the XPM at MainForm.py slows down app startup
        self.imglibdir = self.env.imgseekdatadir
        imglibdir = self.imglibdir
        try:
            if os.path.exists(imglibdir+"color.png"):
                pixm = QPixmap(imglibdir+"color.png")
                self.DrawQueryColorPixmap.setPixmap(pixm)
            else:
                imglibdir = os.path.split(sys.argv[0])[0]+"/imgSeekLib/"
                if os.path.exists(imglibdir+"color.png"):
                    pixm = QPixmap(imglibdir+"color.png")
                    self.DrawQueryColorPixmap.setPixmap(pixm)
        except:
            traceback.print_exc()
            print "Error loading colors pixmap for the drawing widget. Please report the above error to nieder@mail.ru."
        self.bookicon = self.bookaction.iconSet().pixmap()
        self.foldericonset = self.folderaction.iconSet()
        self.foldericon = self.foldericonset.pixmap()
        customWidgets.imageicon = self.imageaction.iconSet().pixmap()

    def createPopups(self):
        # for browse by system thumbs
        self.browseDirMenuSys = QPopupMenu(self)
        self.browseDirMenuSys.insertItem ( self.globalslide.iconSet(),self.tr("&Show fullscreen"), self.onResultsMenuShow)
        self.browseDirMenuSys.insertItem ( self.findduplicatemenu.iconSet(), self.tr("&Query for similar images"), self.onResultsMenuQuery)
        self.browseDirMenuSys.insertSeparator()
        if self.env.hasPIL:
            self.browseDirMenuSys.insertItem ( self.transformimage.iconSet(),self.tr("&Transform image"), self.onTransformImagesMenu)
            self.browseDirMenuSys.insertSeparator()
        self.browseDirMenuSys.insertItem ( self.removedead.iconSet(),self.tr("&Physically delete this image from disk"), self.onPhysDel)
        #the popup for images query results, and thumbnail iconviews, aka images in database
        self.browseDirMenu = QPopupMenu(self)
        self.browseDirMenu.insertItem ( self.globalslide.iconSet(),self.tr("&Show fullscreen"), self.onResultsMenuShow)
        self.browseDirMenu.insertItem ( self.findduplicatemenu.iconSet(),self.tr("&Query for similar images"), self.onResultsMenuQuery)
        self.browseDirMenu.insertItem ( self.findduplicatemenu.iconSet(),self.tr("&Search for similar filenames"), self.onResultsMenuFnameQuery)
        self.browseDirMenu.insertItem ( self.findduplicatemenu.iconSet(),self.tr("Query &random images"), self.onResultsMenuRandomQuery)
        self.browseDirMenu.insertItem ( self.editmeta.iconSet(),self.tr("&Edit metadata"), self.onEditMetaImageMenu)
        self.browseDirMenu.insertItem ( self.tr("Show &groups"), self.onShowGroupsMenu)
        self.browseDirMenu.insertItem ( self.editbatch.iconSet(),self.tr("Add to &batch"), self.onResultsIncludeAlbum)
        self.browseDirMenu.insertSeparator()
        if self.env.hasPIL:
            self.browseDirMenu.insertItem ( self.transformimage.iconSet(),self.tr("&Transform image"), self.onTransformImagesMenu)
            self.browseDirMenu.insertSeparator()
        self.browseDirMenu.insertItem ( self.tr("&Move to group"), self.onMoveGroupImageMenu)
        self.browseDirMenu.insertItem ( self.tr("&Move to another directory"), self.onMoveImageMenu)
        self.browseDirMenu.insertItem ( self.fileSaveAsAction.iconSet(),self.tr("&Copy to another directory"), self.onCopyImageMenu)
        self.browseDirMenu.insertItem ( self.removedead.iconSet(),self.tr("&Remove from database"), self.onRemoveImageDB)
        self.browseDirMenu.insertItem ( self.removedead.iconSet(),self.tr("&Physically delete this image from disk"), self.onPhysDel)
        self.browseDirMenu.insertItem ( "Set as desktop bac&kground", self.onSetBg)
        # for groups of images on db
        self.browseGroupMSelMenu = QPopupMenu(self)
        self.browseGroupMSelMenu.insertItem ( self.tr("&Move/copy to group"), self.onMoveGroupImageMenu)
        self.browseGroupMSelMenu.insertItem ( self.tr("&Move to another directory"), self.onMoveImageMenu)
        self.browseGroupMSelMenu.insertItem ( self.editbatch.iconSet(),self.tr("Add to &batch"), self.onResultsIncludeAlbum)
        self.browseGroupMSelMenu.insertItem ( self.removedead.iconSet(),self.tr("&Remove from database"), self.onRemoveImageDB)
        self.browseGroupMSelMenu.insertItem ( self.removedead.iconSet(),self.tr("&Physically delete from disk"), self.onPhysDel)
        # for groups of dirs and  on db
        self.browseDirMSelMenu = QPopupMenu(self)
        self.browseDirMSelMenu.insertItem ( self.removedead.iconSet(),self.tr("&Remove from database"), self.onRemoveImageDB)
        self.browseDirMSelMenu.insertItem ( self.removedead.iconSet(),self.tr("&Physically delete from disk"), self.onPhysDel)
        #the popup for directories
        self.browseDirMenu2 = QPopupMenu(self)
        self.browseDirMenu2.insertItem ( self.globalslide.iconSet(),self.tr("&Slideshow"), self.onResultsMenuSlideshow)
        self.browseDirMenu2.insertItem ( self.editbatch.iconSet(),self.tr("Add to &batch"), self.onResultsIncludeAlbum)
        self.browseDirMenu2.insertSeparator()
        self.browseDirMenu2.insertItem ( self.removedead.iconSet(),self.tr("&Remove from database"), self.onRemoveImageDB)
        #the popup for groups when not clicked on a group (aka viewlist empty)
        self.groupMenu2 = QPopupMenu(self)
        self.groupMenu2.insertItem ( self.fileNewAction.iconSet(),self.tr("&New group"), self.onNewGroup)
        self.groupMenu2.insertItem ( self.editbatch.iconSet(),self.tr("Add all to &batch"), self.onHTMLIncludeAllGroups)
        #when user clicks on an empty area of the BrowseIconView
        self.emptyIconViewMenu = QPopupMenu(self)
        self.emptyIconViewMenu.insertItem ( self.tr("&Refresh"), self.onIconViewRefreshRequest)
        #when user clicks on an empty area of the search result thumbnail view, or the search result tab options btn
        self.resultsViewMenu = QPopupMenu(self)
        self.resultsViewMenu.insertItem ( self.bookaction.iconSet(),self.tr("&Copy all results to a group..."), self.onResultsMoveGroup)
        self.resultsViewMenu.insertItem ( self.editbatch.iconSet(),self.tr("&Add results to a batch"), self.onResultsCreateBatch)
        self.resultsViewMenu.insertItem ( self.findduplicatemenu.iconSet(),self.tr("Query &random images"), self.onResultsMenuRandomQuery)
        self.resultsViewMenu.insertItem ( self.globalslide.iconSet(),self.tr("&Slideshow results"), self.onQueryResultsSlideshow)
        #similarity browse options
        self.SymBrowseMenu = QPopupMenu(self)
        self.SymBrowseMenu.insertItem ( self.bookaction.iconSet(),self.tr("&Export these similarity groups as \"Logical groups\""), self.onSymBrowseCreateGroups)
        #the popup for groups
        self.groupMenu = QPopupMenu(self)
        self.groupMenu.insertItem ( self.globalslide.iconSet(),self.tr("&Slideshow"), self.onGroupSlideshow)
        self.groupMenu.insertItem ( self.editbatch.iconSet(),self.tr("Add to &batch"), self.onGroupIncludeAlbum)
        self.groupMenu.insertSeparator()
        self.groupMenu.insertItem ( self.fileNewAction.iconSet(),self.tr("&New group"), self.onNewGroup)
        self.groupMenu.insertItem ( self.removedead.iconSet(), self.tr("&Remove group"), self.onRemoveGroup)
        self.groupMenu.insertItem (self.editmeta.iconSet(), self.tr("&Rename group"), self.onRenameGroup)
        self.groupMenu.insertItem (self.editmeta.iconSet(), self.tr("&Describe group"), self.onDescribeGroup)
        #popup for volumes
        self.browseDirMenu3 = QPopupMenu(self)
        self.browseDirMenu3.insertItem ( self.fileNewAction.iconSet(),self.tr("&New volume"), self.onNewVol)
        self.browseDirMenu3.insertItem ( self.removedead.iconSet(), self.tr("&Remove volume"), self.onDelVol)
        self.browseDirMenu3.insertItem (self.editmeta.iconSet(), self.tr("&Rename volume"), self.onRenameVol)
        self.browseDirMenu3.insertItem (self.editmeta.iconSet(), self.tr("&Describe volume"), self.onDescribeVol)
        self.browseDirMenu3.insertSeparator()
        self.browseDirMenu3.insertItem ( self.globalslide.iconSet(),self.tr("&Slideshow"), self.onResultsMenuSlideshow)
        self.browseDirMenu3.insertItem ( self.editbatch.iconSet(),self.tr("Add to &batch"), self.onVolumeIncludeAlbum)
        #popup for volumes2 - when clicked over no icon
        self.browseDirMenu4 = QPopupMenu(self)
        self.browseDirMenu4.insertItem ( self.fileNewAction.iconSet(),self.tr("&New volume"), self.onNewVol)
        self.browseDirMenu4.insertItem ( self.editbatch.iconSet(),self.tr("Add all volumes to &batch"), self.onHTMLIncludeAllVols)
        #popup for drag
        self.dragMenu = QPopupMenu(self)
        self.dragMenu.insertItem ( self.fileSaveAction.iconSet(),self.tr("&Copy"), self.onDragCopy)
        self.dragMenu.insertItem ( self.ExportAction.iconSet(),self.tr("&Move"), self.onDragMove)
        #query table menu
        self.fieldMenu = QPopupMenu(self)
        self.fieldMenu.insertItem ( self.fileNewAction.iconSet(),self.tr("&New parameter"), self.onNewQueryField)
        self.fieldMenu.insertItem ( self.removedead.iconSet(), self.tr("&Remove parameter"), self.onDelQueryField)
        #simgroup main img menu
        self.simBrowseMenu = QPopupMenu(self)
        self.simBrowseMenu.insertItem ( self.globalslide.iconSet(),self.tr("&Slideshow"), self.onResultsMenuSlideshow)
        self.simBrowseMenu.insertItem ( self.editbatch.iconSet(),self.tr("Add to &batch"), self.onResultsIncludeAlbum)
        #browse by sys dir options popup
        self.sysdiroptMenu = QPopupMenu(self)
        self.sysdiroptMenu.insertItem ( "Show &dot files", self.showdotcheck_toggled,0,5)
        self.sysdiroptMenu.insertItem ( "Show &non-image files", self.shownormalcheck_toggled, 0,6)

    def saveHistory(self):
        """ save history for all comboboxes"""
        import marshal
        try:
            # Text combos
            f = open(self.dbdir+"history","wb")
            for cmb in self.historytextcombos:
                vals = []
                for idx in range(cmb.count()):
                    vals.append(str(cmb.text(idx)))
                if len(vals) > 10: del vals[9]
                marshal.dump(vals,f)
            # sketch history
            marshal.dump(self.sketchhistory,f)
            f.close()
        except:
            Error.PrintTB( "Error saving preferences.")
            return 0

    def loadHistory(self):
        """ load history for all comboboxes"""
        import marshal
        try:
            # Text combos
            f = open(self.dbdir+"history","rb")
            for cmb in self.historytextcombos:
                vals = marshal.load(f)
                for str in vals:
                    cmb.insertItem(str)
            # sketch history
            self.sketchhistory = marshal.load(f)
            for fname in self.sketchhistory:
                aImage = QImage()
                if not aImage.load(fname):
                    print "Error loading sketch:"
                    print fname
                    self.msgerror("Error loading selected sketch.")
                    continue
                a = QPixmap()
                a.convertFromImage(aImage)
                self.sketchescomboBox.insertItem(a)
            f.close()
        except:
            pass

    def syncConfigToUI(self):
        """make GUI (checkboxes, etc) reflect those options from self.env.options """
        print "Applying preferences..."
        self.sysdiroptMenu.setItemChecked(5,int(self.env.options["browse.showdotfiles"]))
        self.sysdiroptMenu.setItemChecked(6,int(self.env.options["browse.shownormalfiles"]))
        self.clickactioncombo.setCurrentItem(int(self.env.options["browse.thumbsingleclick"]))
        self.thresEdit.setText(self.env.options["browse.groupthreshold"])
        self.startDBEdit.setText(os.path.expanduser(self.env.options["database.autoopen"]))
        self.adddirrecursivecheckBox.setChecked(int(self.env.options["database.recursiveadd"]))
        self.slidedelayspin.setValue(int(self.env.options["view.slidedelay"]))
        self.fitimagecheck.setChecked(int(self.env.options["view.autofit"]))
        self.beepcheck.setChecked(int(self.env.options["database.beep"]))
        self.extractexifcheck.setChecked(int(self.env.options["database.extractexif"]))
        self.extractiptccheck.setChecked(int(self.env.options["database.extractiptc"]))
        self.hideprogresscheck.setChecked(int(self.env.options["database.hideprogress"]))
        self.showgrouprecursivecheck.setChecked(int(self.env.options["browse.showgrouprecursive"]))
        self.smoothcheck.setChecked(int(self.env.options["view.smoothscale"]))
        self.recurseslidecheck.setChecked(int(self.env.options["view.recurseslide"]))
        self.agressivecheck.setChecked(int(self.env.options["database.agressive"]))
        self.realtimecheck.setChecked(int(self.env.options["query.realtimesketch"]))
        self.savealwayscheck.setChecked(int(self.env.options["database.alwayssave"]))
        self.dropaskcheck.setChecked(int(self.env.options["browse.dragpopup"]))
        self.rescanonstartupcheck.setChecked(int(self.env.options["database.autoscannew"]))
        # resize stuff
        self.resize(int(self.env.options["view.mainwidth"]),int(self.env.options["view.mainheight"]))
        self.syncMetaQueryHistory()

    def syncMetaQueryHistory(self):
        ## metaquery history:
        self.queryhistorycombo.clear()
        for key in self.curdb.textqueryhistory:
            self.queryhistorycombo.insertItem(key[0])

    def onConfigChange(self):
        """right now it will simply write all config """
        # save split sizes. I'm saving them here because I didnt find the right way to intercept resize events for splitters
        self.env.options["view.vsplit1"] = str(self.browsevsplit.sizes()[0])
        self.env.options["view.vsplit2"] = str(self.browsevsplit.sizes()[1])
        self.env.options["view.hsplit1"] = str(self.browsehsplit.sizes()[0])
        self.env.options["view.hsplit2"] = str(self.browsehsplit.sizes()[1])

        self.env.options["view.ssplit1"] = str(self.searchsplitter.sizes()[0])
        self.env.options["view.ssplit2"] = str(self.searchsplitter.sizes()[1])

        self.env.options["view.s2split1"] = str(self.search2splitter.sizes()[0])
        self.env.options["view.s2split2"] = str(self.search2splitter.sizes()[1])

        self.env.options["view.maintab"] = str(self.MainTabWidget.currentPageIndex())
        self.env.options["view.browsetab"] = str(self.browsetab.currentPageIndex())

        self.env.options["view.mainwidth"] = str(self.width())
        self.env.options["view.mainheight"] = str(self.height())

        self.env.options["database.extractexif"] = str(self.extractexifcheck.isChecked())
        self.env.options["database.extractiptc"] = str(self.extractiptccheck.isChecked())

        self.env.options["database.autoopen"] = os.path.expanduser(str(self.startDBEdit.text()))

        WriteConfig(self.configFile,self.env.options)

    def onQueryResultsSlideshow(self):
        flist = []
        it = self.SearchImageIconView.firstItem()
        if not it:return
        while it:
            try:
                flist.append(self.curdb.img[it.id][0])
                it = it.nextItem()
            except:
                Error.PrintTB("Populating list of file before starting slideshow")
        self.doSlideShow(flist)

    def onResultsCreateBatch(self):
        """ move all current query results to a group"""
        if not self.SearchImageIconView.count():return
        text = str(QInputDialog.getText("imgSeek","New batch name:" ,QLineEdit.Normal, time.asctime(time.localtime()))[0])
        if text:
            bid = self.curdb.addBatch(text)
            if not bid:
                QMessageBox.information( self, "imgSeek","Error adding batch.")
                return
        it = self.SearchImageIconView.firstItem()
        if not it:return
        while it:
            self.curdb.addItemBatch({"type":"Img","id":it.id},bid)
            it = it.nextItem()

    def onResultsMoveGroup(self):
        """ move all current query results to a group"""
        self.selectedGroups = []
        it = self.SearchImageIconView.firstItem()
        if not it:return
        while it:
            self.selectedGroups.append({"type":"Img","id":it.id})
            it = it.nextItem()

        from imgSeekLib.GroupPickerWnd import GroupPickerWnd
        md = GroupPickerWnd(self,self.onResultsMoveGroupCB,self.env)

    def onResultsMoveGroupCB(self,gid):
        """ grouppicker will call this fcn when user is done picking a group to move files to"""
        if gid==-1:return
        if not self.curdb.moveObjectsToGroup(self.selectedGroups,gid):
            self.info("Error moving files.")

    def onSymBrowseCreateGroups(self):
        self.curdb.createGroupsFromSymGroups()

    def onIconViewRefreshRequest(self):
        if self.lastIconDisplayAction:
            try:                        # Python Magic, w000t !!!
                self.BrowseIconView.shownID = -1
                self.lastIconDisplayAction[0](self.lastIconDisplayAction[1]) # call last display function again, with the last parameter
            except:
                Error.PrintTB("Invoking last display action")

    def onResultsIncludeAlbum(self):
        if not self.selectedIDs: return
        for nit in self.selectedIDs:
            try:
                self.curdb.addItemBatch(nit)
            except:
                Error.PrintTB("while added search results to batch")

    def sysDirAddCallback(self,restr):
        """called when user asks fname to be added to database
        """
        if self.doingAdd: return
        self.updateStatusBar(self.tr("Adding image(s)..."))
        self.app.processEvents()
        if not os.path.exists(restr.addfname):
            self.msgerror(self.tr("File/dir not found."))
            self.updateStatusBar(self.tr(self.str("Ready.")))
            return
        self.addImageBtn.setEnabled(0)
        self.doingAdd = 1
        self.progressGroup.show()
        #add dir
        if os.path.isdir(restr.addfname):
            if restr.addfname[-1] != os.sep: restr.addfname = restr.addfname+os.sep
            self.curdb.addDir(restr.volid,restr.addfname,restr.groupid,[],self.adddirrecursivecheckBox.isChecked(),-1,restr = restr)
            self.updateStatusBar(self.tr("Directory added successfully"))
        else:
            #TODO2: allow people to add only 1 image. Also investigate the feasibility of adding images automatically to db when they are displayed on the system thumbnail lister.
            self.progressGroup.hide()
            self.addImageBtn.setEnabled(1)
            self.doingAdd = 0
            return
        self.curdb.changedDB({"scope":"Group","reason":"addedimage","save":0})
        self.curdb.changedDB({"scope":"Dir","reason":"added"})
        if int(self.env.options["database.beep"]):
            self.app.beep()
        self.unsetCursor()
        self.setCursor(QCursor(Qt.ArrowCursor))
        self.addImageBtn.setEnabled(1)
        self.doingAdd = 0
        if int(self.env.options["database.hideprogress"]):
            self.progressGroup.hide()
        print self.tr("Finished adding directories.")

    def str(self,st):
        return str(self.tr(st))

    def sysDirCallback(self,fname):
        """ called by Directory widget on customWidgets.py """
        self.lastIconDisplayAction = [self.sysDirCallback,fname]
        if os.path.isdir(fname):
            fname = fname+os.sep
            if self.BrowseIconView.shownID == fname: # already displayed
                return
            self.BrowseIconView.shownID = fname
            flist = []                  # will hold list of all filenames to display
            try:
                for file in os.listdir(fname):
                    file = fname+file
                    if self.curdb.extIsImg(file):
                        flist.append(file)
            except:
                self.info(fname+self.str(": Error opening directory."))
                return
            self.thumbLabel.setText(self.str("%s - %d image(s)")%(fname,len(flist)))
            self.thumbLabel.orig = "%s - %d image(s)"%(fname,len(flist))
            self.BrowseIconView.clear()
            if len(flist): #dir has files to show
                self.displayedFiles = flist
                self.hiddenIcons = []
                showDots = int(self.env.options["browse.showdotfiles"])
                for file in flist:
                    fsname = rfind(file,os.sep)
                    if fsname==-1:
                        fsname = file
                    else:
                        fsname = file[fsname+1:]
                    if fsname[0]=="." and not showDots: continue
                    self.hiddenIcons.append([fsname,file,["filename",file]])
                self.sortHiddenIcons()
                self.populateMoreIcons(50)
        else: #is a file
            if self.curdb.extIsImg(fname):
                # on visit callback, for agressive mode
                self.curdb.visited(fname)
                self.FullView.showImg(fname)

        self.updateStatusBar(self.str("Ready."))

    def onEditMetaImageMenu(self):
        self.showMetaDlg()

    def onShowGroupsMenu(self):
        if not self.selectedResult: return
        gs = []
        for gid in self.curdb.groups.keys():
            if self.selectedResult.id in self.curdb.groups[gid][3]:
                gs.append(gid)
        txt = "Groups this image belongs to:\n\n"
        for g in gs:
            txt += "%s\n" % self.curdb.groups[g][0]
        QMessageBox.information( self, app_title,txt)

    def onDescribeGroup(self):
        if self.selectedResult and self.selectedResult.isGroup:
            try:
                text = str(QInputDialog.getText("imgSeek","Group description:" ,QLineEdit.Normal, self.curdb.groups[self.selectedResult.groupid][1])[0])
                if text:
                    self.curdb.describeGroup(self.selectedResult.groupid,text)
            except:
                traceback.print_exc()
                self.info(self.str("Error changing text attribute"))

    def onRenameGroup(self):
        if self.selectedResult and self.selectedResult.isGroup:
            try:
                text = str(QInputDialog.getText("imgSeek","Group name:" ,QLineEdit.Normal, self.curdb.groups[self.selectedResult.groupid][0])[0])
                if text:
                    self.curdb.renameGroup(self.selectedResult.groupid,text)
                    #self.selectedResult.setText(0,text)
            except:
                traceback.print_exc()
                self.info("Error changing text attribute")

    def onRenameVol(self):
        if self.selectedResult and not self.selectedResult.isDir:
            try:
                text = str(QInputDialog.getText("imgSeek","Volume name:" ,QLineEdit.Normal, self.curdb.volumes[self.selectedResult.volid][3])[0])
                if text:
                    self.curdb.renameVolume(self.selectedResult.volid,text)
                    #self.selectedResult.setText(0,text)
            except:
                traceback.print_exc()
                self.info("Error changing text attribute")

    def onDescribeVol(self):
        if self.selectedResult and not self.selectedResult.isDir:
            try:
                text = str(QInputDialog.getText("imgSeek","Volume description:" ,QLineEdit.Normal, self.curdb.volumes[self.selectedResult.volid][2])[0])
                if text:
                    self.curdb.describeVolume(self.selectedResult.volid,text)
            except:
                traceback.print_exc()
                self.info("Error changing text attribute")

    def onNewVol(self):
        text = str(QInputDialog.getText("imgSeek","New volume name:" ,QLineEdit.Normal, "")[0])
        if text:
            nid = self.curdb.newVolume(text)
            if  nid == -1:
                self.info("Group name already exists. Please try another.")
                return
            self.VolumeCombo.setCurrentText(text)

    def onRemoveImageDB(self):
        ask = 1
        self.curdb.doNotSave = 1
        for it in self.selectedIDs:
            if it["type"]=="Img":
                self.curdb.removeFile(it["id"])
            if it["type"]=="Dir":
                if not self.curdb.dirs.has_key(it["id"]):
                    print "Attempt to remove dir that is not on database..."
                    return
                if ask:
                    res = QMessageBox.information( self, "imgSeek","Are you sure you want to remove from database \""+self.curdb.dirs[it["id"]][0]+ "\" and all images recursively ?",   QString("&Remove"),QString("&Remove without asking anymore"), QString("Cancel"))
                    if res==2: return
                    if res==1: ask = 0
                self.curdb.removeDir(it["id"])
            if it["type"]=="Group":
                if not self.curdb.groups.has_key(it["id"]):
                    print "Attempt to remove group that is not on database..."
                    return
                if ask:
                    res = QMessageBox.information( self, "imgSeek","Are you sure you want to remove from database the group  \""+self.curdb.groups[it["id"]][0]+ "\" and all groups recursively ? (images in this groups and subgroups will go to the \"Orphan\" group)",   QString("&Remove"),QString("&Remove without asking anymore"), QString("Cancel"))
                    if res==2: return
                    if res==1: ask = 0
                self.curdb.removeGroup(it["id"])
        self.curdb.changedDB({"scope":"Img","reason":"removed"})
        self.curdb.doNotSave = 0

    def onGroupIncludeAlbum(self):
        if self.selectedResult.isGroup: # group
            fname = self.selectedResult.groupid
            self.curdb.addItemBatch({"type":"Group","id":fname})

    def onHTMLIncludeAllVols(self):
        for volid in self.curdb.volumes.keys():
            self.curdb.addItemBatch({"type":"Volume","id":volid})

    def onHTMLIncludeAllGroups(self):
        for volid in self.curdb.groups.keys():
            self.curdb.addItemBatch({"type":"Group","id":volid})

    def onVolumeIncludeAlbum(self):
        fname = self.selectedResult.volid
        self.curdb.addItemBatch({"type":"Volume","id":fname})

    def onGroupSlideshow(self):
        flist = []
        if self.selectedResult and self.selectedResult.isGroup:
            if int(self.env.options["view.recurseslide"]):
                self.curdb.crawlGroupForImg(self.selectedResult.groupid,flist)
                fnlist = []
                for fid in flist: fnlist.append(self.curdb.img[fid][0])
                flist = fnlist
            else:
                for fil in self.curdb.groups[self.selectedResult.groupid][3]:
                    flist.append(self.curdb.img[fil][0])
            self.doSlideShow(flist)

    def onNewGroup(self):
        text = str(QInputDialog.getText("imgSeek","New group name:" ,QLineEdit.Normal, time.asctime(time.localtime()))[0])
        if text:
            if self.selectedResult and hasattr(self.selectedResult,"isGroup") and self.selectedResult.isGroup: # hasattr check is needed because selectedResult may have been set from a thumbnail view for example, which doesn't define isGroup
                nid = self.curdb.newGroup(text,self.selectedResult.groupid)
                if  nid == -1:
                    self.info("Group name already exists. Please try another.")
                    return
            else:
                nid = self.curdb.newGroup(text)
                if  nid == -1:
                    self.info("Group name already exists. Please try another.")
                    return

    def onRemoveGroup(self):
        if self.selectedResult and self.selectedResult.isGroup:
            if self.selectedResult.groupid==1:
                self.msgerror("You can't remove the default Orphan group.")
                return
            res = QMessageBox.information( self, "imgSeek","Are you sure you want to remove from database this group and all subgroups recursively ?",   QString("&Remove group"), QString("Cancel"))
            if res: return
            self.curdb.removeGroup(self.selectedResult.groupid)
            self.updateGroupList()

    def onSetBg(self):
        if not self.selectedIDs: return
        it=self.selectedIDs[0]
        fname = None
        #TODO2: port to win32
        if it["type"]=="Img":
            id = it["id"]
            fname = self.curdb.img[id][0]
            from imgSeekLib.Settings import binpathfinder
            prog = binpathfinder("bsetbg")
            if prog:
                os.spawnlp(os.P_NOWAIT, prog,prog,fname)
                return

            prog = binpathfinder("Esetroot")
            if prog:
                os.spawnlp(os.P_NOWAIT, prog,prog,fname)
                return

            prog = binpathfinder("xsetbg")
            if prog:
                os.spawnlp(os.P_NOWAIT, prog,prog,fname)
                return

    def onPhysDel(self):
        ask = 1
        for it in self.selectedIDs:
            fname = None
            if it["type"]=="Img":
                id = it["id"]
                fname = self.curdb.img[id][0]
            if it["type"]=="File":
                fname = it["id"]
            if it["type"]=="Dir":
                fname = self.curdb.dirs[it["id"]][0]
            if not fname: return
            res = 1
            if ask:
                res = QMessageBox.information( self, app_title,"Are you sure you want to PHYSICALLY DELETE \""+fname+ "\" ?",   QString("Delete all without asking anymore"),QString("&Delete"), QString("&Cancel"))
            if res==0:
                ask = 0
                res = 1
            if res !=1: continue
            if res: #delete
                if it["type"]=="File" or it["type"]=="Img":
                    try:
                        os.remove(fname)
                        if it["type"]=="Img":
                            self.curdb.removeFile(id)
                            self.updateGroupList()
                            self.updateDirList()
                        self.refreshIconView()

                    except OSError:
                        self.msgerror("Error deleting file.")
                    except:
                        traceback.print_exc()
                        self.msgerror("Error deleting file.")
                if it["type"]=="Dir":
                    try:
                        os.remove(fname)
                        self.curdb.removeDir(it["id"])
                    except:
                        traceback.print_exc()
                        self.msgerror("Error deleting directory.")

    def onDelVol(self):
        if not self.selectedResult: return
        if not self.selectedResult.isDir==0: return
        if self.selectedResult.volid==1:
            self.msgerror("You can't remove the default volume.")
            return
        res = QMessageBox.information( self, app_title,"Are you sure you want to remove this volume and all images inside it from database ?",   QString("&Remove from database"), QString("Cancel"))
        if not res:
            self.curdb.removeVolume(self.selectedResult.volid)

    def onNewQueryField(self):
        try:
            from qttable import QComboTableItem
        except:
            Error.PrintTB("missing qt feature")
        self.querytable.setNumRows(self.querytable.numRows()+1)
        a = QComboTableItem ( self.querytable, self.metalist, 1 )
        self.querycombos.append(a)
        self.querytable.setItem(self.querytable.numRows()-1,0,a)

    def onDelQueryField(self):
        self.querytable.removeRow(self.selectedRow)

    def onMoveImageMenu(self):
        """invoked when user chooses to move selected files to another dir.
        Will prompt for destination dir. Will also invoke db to make sure db is consistent after files are moved around.
        """
        if not self.selectedIDs: return
        filename = str(QFileDialog.getExistingDirectory())
        if not filename:return
        if filename[-1] != os.sep: filename = filename + os.sep
        renpairs = {}
        for it in self.selectedIDs:
            fname = None
            if it["type"]=="Img":
                id = it["id"]
                fname = self.curdb.img[id][0]
            if it["type"]=="File":
                fname = it["id"]
            if not fname: continue
            try:
                os.rename(fname, filename+os.path.split(fname)[-1])
                renpairs[fname] = [ filename+os.path.split(fname)[-1], it["item"] ]
            except:
                Error.PrintTB("Error moving file.")
                continue
        listItemsToRemove = self.curdb.renameFiles(renpairs)

        #TODO2: This is a hack, i'm too lazy to rewrite everything related to this Rename File -> Remove affected icons mechanism.
        # Make sure i actually use Obj. Oriented Programming properly next time i write something :-/
        for it in listItemsToRemove:
            try:
                self.BrowseIconView.takeItem(it)
            except:
                Error.PrintTB("removing removed/renamed icon")

    def onCopyImageMenu(self):
        import shutil
        smfname = ""
        try:
            smfname = os.path.split(self.curdb.img[self.selectedResult.id][0])[-1]
        except:
            pass
        filename = str(QFileDialog.getSaveFileName(smfname))
        if not filename:return
        try:
            shutil.copyfile(self.curdb.img[self.selectedResult.id][0], filename)
        except:
            traceback.print_exc()
            self.msgerror("Error saving file.")

    def showTrace(self):
        traceback.print_exc()
        self.msgerror("%s\n%s"%(sys.exc_type,sys.exc_value))

    def onMoveGroupImageMenu(self):
        """ move all current query results to a group"""
        self.selectedGroups = self.selectedIDs[:]
        from imgSeekLib.GroupPickerWnd import GroupPickerWnd
        md = GroupPickerWnd(self,self.onResultsMoveGroupCB,self.env)

    def updateQueryCombos(self):
        if not len(self.curdb.metafields): return
        lst = QStringList()
        for mtf in self.curdb.metafields:
            if mtf not in self.curdb.invisiblefields: # hide invisible fields
                lst.append(mtf)
        for cmb in self.querycombos:
            cmb.setStringList(lst)
        self.metalist = lst

    def onResultsMenuShow(self):
        if not self.selectedResult: return
        if hasattr(self.selectedResult,"filename"):
            fname = self.selectedResult.filename
        else:
            fname = self.curdb.img[self.selectedResult.id][0]
        if self.curdb.extIsImg(fname):
            from imgSeekLib.SlideShowDialog import SlideShowDialog
            ds = SlideShowDialog(self,self.env)
            ds.showImg(fname)

    def queryImgByFilename(self,fname):
        self.queryfname = fname
        self.tempQueryImage = self.curdb.getThumb(self.queryfname)
        self.SearchImportcombo.setCurrentText(self.queryfname)
        try:
            self.SearchImagePixmap.setPixmap(self.tempQueryImage)
        except:
            pass
        self.showQueryResults("image",self.startQuery("image",10,nqueryImage = 1))

    def queryImgFilename(self,fname):
        self.SearchImportcombo.setCurrentText(fname)
        self.showQueryResults("text",self.curdb.queryFilename(fname))

    def onResultsMenuFnameQuery(self):
        """called when the user asks to find a file with similar filenames """
        if not self.selectedResult:
            return
        try:
            self.SearchImagePixmap.setPixmap(self.selectedResult.pixmap())
        except:
            try:
                self.SearchImagePixmap.setPixmap(self.curdb.getThumbDB(self.selectedResult.id))
            except:
                pass                    # give up
        a0 = self.selectedResult
        if not hasattr(a0,"filename"):
            self.queryfname = self.curdb.img[a0.id][0]
        else:
            self.queryfname = self.selectedResult.filename
        self.queryImgFilename(self.queryfname)

    def onResultsMenuRandomQuery(self):
        """called when the user asks to find random images from db """
        self.showQueryResults("image",self.curdb.queryRandomImage(self.SearchFromImageResultsSpin.value()))

    def onResultsMenuQuery(self):
        """ function to be called when you want to query for a similar image

        self.selectedResult should have a .filename attribute or .id
        """
        if not self.selectedResult:
            return
        try:
            self.SearchImagePixmap.setPixmap(self.selectedResult.pixmap())
        except:
            try:
                self.SearchImagePixmap.setPixmap(self.curdb.getThumbDB(self.selectedResult.id))
            except:
                pass                    # give up
        a0 = self.selectedResult
        if not hasattr(a0,"filename"):
            self.queryfname = self.curdb.img[a0.id][0]
            self.SearchImportcombo.setCurrentText(self.queryfname)
            self.showQueryResults("image",self.startQueryDB(a0.id,10))
        else:
            self.queryImgByFilename(self.selectedResult.filename)

    def onDrawColorChange(self):
        self.colorSamplepixmapLabel.setPaletteBackgroundColor(QColor(self.DrawQueryColorPixmap.color[0],self.DrawQueryColorPixmap.color[1],self.DrawQueryColorPixmap.color[2],QColor.Rgb))

    def updateStatusInfo(self):
        if not self.curdb:
            self.dbsizeLabel.setText("No database loaded. Use the File menu")
            return
        if not len(self.curdb.img.keys()):
            self.dbsizeLabel.setText("Before searching, you need to add images to your collection. Click on the \"Add\" tab.")
            return
        self.dbsizeLabel.setText(" %d images "%self.curdb.getTotalFiles())

    def updateStatusBar(self,nstr = "Ready."):
        """ shows msg nstr for 3 seconds """
        sbar = self.statusBar()
        if not self.curdb:
            sbar.message("No database loaded. Use the File menu")
            return
        if not nstr:nstr = self.str("Ready.")
        sbar.message(nstr,3000)
        self.updateStatusInfo()

    def fileNew(self):
        filename = str(QFileDialog.getSaveFileName("", "*.iqd", self, "Choose filename for the new database."))
        if filename:
            self.curdb.reset()
            self.curdb.changefname(filename)

    def fileOpen(self,fname = None):
        if self.curdb.dirty:
            res = QMessageBox.information( self, app_title,"Unsaved changes to current database will be lost, continue ?",   QString("&Continue opening"), QString("Cancel"))
            if  res:return
        if not fname:
            filename = str(QFileDialog.getOpenFileName("", "*.iqd", self, "Choose database file to open"))
            if not filename: return
        else:
            filename = fname
        if not os.path.exists(filename): return
        if not self.curdb.opendb(filename):
            self.msgerror("Error opening database file.\n Current database is empty.")
        else:                           # opened ok
            self.addRecentDatabases(filename)
            self.onConfigChange()
            self.loadRecentDatabases()
        self.updateStatusBar("Database opened successfully")

    def fileSave(self):
        if not self.curdb.savedb():
            self.msgerror("Error saving database file.")
            return
        self.updateStatusBar("Database saved successfully")

    def fileExit(self):
        self.onExitActions()

    def fileSaveAs(self):
        filename = str(QFileDialog.getSaveFileName("", "*.iqd", self, "Choose database file to save as"))
        if not filename: return
        self.curdb.changefname(filename)
        if not self.curdb.savedb():
            self.msgerror("Error saving database file.")
            return
        self.updateStatusBar("Database saved successfully")

    def onExitActions(self):
        print "Exiting..."
        if self.curdb.dirty:
            #QMessageBox ( const QString & caption, const QString & text, Icon icon, int button0, int button1, int button2, QWidget * parent = 0, const char * name = 0, bool modal = TRUE, WFlags f = WStyle_DialogBorder )
            #res = QMessageBox.information(None, app_title,
            #"Unsaved changes to current database will be lost, save before exiting ?",
            #QString("&Save"), QString("Discard changes"))
            #if not res:
            self.curdb.closedb()
        self.saveHistory()
        self.onConfigChange()
        sys.exit(0)
        self.app.quit()

    def helpIndex(self):
        hd = QDialog(self)
        vbox = QVBoxLayout(hd)
        hd.resize(QSize(600,400))
        tb = QTextBrowser(hd)
        import imgSeekLib.helpText
        tb.setText(imgSeekLib.helpText.helpindex)
        vbox.addWidget(tb)
        vbox.activate()
        hd.show()

    def helpAbout(self):
        QMessageBox.about ( self, "About "+app_title,\
"""
imgSeek version %s

For copyright info see the COPYING file included in the distribution.

Site:
http://imgseek.sourceforge.net/

Author:
Ricardo Niederberger Cabral
<nieder@mail.ru>
"""%str(imgSeekLib__version__))

    def editcategaction_activated(self):
        if not self.BatchMgrFrm:
            try:
                from imgSeekLib.BatchEditWnd import BatchEditWnd
            except:
                Error.PrintTB("Unable to find one of the modules required. Make sure this program was installed properly. ")
            self.BatchMgrFrm = BatchEditWnd(self,self.env)
        self.BatchMgrFrm.show()

    def removedead_activated(self):
        self.updateStatusBar("Checking for dead files and removing them from database...")
        numrem = self.curdb.remove_dead()
        self.info("%d file(s) removed."%numrem)
        self.updateStatusBar()

    def globalslide_activated(self):
        flist = []
        for fil in self.curdb.img.keys():
            flist.append(self.curdb.img[fil][0])
        self.doSlideShow(flist)

    def editmeta_activated(self):
        if not self.curdb.getTotalFiles():
            self.info("Database is empty. Please add images before invoking this dialog.")
            return
        if not self.MetaForm:
            try:
                from imgSeekLib.MetaWnd import MetaWnd
            except:
                Error.PrintTB("Unable to find one of the modules required. Make sure this program was installed properly. ")
            self.MetaForm = MetaWnd(self,env = self.env)
        self.MetaForm.show()

    def resethtml_activated(self):
        self.htmlinc = []

    def createhtml_activated(self,bid = None):
        """call to show html album wizard

        @param bid: batch id to start selected when dialog appears
        """
        if not self.AlbumForm:
            try:
                from imgSeekLib.AlbumWiz import AlbumWiz
            except:
                Error.PrintTB("Unable to find one of the modules required. Make sure this program was installed properly. ")
            self.AlbumForm = AlbumWiz(self,self.env)
        if bid:
            self.AlbumForm.curBatch = bid
            self.AlbumForm.showBatch(bid)
            self.AlbumForm.batchcombo.setCurrentText(self.curdb.batches[bid][0])

        self.AlbumForm.show()

    def RenameAction_activated(self):
        if not self.RenameForm:
            try:
                from imgSeekLib.RenameWiz import RenameWiz
            except:
                Error.PrintTB("Unable to find one of the modules required. Make sure this program was installed properly. ")
            self.RenameForm = RenameWiz(self,self.env)
        self.RenameForm.show()

    def ExportAction_activated(self):
        if not self.ExportForm:
            try:
                from imgSeekLib.ExportWnd import ExportWnd
            except:
                Error.PrintTB("Unable to find one of the modules required. Make sure this program was installed properly. ")
            self.ExportForm = ExportWnd(self,self.env)
        self.ExportForm.show()

    def ImportAction_activated(self):
        if not self.ImportForm:
            try:
                from imgSeekLib.CSVImportWnd import CSVImportWnd
            except:
                Error.PrintTB("Unable to find one of the modules required. Make sure this program was installed properly. ")
            self.ImportForm = CSVImportWnd(self,self.curdb)
        self.ImportForm.show()

    def info(self,str):
        QMessageBox.information( self, app_title,str)

    def msgerror(self,str):
        QMessageBox.critical( self, app_title,str)

    def startQuery(self,source,maxres,txtquery = "",nqueryImage=1):
        """ starts a query. source is either image draw or text.
        nqueryImage ==1 means its a photo, 0 means a drawing
        """
        self.statusBar().message("Searching...")
        self.SearchImageIconView.clear()
        self.app.processEvents()
        if source == "text":
            results = self.curdb.textquery(txtquery,maxres)
        elif source =="image":
            self.focusQueryImage()
            results = self.curdb.queryImage(self.queryfname,self.SearchFromImageResultsSpin.value(),nqueryImage, removeFirst = 0)
        self.updateStatusBar()
        return results

    def startQueryDB(self,id,maxres):
        """ starts a query. source is either image draw or text.  """
        self.statusBar().message("Searching...")
        self.app.processEvents()
        #self.focusQueryImage()
        results = self.curdb.queryData(id,self.SearchFromImageResultsSpin.value())
        self.updateStatusBar()
        return results

    def SearchImageBtn_clicked(self):
        if not self.curdb.getTotalFiles():
            self.info("You have no image on database. Use the \"Add\" tab.")
            return
        maxres = self.SearchFromImageResultsSpin.value()
        if self.searchtabWidget.currentPageIndex() == 1: # searching for text keyworkd
            source = "text"
            metaq = []
            for ri in range(self.querytable.numRows()):
                try:
                    metaq.append([str(self.querytable.text(ri,0)),str(self.querytable.text(ri,1))])
                except:
                    Error.PrintTB("Error parsing your query:"+str(ri))
            atime = time.asctime(time.localtime())
            results = self.startQuery(source,maxres,txtquery=[metaq,str(self.logicCombo.currentText())])
            atime = atime+" - %d results" % len(results)
            self.curdb.textqueryhistory.append([atime,metaq])
            self.curdb.dirty = 1
            self.queryhistorycombo.insertItem(atime)
            textsearch = 1
        else:                           # query target is an image
            queryImage = 1
            source = "image"
            if self.queryImagetabWidget.currentPageIndex() == 1: # sketch query
                queryImage = 0
                self.queryfname = self.dbdir+"sketch.png"
                try:
                    self.DrawQueryPixmap.buffer.save(self.queryfname,"PNG")
                except:
                    self.msgerror(self.tr("Unable to save sketch on temporary file ")+self.queryfname)
                    return
            results = self.startQuery(source,maxres,nqueryImage=queryImage)
        self.showQueryResults(source,results)

    def showQueryResults(self,source,results):
        self.lastSearch.append([source,results])
        if not len(results):
            self.info(self.tr("No results."))
            self.updateStatusBar()
            return
        probloading = 0
        self.statusBar().message(self.tr("Generating thumbnails..."))
        self.displayedFiles = []
        self.SearchImageIconView.clear()
        for res in results:
            try:
                fname = self.curdb.img[res[0]][0]
                aImage = self.curdb.getThumbDB(res[0])
                if not aImage:
                    probloading = 1
                    continue
                self.displayedFiles.append(fname)
                if source=="text":
                    try:
                        fname = os.path.split(self.curdb.img[res[0]][0])[-1]
                    except:
                        pass
                    qit = QIconViewItem( self.SearchImageIconView, fname, aImage )
                else:
                    qit = QIconViewItem( self.SearchImageIconView, "%.2f%%"% (res[1]), aImage )
                qit.id = res[0]
            except:
                Error.PrintTB("This search result won't be displayed.(cause above) ")
        #if probloading:  #TODO3: this was an annoying popup warning, removing it.
        #    self.info("Unable to load one or more images from the query results. Perhaps another application removed an image. ")

        self.focusQueryImage()
        self.updateStatusBar("Search complete.")
        self.SearchImageIconView.arrangeItemsInGrid(1)

    def AddImageMore_clicked(self):
        addfname = str(self.addImageEdit.currentText())
        if not os.path.isdir(addfname):
            addfname = None
        filename = str(QFileDialog.getExistingDirectory(addfname))
        if os.name not in ["posix"]:
            filename = replace(filename,'/','\\')
        self.addImageEdit.setCurrentText(filename)
        self.addImageEdit.insertItem(filename,0)

    def getAddRestrictions(self):
        """ returns an add restrictions object. This kind of object holds all info necessary for the add dir to db function
        """
        try:
            volid = self.curdb.volumes.keys()[self.VolumeCombo.currentItem()]
        except:
            self.msgerror("Error setting destination Volume. Please supply a valid one. If there is no volume on you collection, add one clicking on the Add Volume button.")
            return
        if self.autoCreateGroupCheck.isChecked(): # create new group and set id
            groupid = self.curdb.newGroup(time.asctime(time.localtime()))
            if groupid == -1:
                self.info("Group name already exists. Please try another.")
                return
            self.addGroupToView(self.BrowseCategListView,groupid)
        else:                           # just use the id of the selected group
            try:
                groupid = self.curdb.groups.keys()[self.GroupCombo.currentItem()]
            except:
                self.msgerror("Error setting destination Group. Please supply a valid one. If there is no group on you collection, add one clicking on the Add Group button.")
                return
        # Make sure user REALLY want to add text,pdf,etc
##        ignext2 = []
##        ignext = split(str(self.ignoreExtEdit.text()),',')
##        for nxt in ignext:
##            ignext2.append(lower(nxt))
##        if ("txt" not in ignext2) or ("pdf" not in ignext2) or ("ps" not in ignext2)or ("htm" not in ignext2)or ("html" not in ignext2):
##            res = QMessageBox.information( self, "imgSeek",self.str("Are you sure you want "),   QString(self.str("&Continue anyway")), QString(self.str("Cancel")))
##            if res: return
        curt = str(self.ignoreExtEdit.text())
        origign = curt[:]
        if self.ignoredoccheck.isChecked():
            if not curt:
                self.ignoreExtEdit.setText("txt,pdf,ps,htm,html")
            else:
                if curt[-1] != ',':curt = curt+','
                curt = curt+"txt,pdf,ps,htm,html"
                self.ignoreExtEdit.setText(curt)
        addfname = str(self.addImageEdit.currentText())
        addfname = os.path.expanduser(addfname)
        minsz = None
        minDim = 0
        nstr = ""
        try:
            if str(self.ignoreSizeEdit.text()):
                minsz = int(str(self.ignoreSizeEdit.text()))
            if str(self.ignoreDimEdit.text()):
                minDim = int(str(self.ignoreDimEdit.text()))
            nstr = str(self.ignoreTextAddEdit.text())
            igntxt = str(self.ignoreExtEdit.text())
            self.ignoreExtEdit.setText(origign)
        except:
            Error.PrintTB("Error reading ignore parameters provided, please enter valid values.")
            return
        # fill filtering information and add options
        restr = ImgDB.AddFilter(self.env)
        # process ignexts
        if igntxt:
            restr.ignext = map(lower,split(igntxt,',')) # make sure user input is lower case
            restr.ignext = map(strip,restr.ignext) # make sure user input has no trailing spaces
        restr.minsize = minsz
        restr.mindim = minDim
        restr.igntext = nstr
        restr.removeEmptyGroup = self.autoCreateGroupCheck.isChecked()
        restr.mounted = self.mountablecheck.isChecked()
        restr.exexif = self.extractexifcheck.isChecked()
        restr.exiptc = self.extractiptccheck.isChecked()
        restr.probeext = self.probeextcheck.isChecked()
        restr.followsym = self.followsymlinkscheck.isChecked()
        restr.addfname = addfname
        restr.volid = volid
        restr.groupid = groupid
        return restr

    def addImageBtn_clicked(self):
        if self.doingAdd: return
        self.sysDirAddCallback(self.getAddRestrictions())

    def SearchImageMore_clicked(self):
        filename = str(QFileDialog.getOpenFileName("", "Images (*.jpg *.gif *.bmp *.png *.jpeg *.tif *.tiff *.JPG *.GIF *.BMP *.PNG *.JPEG)\nAll files (*)", self, "Choose file."))
        if not filename: return
        self.SearchImportcombo.setCurrentText(filename)
        self.SearchImportcombo.insertItem(filename)
        self.queryfname = str(filename)
        self.tempQueryImage = self.curdb.openImage(self.queryfname)
        if not self.tempQueryImage:
            self.tempQueryImage = None
            self.msgerror("Error loading query image provided.")
            return
        self.tempQueryImage = self.tempQueryImage.smoothScale(128,128)
        aPixmap = QPixmap()
        aPixmap.convertFromImage(self.tempQueryImage)
        self.SearchImagePixmap.setPixmap(aPixmap)

    def BrowseImageDirEdit_textChanged(self,a0):
        quer = lower(str(a0))
        self.BrowseIconView.clear()
        if len(quer)<3:
            self.updateStatusBar("Enter a text query with more than 2 characters")
            return
        fnd = 0
        for fl in self.curdb.img.keys():
            fname = self.curdb.img[fl][0]
            if find(lower(fname),quer)!=-1: #found
                respair = fname
                aImage = self.curdb.getThumbDB(fl)
                if not aImage: continue
                qit = QIconViewItem( self.BrowseIconView, respair, aImage )
                fnd = 1
                qit.id = fl
        if not fnd:self.updateStatusBar("String returned no results.")

    def sortHiddenIcons(self, how='fname'):
        """ sorts hidden icons to be displayed on a thumbnail view by the given criteria
        """
        def srt_fname(x,y):
            if x[0]>y[0]:
                return 1
            else:
                return -1
        
        if how == 'fname':
            srt = srt_fname
            
        self.hiddenIcons.sort(srt)

    def BrowseDirListView_clicked(self,a0):
        """ populate BrowseByDir iconview with thumbnails """
        if not a0:return
        self.lastIconDisplayAction = [self.BrowseDirListView_clicked,a0]
        self.BrowseDirListView.mousePressed = 0
        warning = 0                       # if there is a warning being displayed on statusbar
        if a0.isDir==1:
            if self.BrowseIconView.shownID == a0.dirid:return
            try: # try showing a little bit of the thumb view if its hidden
                if self.browsehsplit.sizes()[0] < 10:
                    self.updateStatusBar("[WARNING] Thumbnail view is hidden. Drag the horizontal bar near the top of the Browse tab.")
                    warning = 1
            except:
                Error.PrintTB()
                pass
            self.BrowseIconView.clear()
            self.displayedFiles = self.curdb.dirs[a0.dirid][4]
            self.BrowseIconView.shownID = a0.dirid
            self.thumbLabel.setText("%s - %d image(s)"%(self.curdb.dirs[a0.dirid][0],len(self.curdb.dirs[a0.dirid][3])))
            self.thumbLabel.orig = "%s - %d image(s)"%(self.curdb.dirs[a0.dirid][0],len(self.curdb.dirs[a0.dirid][3]))
            self.hiddenIcons = []
            for idx in self.curdb.dirs[a0.dirid][3]:
                respair = self.curdb.img[idx][0]
                fname = rfind(respair,os.sep)
                if fname==-1:
                    fname = respair
                else:
                    fname = respair[fname+1:]
                self.hiddenIcons.append([fname,respair,["id",idx]])
            self.sortHiddenIcons()
            self.populateMoreIcons(40)
        elif a0.isDir==2: #is image
            fname = self.curdb.img[a0.id][0]
            self.FullView.showImg(fname,fid = a0.id)

    def updateAddTab(self):
        """sync Volume and Group combo on the Add tab with current db
        """
        self.VolumeCombo.clear()
        for volid in self.curdb.volumes.keys():
            self.VolumeCombo.insertItem(self.curdb.volumes[volid][3])
        self.GroupCombo.clear()
        for volid in self.curdb.groups.keys():
            self.GroupCombo.insertItem(self.curdb.groups[volid][0])
        try:
            self.GroupCombo_activated(0)
            self.VolumeCombo_activated(0)
        except:
            pass

    def updateDatabaseInfoText(self):
        self.DatabaseInfoLabel.setText(self.curdb.TextReport())

    def addGroupToView(self,parent,gid,categlist = 1):
        lvi = QListViewItem(parent,self.curdb.groups[gid][0],str(len(self.curdb.groups[gid][3]))+" file(s) / "+str(len(self.curdb.groups[gid][4]))+" group(s)")
        lvi.groupid = gid
        if gid in self.curdb.openGroups:
            lvi.setOpen(1)
        else:
            lvi.setOpen(0)
        lvi.isGroup = 1
        lvi.setPixmap(0,self.bookicon)
        for chid in self.curdb.groups[gid][4]:
            self.addGroupToView(lvi,chid, categlist)
        if categlist:
            for chid in self.curdb.groups[gid][3]:
                fsize = ""
                try:
                    fsize = self.curdb.meta[chid]["Filesize"]
                except:
                    pass
                try:
                    nvi = QListViewItem(lvi,self.curdb.meta[chid]["Filename"],fsize)
                except:
                    nvi = QListViewItem(lvi,os.path.split(self.curdb.img[chid][0])[-1],fsize)
                nvi.isGroup = 0
                nvi.id = chid

    def addDirToDirview(self,parent,dirid,root):
        """isDir = 1 for dirs
        =2 for files
        =0 for volumes
        """
        if not dirid:
            return
        if root:                        # adding to the root of a volume
            lvi = QListViewItem(parent,self.curdb.dirs[dirid][0][1:-1],str(len(self.curdb.dirs[dirid][3]))+" file(s) / "+str(len(self.curdb.dirs[dirid][2]))+" dir(s)")
            lvi.setPixmap(0,self.foldericon)
        else:
            try:
                k = self.curdb.dirs[dirid][0]
                lvi = QListViewItem(parent,k[rfind(k[:-1],os.sep)+1:-1],str(len(self.curdb.dirs[dirid][3]))+" file(s)")
                lvi.setPixmap(0,self.foldericon)
            except:
                Error.PrintTB("dirid:"+str(dirid)+ " parent:"+str(parent))
                try:                    #TODO3: this fix should not even exist in the first place. Orphan dirs shouldn't exist
                    self.curdb.dirs[parent.dirid][2].remove(dirid)
                except:
                    Error.PrintTB()
                return
        lvi.dirid = dirid
        if dirid in self.curdb.openDirs:
            lvi.setOpen(1)
        else:
            lvi.setOpen(0)
        lvi.isDir = 1
        for chid in self.curdb.dirs[dirid][3]:
            fsize = ""
            mdate = ""
            try:
                fsize = self.curdb.meta[chid]["Filesize"]
                mdate = self.curdb.meta[chid]["Modify date"]
            except:
                pass
            try:
                nvi = QListViewItem(lvi,self.curdb.meta[chid]["Filename"],fsize,mdate)
            except:
                nvi = QListViewItem(lvi,os.path.split(self.curdb.img[chid][0])[-1],fsize,mdate)
            nvi.isDir = 2
            nvi.id = chid
        lvi.sortChildItems ( 0, 1 )
        for chid in self.curdb.dirs[dirid][2]:
            self.addDirToDirview(lvi,chid,0)

    def updateDirList(self):
        """updates dir list of files in database
        called when browse img lib tab is focused or unfocused """
        if not self.curdb:return
        self.BrowseDirListView.clear()
        for volid in self.curdb.volumes.keys():
            lvi = QListViewItem(self.BrowseDirListView,self.curdb.volumes[volid][3])
            lvi.volid = volid
            if volid in self.curdb.openDirs:
                lvi.setOpen(1)
            else:
                lvi.setOpen(0)
            lvi.setPixmap(0,self.bookicon)
            lvi.isDir = 0
            ## add dirs
            for dirid in self.curdb.volumes[volid][0]:
                if self.curdb.dirs[dirid][1] == -1: #root dir
                    self.addDirToDirview(lvi,dirid,1)

    def updateGroupList(self):
        """updates dir list of files in database
        called when browse img lib tab is focused or unfocused """
        self.BrowseCategListView.clear()
        self.AvailableGroupsListView.clear()
        for gid in self.curdb.groups.keys():
            if self.curdb.groups[gid][2]==-1: #root group
                self.addGroupToView(self.BrowseCategListView,gid,1)
                self.addGroupToView(self.AvailableGroupsListView,gid,0)

    def EraserBtn_clicked(self):
        res = QMessageBox.information( self, app_title,"This will erase all the contents of the current drawing, continue ?",   QString("&Erase"), QString("Cancel"))
        if not res:
            self.DrawQueryPixmap.reset()

    def SearchImageIconView_doubleClicked(self,a0):
        """ user double-clicked a search result
        """
        self.SearchImagePixmap.setPixmap(a0.pixmap())
        self.queryfname = self.curdb.img[a0.id][0]
        self.tempQueryImage = a0.pixmap().convertToImage()
        self.showQueryResults("image",self.startQueryDB(a0.id,10))
        self.SearchImportcombo.setCurrentText(self.queryfname)

    def SearchImageIconView_returnPressed(self,a0):
        self.SearchImageIconView_doubleClicked(a0)

    def SearchImageIconView_contextMenuRequested(self,a0,a1):
        if not a0:
            if not self.SearchImageIconView.firstItem():return # don't popup if there is no result displayed
            self.resultsViewMenu.popup(a1)
            return
        self.selectedResult = a0
        self.browseDirMenu.popup(a1)

    def SearchImageIconView_onItem(self,a0):
        try:
            self.updateStatusBar(self.curdb.img[a0.id][0])
        except:
            pass

    def adddirrecursivecheckBox_toggled(self,a0):
        self.env.options["database.recursiveadd"] = str(self.adddirrecursivecheckBox.isChecked())
        self.onConfigChange()

    def focusQueryImage(self):
        """focus the import image for query tab, which displays a thumbnail of the current image being queried.  """
        self.MainTabWidget.setCurrentPage(2)
        self.searchtabWidget.setCurrentPage(0)

    def brushsizeslider_valueChanged(self,a0):
        self.colorSamplepixmapLabel.resize(int(1.8*int(a0)),int(1.8*int(a0)))
        self.DrawQueryPixmap.pen.setWidth(a0)

    def updateCategoryView(self):
        self.BrowseSimCatIconView.clear()
        if not len(self.curdb.simgroups.keys()):
            return # in case images haven't been grouped yet
        self.thumbLabel.setText("Similar images view")
        self.thumbLabel.orig = "Similar images view"
        self.displayedFiles = []

        for id in self.curdb.simgroups.keys():
            aImage = None
            #self.displayedFiles.append(self.curdb.img[self.curdb.simgroups[id][1]][0])
            try:
                fname = self.curdb.meta[self.curdb.simgroups[id][1]]["Filename"]
                aImage = self.curdb.getThumbDB(self.curdb.simgroups[id][1])
            except:
                #TODO2: after deleting some files, their similarity group still exists, causing an error here.
                pass
            if not aImage: continue
            extf = rfind(fname,'.')
            if extf==-1: extf = fname
            else:
                extf = fname[:extf]+" - "+str(len(self.curdb.simgroups[id][2]))
            qit = QIconViewItem( self.BrowseSimCatIconView, extf, aImage )
            qit.simgroupid = id
            qit.isDir = 3
            qit.id = self.curdb.simgroups[id][1]

    def categorizeButton_clicked(self):
        if len(self.curdb.img) < 4:
            self.info("Your collection is too small for generating similarity groups automatically, so if a grouping method fails, try adding more images to your database.")

        self.updateStatusBar("Grouping images, please wait...")
        self.app.processEvents()
        if not len(str(self.thresEdit.text())):
            self.thresEdit.setText("50")
        self.env.options["browse.groupthreshold"] = str(self.thresEdit.text())
        self.onConfigChange()
        try:
            thres = float(str(self.thresEdit.text()))
            self.curdb.updateGroups(self.app,thres,str(self.groupByCombo.currentText()))
        except:
            traceback.print_exc()
            self.info("Error doing automatic grouping process. Please, enter a valid threshold and try again.")
            return
        self.updateCategoryView()
        self.updateStatusBar("Grouping done.")

    def BrowseSimCatIconView_contextMenuRequested(self,a0,a1):
        if not a0: return
        self.selectedResult = a0
        self.selectedResult.isDir = 3
        self.simBrowseMenu.popup(a1)

    def BrowseSimCatIconView_clicked(self,a0):
        if not a0:return
        self.lastIconDisplayAction = [self.BrowseSimCatIconView_clicked,a0]
        if self.BrowseIconView.shownID == a0.simgroupid:
            return # don't display what's already displayed...

        probloading = 0
        self.BrowseIconView.clear()
        self.hiddenIcons = []
        self.displayedFiles = []
        try:
            self.thumbLabel.setText("Images similar to "+self.curdb.img[a0.id][0]+" - "+str(len(self.curdb.simgroups[a0.simgroupid][2]))+" image(s)")
            self.thumbLabel.orig = "Images similar to "+self.curdb.img[a0.id][0]+" - "+str(len(self.curdb.simgroups[a0.simgroupid][2]))+" image(s)"
        except:
            self.thumbLabel.setText("Similarity view")
            self.thumbLabel.orig = "Similarity view"

        self.BrowseIconView.shownID = a0.simgroupid
        if not self.curdb.simgroups.has_key(a0.simgroupid):
            print "Attempt to display invalid group, try removing dead files on the Collection menu, and regenerating your similarity groups."
            return

        for idx in self.curdb.simgroups[a0.simgroupid][2]:
            try:
                respair = self.curdb.img[idx][0]
                self.displayedFiles.append(respair)
                fname = rfind(respair,os.sep)
                if fname==-1:
                    fname = respair
                else:
                    fname = respair[fname+1:]
                self.hiddenIcons.append([fname,respair,["id",idx]])
            except:
                Error.PrintTB("This image won't be displayed. Reason:")

        self.sortHiddenIcons()        
        self.populateMoreIcons(80)

    def resizeEvent (self,e):
         self.env.options["view.mainwidth"] = str(self.width())
         self.env.options["view.mainheight"] = str(self.height())
         MainForm.resizeEvent(self,e)

    def BrowseDirListView_contextMenuRequested(self,a0,a1,a2):
        if not a0:
            self.browseDirMenu4.popup(a1)
            return
        self.selectedResult = a0
        if len(self.selectedIDs)<2:
            if a0.isDir==1:
                self.browseDirMenu2.popup(a1)
            elif a0.isDir==0:
                self.browseDirMenu3.popup(a1)
            elif a0.isDir==2:
                self.browseDirMenu.popup(a1)
        else:
            self.browseDirMSelMenu.popup(a1)

    def doSlideShow(self,flist):
        """ do slideshow on the give file list"""
        if not len(flist):
            self.updateStatusBar("No files inside this directory/category.")
            return
        from imgSeekLib.SlideShowDialog import SlideShowDialog
        ds = SlideShowDialog(self,self.env)
        ds.flist = flist
        try:
            ds.start(self.slidedelayspin.value()*1000)
        except:
            Error.PrintTB("Error starting slideshow. Make sure slide delay is a valid integer.")

    def onResultsMenuSlideshow(self):
        if not self.selectedResult: return
        try:
            flist = []
            if self.selectedResult.isDir==1:
                if int(self.env.options["view.recurseslide"]):
                    self.curdb.crawlDirForImg(self.selectedResult.dirid,flist)
                    fnlist = []
                    for fid in flist: fnlist.append(self.curdb.img[fid][0])
                    flist = fnlist
                else:
                    flist = self.curdb.dirs[self.selectedResult.dirid][4]
            elif self.selectedResult.isDir==0: # that means its a volume
                for gid in self.curdb.volumes[self.selectedResult.volid][0]:
                    idlist = []
                    self.curdb.crawlDirForImg(gid,idlist)
                    for fid in idlist: flist.append(self.curdb.img[fid][0])
            elif self.selectedResult.isDir==3: # sim group
                idlist = self.curdb.simgroups[self.selectedResult.simgroupid][2]
                for fid in idlist: flist.append(self.curdb.img[fid][0])
            if not flist:return
            self.doSlideShow(flist)
        except:
            traceback.print_exc()
            return

    def gohomebtn_clicked(self):
        #TODO0: im getting a  "path not found" error on win32 here
        fuln = os.path.expanduser(os.path.join("~",""))
        self.BrowseSysDirListView.showPath(fuln)

    def showMetaDlg(self):
        if not self.selectedResult: return
        if not self.MetaForm:
            try:
                from imgSeekLib.MetaWnd import MetaWnd
            except:
                Error.PrintTB("Unable to find one of the modules required. Make sure this program was installed properly. ")
            self.MetaForm = MetaWnd(self,self.env,self.selectedResult.id)
        else:
            self.MetaForm.showFile(self.selectedResult.id)
        self.MetaForm.show()

    def showdotcheck_toggled(self,a0):
        self.sysdiroptMenu.setItemChecked(5,not self.sysdiroptMenu.isItemChecked(5))
        self.env.options["browse.showdotfiles"] = str(self.sysdiroptMenu.isItemChecked(5))
        self.BrowseSysDirListView.showDots(self.sysdiroptMenu.isItemChecked(5))
        self.onConfigChange()

    def shownormalcheck_toggled(self,a0):
        self.sysdiroptMenu.setItemChecked(6,not self.sysdiroptMenu.isItemChecked(6))
        self.env.options["browse.shownormalfiles"] = str(self.sysdiroptMenu.isItemChecked(6))
        self.BrowseSysDirListView.showNormalFiles(self.sysdiroptMenu.isItemChecked(6))
        self.onConfigChange()

    def slidedelayspin_valueChanged(self,a0):
        self.env.options["view.slidedelay"] = str(a0)
        self.onConfigChange()

    def BrowseIconView_onItem(self,a0):
        try:
            self.updateStatusBar(self.curdb.img[a0.id][0])
        except:
            pass

    def BrowseIconView_contextMenuRequested(self,a0,a1):
        if not a0:
            self.emptyIconViewMenu.popup(a1)
            return
        self.selectedResult = a0
        if hasattr(a0,"filename"): #is a system file thumbnail
            self.browseDirMenuSys.popup(a1)
        else:
            if len(self.selectedIDs)==1:
                self.browseDirMenu.popup(a1)
            else:
                self.browseGroupMSelMenu.popup(a1)
    def BrowseIconView_doubleClicked(self,a0):
        self.selectedResult = a0
        self.onResultsMenuQuery()

    def BrowseIconView_returnPressed(self,a0):
        self.BrowseIconView_doubleClicked(a0)

    def BrowseIconView_clicked(self,a0,a1):
        if not a0:return
        self.selectedResult = a0
        j = int(self.env.options["browse.thumbsingleclick"])
        if j==0:
            # show img
            imid = -1
            if not hasattr(a0,"id"): # is browsing by systems dirs
                fname = a0.filename
                self.curdb.visited(fname)
            else:
                fname = self.curdb.img[a0.id][0]
                imid = a0.id
            self.FullView.showImg(fname,fid = imid)
        elif j==1:
            if not hasattr(a0,"id"): # is browsing by systems dirs
                return
            self.showMetaDlg()
        elif j==2:
            self.BrowseIconView_doubleClicked(a0)

    def queryhistorycombo_activated(self,a0):
        try:
            from qttable import QComboTableItem
        except:
            Error.PrintTB("missing qt feature")
        try:
            self.querytable.setNumRows(len(self.curdb.textqueryhistory[a0][1]))
        except IndexError:
            self.querytable.setNumRows(0)
            self.syncMetaQueryHistory()
            self.msgerror("Error loading selected history entry.")
            return

        for cmb in self.querycombos:
            del cmb
        self.querycombos = []
        cnt = 0
        for entry in self.curdb.textqueryhistory[a0][1]:
            a = QComboTableItem ( self.querytable, self.metalist, 1 )
            self.querycombos.append(a)
            self.querytable.setItem(cnt,0,a)
            self.querytable.setText(cnt,1,str(entry[1]))
            a.setCurrentItem(entry[0])
            cnt = cnt+1

    def savedrawbtn_clicked(self):
        if not os.path.exists(os.path.join(self.dbdir,"sketch")):
            os.mkdir(os.path.join(self.dbdir,"sketch"))
        fname = str(self.curdb.generateImageID())+".png"
        fname = os.path.join(self.dbdir,"sketch",fname)
        self.DrawQueryPixmap.buffer.save(fname,"PNG")
        self.sketchhistory.append(fname)
        aPixmap = QPixmap(self.DrawQueryPixmap.buffer)
        self.sketchescomboBox.insertItem(aPixmap)

    def sketchescomboBox_activated(self,a0):
        aImage = self.curdb.openImage(self.sketchhistory[a0])
        if not aImage:
            self.msgerror("Error loading selected sketch.")
        aPixmap = QPixmap()
        aPixmap.convertFromImage(aImage)
        self.DrawQueryPixmap.buffer = aPixmap
        self.DrawQueryPixmap.paintEvent(1)
        self.sketchRelease()

    def newvolbtn_clicked(self):
        self.onNewVol()

    def newgroupbtn_clicked(self):
        text = str(QInputDialog.getText("imgSeek","New group name:" ,QLineEdit.Normal, time.asctime(time.localtime()))[0])
        if text:
            nid = self.curdb.newGroup(text)
            if  nid == -1:
                self.info("Group name already exists. Please try another.")
                return
            self.addGroupToView(self.BrowseCategListView,nid)
            #self.GroupCombo.insertItem(text)
            self.GroupCombo.setCurrentText(text)

    def GroupCombo_activated(self,a0):
        self.groupDescLabel.setText(self.curdb.groups[self.curdb.groups.keys()[a0]][1])

    def VolumeCombo_activated(self,a0):
        self.VolDescLabel.setText(self.curdb.volumes[self.curdb.volumes.keys()[a0]][2])

    def BrowseCategListView_contextMenuRequested(self,a0,a1,a2):
        if not a0:
            self.selectedResult = None
            self.selectedIDs = []
            self.groupMenu2.popup(a1)
            return
        self.selectedResult = a0
        if len(self.selectedIDs)==1:
            if a0.isGroup:
                self.groupMenu.popup(a1)
            else:
                self.browseDirMenu.popup(a1)
        else:
            if a0:self.browseGroupMSelMenu.popup(a1)

    def BrowseCategListView_doubleClicked(self,a0):
        if not hasattr(a0,"id"): return
        self.selectedResult = a0
        self.onResultsMenuQuery()

    def BrowseCategListView_returnPressed(self,a0):
        self.BrowseCategListView_doubleClicked(a0)

    def BrowseCategListView_clicked(self,a0):
        if not a0:return
        self.lastIconDisplayAction = [self.BrowseCategListView_clicked,a0]
        if a0.isGroup:
            if self.BrowseIconView.shownID == a0.groupid: return # don't show it again
            self.BrowseIconView.clear()
            self.displayedFiles = []
            self.thumbLabel.setText("%s - %d image(s)"%(self.curdb.groups[a0.groupid][0],len(self.curdb.groups[a0.groupid][3])))
            self.thumbLabel.orig = "%s - %d image(s)"%(self.curdb.groups[a0.groupid][0],len(self.curdb.groups[a0.groupid][3]))
            self.BrowseIconView.shownID = a0.groupid
            self.BrowseIconView.shownIDName = self.curdb.groups[a0.groupid][0][0]
            self.statusBar().message("Generating thumbnails...")
            self.hiddenIcons = []
            idlist = []
            if int(self.env.options["browse.showgrouprecursive"]):
                self.curdb.crawlGroupForImg(a0.groupid,idlist)
            else:
                idlist = self.curdb.groups[a0.groupid][3]

            for idx in idlist:
                respair = self.curdb.img[idx][0]
                self.displayedFiles.append(respair)
                fname = rfind(respair,os.sep)
                if fname==-1:
                    fname = respair
                else:
                    fname = respair[fname+1:]
                self.hiddenIcons.append([fname,respair,["id",idx]])
            
            self.sortHiddenIcons()            
            self.populateMoreIcons(80)
        else: # is file
            self.FullView.showImg(self.curdb.img[a0.id][0],fid = a0.id)

    def BrowseDirListView_onItem(self,a0):
        if not a0.isDir:
            try:
                self.updateStatusBar(self.curdb.volumes[a0.volid][2])
                return
            except:
                pass
        self.updateStatusBar()

    def querytable_contextMenuRequested(self,a0,a1,a2):
        self.selectedRow = a0
        self.fieldMenu.popup(a2)

    def resetqueryhistorybtn_clicked(self):
        self.curdb.textqueryhistory = []
        self.queryhistorycombo.clear()
        self.curdb.savedb()

    def BrowseCategListView_onItem(self,a0):
        if a0.isGroup:
            try:
                self.updateStatusBar(self.curdb.groups[a0.groupid][1])
            except:
                pass

    def clickactioncombo_activated(self,a0):
        self.env.options["browse.thumbsingleclick"] = str(a0)
        self.onConfigChange()

    def ResetSketchBtn_clicked(self):
        res = QMessageBox.information( self, "imgSeek","This will remove all files at ~/.imgseek/sketch/. Are you sure ?",   QString("&Remove sketches"), QString("Cancel"))
        if res: return
        self.sketchhistory = []
        self.sketchescomboBox.clear()
        try:
            if not os.path.exists(os.path.join(self.dbdir,"sketch")):
                os.mkdir(os.path.join(self.dbdir,"sketch"))
                return
            fils = os.listdir(os.path.join(self.dbdir,"sketch"))
            for fil in fils:
                if len(fil) <4 :continue
                if fil[-3:] =="png":
                    os.remove(os.path.join(self.dbdir,"sketch","")+fil)
        except:
            self.msgerror("Error reseting sketch history")
            traceback.print_exc()

    def fitimagecheck_toggled(self,a0):
        if a0:
            self.FullView.pixlabel.imgmenu.setItemChecked(5,1)
            if not self.FullView.fitcb: self.FullView.fitcb.append(1)
        else:
            self.FullView.pixlabel.imgmenu.setItemChecked(5,0)
            if self.FullView.fitcb:
                self.FullView.fitcb.append(1)
        self.env.options["view.autofit"] = str(a0)
        self.onConfigChange()

    def BrowseCategListView_collapsed(self,a0):
        try:
            if a0.isGroup:
                try:
                    self.curdb.openGroups.remove(a0.groupid)
                except:
                    pass
        except:
            pass

    def BrowseCategListView_expanded(self,a0):
        try:
            if a0.isGroup:
                if a0.groupid not in self.curdb.openGroups:
                    self.curdb.openGroups.append(a0.groupid)
        except:
            pass

    def BrowseDirListView_collapsed(self,a0):
        try:
            if a0.isDir==1:
                try:
                    self.curdb.openDirs.remove(a0.dirid)
                except:
                    pass
            if a0.isDir==0:
                try:
                    self.curdb.openDirs.remove(a0.volid)
                except:
                    pass
        except:
            pass

    def BrowseDirListView_expanded(self,a0):
        try:
            if a0.isDir==1:
                if a0.dirid not in self.curdb.openDirs:
                    self.curdb.openDirs.append(a0.dirid)
            if a0.isDir==0:
                if a0.volid not in self.curdb.openDirs:
                    self.curdb.openDirs.append(a0.volid)
        except:
            pass

    def beepcheck_toggled(self,a0):
        self.env.options["database.beep"] = str(a0)
        self.onConfigChange()

    def bookmarkbtn_clicked(self):
        self.sysbookmMenu.popup(self.bookmarkbtn.mapToGlobal(QPoint(0,0)))

    def findduplicatemenu_activated(self):
        if not self.DuplicateForm:
            try:
                from imgSeekLib.DuplicateWiz import DuplicateWiz
            except:
                Error.PrintTB("Unable to find one of the modules required. Make sure this program was installed properly. ")
            self.DuplicateForm = DuplicateWiz(self,self.env)
            self.DuplicateForm.app = self.app
        self.DuplicateForm.show()

    def smoothcheck_toggled(self,a0):
        self.env.options["view.smoothscale"] = str(self.smoothcheck.isChecked())
        self.onConfigChange()

    def rescanonstartupcheck_toggled(self,a0):
        self.env.options["database.autoscannew"] = str(self.rescanonstartupcheck.isChecked())
        self.onConfigChange()

    def refreshdbase_activated(self):
        print "Scanning and adding new files, please wait..."
        count = self.curdb.refreshDB( restr=self.getAddRestrictions() )
        print "Done."

    def onsysBookmarkChanged(self):
        """ callback fired by db when bookm list changes
        this callback is hooked to db.sysdirmbCb by imgSeek, because when this class is inited, there is not yet a curdb
        """
        if not hasattr(self,"sysbookmMenu"): self.sysbookmMenu = None
        if self.sysbookmMenu:del self.sysbookmMenu
        self.sysbookmMenu = QPopupMenu(self)
        self.connect(self.sysbookmMenu,SIGNAL("activated(int)"),self.onsysBookmActivated)
        self.sysbookmMenu.insertItem ( self.fileNewAction.iconSet(),"&Bookmark displayed directory", self.onNewsysBookmark)
        self.sysbookmMenu.insertItem ( self.removedead.iconSet(), "&Remove a bookmark", self.onDelsysBookmark)
        self.sysbookmMenu.insertSeparator()
        self.sysbookmids = {}
        for bm in self.curdb.sysdirbm:
            nid = self.sysbookmMenu.insertItem (self.foldericonset, bm)
            self.sysbookmids[nid] = bm

    def onsysBookmActivated(self,id):
        if self.sysbookmids.has_key(id):
            self.BrowseSysDirListView.showPath(self.sysbookmids[id])

    def onNewsysBookmark(self):
        if not self.BrowseSysDirListView.selectedItmFname:
            return
        if not os.path.isdir(self.BrowseSysDirListView.selectedItmFname):return
        self.curdb.addSysDirBookmark(self.BrowseSysDirListView.selectedItmFname)

    def onDelsysBookmark(self):
        if not self.curdb.sysdirbm: return
        try:
            lst = QStringList()
            for bm in self.curdb.sysdirbm:
                lst.append(bm)
            fac = QInputDialog.getItem("imgSeek","Choose which bookmark you want to remove:" ,lst,0,0)
            if not fac[1]: return
            fac = str(fac[0])
            self.curdb.delSysDirBookmark(self.curdb.sysdirbm.index(fac))
        except:
            Error.PrintTB("Error removing bookmark")

    def recurseslidecheck_toggled(self,a0):
        self.env.options["view.recurseslide"] = str(a0)
        self.onConfigChange()

    def SearchImageIconView_clicked(self,a0):
        try:
            self.FullView2.showImg(self.curdb.img[a0.id][0],fid = a0.id)
        except:
            pass

    def transformimage_activated(self):
        if not self.TransformForm:
            try:
                import Image
                from imgSeekLib.TransformWnd import TransformWnd
            except:
                Error.PrintTB("Missing support module....")
                return
            self.TransformForm = TransformWnd(self,env = self.env)
        self.TransformForm.show()

    def onTransformImagesMenu(self):
        if not self.selectedIDs: return
        if not self.selectedIDs[0]["type"] in ("Img","File") : return
        if not self.TransformForm:
            try:
                import Image
                from imgSeekLib.TransformWnd import TransformWnd
            except:
                Error.PrintTB("Missing support module....")
                return
            self.TransformForm = TransformWnd(self,self.env,ifile = self.selectedIDs[0]["id"])
            self.TransformForm.show()
        else:
            self.TransformForm.showFile(self.selectedIDs[0]["id"])
            self.TransformForm.show()

    def previousSearchBtn_clicked(self):
        if self.lastSearch:
            if len(self.lastSearch) < 2:
                ls = self.lastSearch[-1]
            else:
                ls = self.lastSearch[-2]
            self.showQueryResults(ls[0],ls[1])
            if len(self.lastSearch) > 2:
                del self.lastSearch[0]

    def BrowseIconView_selectionChanged(self):
        self.selectedIDs = []
        it = self.BrowseIconView.firstItem()
        while it:
            if it.isSelected():
                nit = {}
                if hasattr(it,"id"):
                    nit["type"] = "Img"
                    nit["id"] = it.id
                    nit["item"] = it
                    # set from if img belogs to a group
                    try:
                        if self.BrowseIconView.shownIDName == self.curdb.groups[self.BrowseIconView.shownID][0][0]:
                            nit["FromId"] = self.BrowseIconView.shownID
                    except:
                        pass
                    self.selectedIDs.append(nit)
                if hasattr(it,"filename"):
                    nit["type"] = "File"
                    nit["id"] = it.filename
                    nit["item"] = it
                    self.selectedIDs.append(nit)
            it = it.nextItem()

    def BrowseDirListView_selectionChanged(self):
        self.selectedIDs = []
        it = self.BrowseDirListView.firstChild()
        while it:
            nit = {}
            if self.BrowseDirListView.isSelected(it):
                if it.isDir==2:         # image
                    nit["type"] = "Img"
                    nit["id"] = it.id
                    nit["item"] = it
                    self.selectedIDs.append(nit)
                if it.isDir==1:
                    nit["type"] = "Dir"
                    nit["id"] = it.dirid
                    nit["item"] = it
                    self.selectedIDs.append(nit)
                if it.isDir==0:
                    nit["type"] = "Volume"
                    nit["id"] = it.volid
                    nit["item"] = it
                    self.selectedIDs.append(nit)
            it = it.itemBelow()

    def BrowseCategListView_selectionChanged(self):
        self.selectedIDs = []
        it = self.BrowseCategListView.firstChild()
        while it:
            if self.BrowseCategListView.isSelected(it):
                nit = {}
                if not it.isGroup:         # image
                    nit["type"] = "Img"
                    nit["id"] = it.id
                    nit["item"] = it
                    nit["FromId"] = it.parent().groupid
                    self.selectedIDs.append(nit)
                if  it.isGroup:         # group
                    nit["type"] = "Group"
                    nit["id"] = it.groupid
                    nit["item"] = it
                    self.selectedIDs.append(nit)
            it = it.itemBelow()

    def SearchImageIconView_selectionChanged(self):
        self.selectedIDs = []
        it = self.SearchImageIconView.firstItem()
        while it:
            if it.isSelected():
                nit = {}
                nit["type"] = "Img"
                nit["id"] = it.id
                nit["item"] = it
                self.selectedIDs.append(nit)
            it = it.nextItem()

    def BrowseCategListView_dropped(self,a0,copymove = -1):
        """copymove==-1 means user haven't decided yet if it should copy or move. So show a popup and store a0 on a temp var so categlistview_dropped may be called from popup callback"""
        if int(self.env.options["browse.dragpopup"]):
            if copymove==-1:
                vp = self.BrowseCategListView.contentsToViewport(a0.pos())
                i = self.BrowseCategListView.itemAt( vp )
                self.browsecatega0 = i
                self.selrescateg = self.selectedIDs
                self.dragMenu.popup(self.BrowseCategListView.mapToGlobal(a0.pos()))
                return
            i = self.browsecatega0
            self.selectedIDs = self.selrescateg
        else:
            vp = self.BrowseCategListView.contentsToViewport(a0.pos())
            i = self.BrowseCategListView.itemAt( vp )

            if a0.action()==QDropEvent.Copy:
                copymove = 1
            else:
                copymove = 0
        fcn = None
        if copymove:
            fcn = self.curdb.copyObjectsToGroup
        else:
            fcn = self.curdb.moveObjectsToGroup
        if not hasattr(i,"groupid"):
            fcn(self.selectedIDs, -1)
        else:
            fcn(self.selectedIDs, i.groupid)

    def realtimecheck_toggled(self,a0):
        self.env.options["query.realtimesketch"] = str(a0)
        self.onConfigChange()

    def hideprogresscheck_toggled(self,a0):
        self.env.options["database.hideprogress"] = str(a0)
        if a0:
            self.progressGroup.hide()
        else:
            self.progressGroup.show()
        self.onConfigChange()

    def sketchRelease(self):
        """ called by painting widget everytime user release mouse"""
        if int(self.env.options["query.realtimesketch"]):
            self.SearchImageBtn_clicked()

    def ResetDBAction_activated(self):
        text = QInputDialog.getText("imgSeek","Are you sure you want to reset all data in this collection ? If you really want to remove all volumes,groups,metadata,images,etc, type \"remove\":" ,QLineEdit.Normal)
        if text[1]:
            text = str(text[0])
            if text == "remove":
                self.curdb.reset()
                self.curdb.changedDB({"scope":"Database","reason":"opened","subject":"Empty database"})
                self.info("Database is now empty.")
                return
        self.info("Nothing removed.")

    def BrowseDirListView_doubleClicked(self,a0):
        if not hasattr(a0,"id"): return
        self.selectedResult = a0
        self.onResultsMenuQuery()

    def BrowseDirListView_returnPressed(self,a0):
        self.BrowseDirListView_doubleClicked(a0)

    def stopAddBtn_clicked(self):
        if self.doingAdd: self.abortedAdd = 1

    def RebuildThAction_activated(self):
        res = QMessageBox.information( self, "imgSeek",self.str("This may take some time if you have a lot of images or your computer is slow."),   QString(self.str("&Regenerate cached thumbnails")), QString(self.str("Cancel")))
        if res: return
        self.updateStatusBar(self.tr("Regenerating thumbnails, please wait..."))
        self.curdb.regenerateThumbs()
        self.updateStatusBar(self.str("Ready."))

    def refreshIconView(self):
        """ call to make sure all displayed icons are indeed on db"""
        it = self.BrowseIconView.firstItem()
        while it:
            if (hasattr(it,"id") and not self.curdb.img.has_key(it.id)) or  (hasattr(it,"filename") and not os.path.exists(it.filename)):
                nit = it.nextItem()
                self.BrowseIconView.takeItem(it)
                del it
                it = nit
            else:
                it = it.nextItem()
        it = self.SearchImageIconView.firstItem()
        while it:
            if hasattr(it,"id") and not self.curdb.img.has_key(it.id):
                nit = it.nextItem()
                self.SearchImageIconView.takeItem(it)
                del it
                it = nit
            else:
                it = it.nextItem()

    def queryoptionsbtn_clicked(self):
        self.resultsViewMenu.popup(self.queryoptionsbtn.mapToGlobal(QPoint(16,16)))

    def MainTabWidget_currentChanged(self,a0):
        if self.MainTabWidget.currentPage()==self.optionspage:
            self.updateDatabaseInfoText()

    def savealwayscheck_toggled(self,a0):
        self.env.options["database.alwayssave"] = str(a0)
        self.onConfigChange()

    def onDragCopy(self):
        self.BrowseCategListView_dropped(0,copymove = 1)

    def onDragMove(self):
        self.BrowseCategListView_dropped(0,copymove = 0)

    def dropaskcheck_toggled(self,a0):
        self.env.options["browse.dragpopup"] = str(a0)
        self.onConfigChange()

    def symoptionsbtn_clicked(self):
        self.SymBrowseMenu.popup(self.symoptionsbtn.mapToGlobal(QPoint(16,16)))

    def browsesysoptionsbtn_clicked(self):
        self.sysdiroptMenu.popup(self.browsesysoptionsbtn.mapToGlobal(QPoint(16,16)))

    def addRecentDatabases(self,fname):
        """add a new entry to the Recent list. (10 max) """
        current = []
        for i in range(10):
            keyname = "database.history%.3d" % i
            if self.env.options.has_key(keyname): current.append(self.env.options[keyname])
        if fname in current: return     # return if file is already on Recent list
        current.insert(0,fname)
        if len(current)>10: current.pop()
        for i in range(len(current)):
            keyname = "database.history%.3d" % i
            self.env.options[keyname] = current[i]

    def loadRecentDatabases(self):
        """read from settings file recent opened databases, populating the submenu """
        recents = []
        for i in range(10):
            keyname = "database.history%.3d" % i
            if self.env.options.has_key(keyname): recents.append(self.env.options[keyname])
        if self.recentMenu:
            self.recentMenu.clear()
        else:
            self.recentMenu = QPopupMenu(self)
            self.fileMenu.insertItem("Open &recent databases",self.recentMenu,-1,2)
        for rc in recents:
            self.recentMenu.insertItem ( rc, self.onRecentMenuClick)

    def onRecentMenuClick(self,a):
        fname = str(self.recentMenu.text(a))
        self.fileOpen(fname)

    def populateMoreIcons(self,step = 20):
        """ add a few more icons to the iconview """
        if not len(self.hiddenIcons):
            return                      # nothing else to show
        cnt = 0
        ##TODO3: try implementing this time based update avoidance mechanism again later. The problem with this attempted implementation is that when scrolling with the mouse, the scrollbar will reach the bottom (while there are still thumbnails to be displayed), then an update will be avoided, and no further thumbnails are displayed. The user has to move the scrollbar up and then down again so more is shown.
##         if time.time() - self.lastMoreThumbTime < 0.1:
##             print 'avoided update'
##             return
##         else:
##             self.lastMoreThumbTime = time.time()
        self.thumbLabel.setText(self.thumbLabel.orig+" - %d not displayed ***[GENERATING THUMBNAILS]***"%len(self.hiddenIcons))
        self.app.processEvents()
        while len(self.hiddenIcons):
            a = self.hiddenIcons[0]       #TODO2: is this del thing fast ??? -- investigate mem leaks (dangling obj refs) here and on other places
            del self.hiddenIcons[0]
            if a[2][0] == "id":
                aImage = self.curdb.getThumbDB(a[2][1])
            else:
                aImage = self.curdb.getThumb(a[1])
            if not aImage: continue
            qit = QIconViewItem( self.BrowseIconView, a[0], aImage)
            setattr(qit,a[2][0],a[2][1]) # set image id attribute
            cnt = cnt+1
            if cnt>step:break
        if len(self.hiddenIcons):
            self.thumbLabel.setText(self.thumbLabel.orig+" - %d not displayed"%len(self.hiddenIcons))
        else:
           self.thumbLabel.setText(self.thumbLabel.orig) # make sure the original caption is back when there's nothing else hidden

    def populateMoreSearchIcons(self,step = 20):
        """ add a few more icons to the iconview """
        if not len(self.SearchImageIconView.hiddenIcons):
            return                      # nothing else to show
        cnt = 0
        while len(self.SearchImageIconView.hiddenIcons):
            a = self.SearchImageIconView.hiddenIcons[0]       #TODO2: is this del thing fast ??? -- investigate mem leaks (dangling obj refs) here and on other places
            del self.SearchImageIconView.hiddenIcons[0]
            if a[2][0] == "id":         # image on db
                aImage = self.curdb.getThumbDB(a[2][1])
            else:
                aImage = self.curdb.getThumb(a[1])
            if not aImage: continue
            qit = QIconViewItem(self.SearchImageIconView, a[0], aImage)
            setattr(qit,a[2][0],a[2][1]) # set image id attribute
            cnt = cnt+1
            if cnt>step:
                break

    def BrowseIconView_contentsMoving(self,a0,a1):
        if a1 > self.BrowseIconView.contentsHeight() -2*self.BrowseIconView.height():
            self.populateMoreIcons()

    def groupByCombo_activated(self,a0):
        self.curdb.simgroups = {}
        if str(a0) == "Color (Fast)":
            self.curdb.simgroups = self.curdb.colorSimGroups
        if str(a0) == "Content (Slow/Accurate)":
            self.curdb.simgroups = self.curdb.contSimGroups
        if str(a0) == "Date":
            self.curdb.simgroups = self.curdb.dateSimGroups
        if str(a0) == "Filename":
            self.curdb.simgroups = self.curdb.fileSimGroups
        self.updateCategoryView()

    def autoCreateGroupCheck_toggled(self,a0):
        self.GroupCombo.setEnabled(not a0)


    def dontShowTheseListView_dropped(self,a0):
        """ dropped event comes from AvailableGroupListView """
        it = self.AvailableGroupsListView.firstChild()
        while it:
            if it.isSelected():
                if hasattr(it,"groupid"):
                    if not it.groupid in self.dontshowtheselist:
                        lvi = QListViewItem(self.dontShowTheseListView,self.curdb.groups[it.groupid][0],str(len(self.curdb.groups[it.groupid][3]))+" file(s) / "+str(len(self.curdb.groups[it.groupid][4]))+" group(s)")
                        lvi.groupid = it.groupid
                        lvi.isGroup = 0
                        lvi.setDropEnabled(0)
                        self.dontshowtheselist.append(it.groupid)
            it = it.itemBelow()
        self.showThese_updated()

    def showTheseListView_dropped(self,a0):
        """ dropped event comes from AvailableGroupListView """
        it = self.AvailableGroupsListView.firstChild()
        while it:
            if it.isSelected():
                if hasattr(it,"groupid"):
                    if not it.groupid in self.showtheselist:
                        lvi = QListViewItem(self.showTheseListView,self.curdb.groups[it.groupid][0],str(len(self.curdb.groups[it.groupid][3]))+" file(s) / "+str(len(self.curdb.groups[it.groupid][4]))+" group(s)")
                        lvi.groupid = it.groupid
                        lvi.isGroup = 0
                        lvi.setDropEnabled(0)
                        self.showtheselist.append(it.groupid)
            it = it.itemBelow()
        self.showThese_updated()

    def dontShowTheseListView_doubleClicked(self,a0):
        self.dontshowtheselist.remove(a0.groupid);
        self.dontShowTheseListView.takeItem(a0)
        del a0;
        self.showThese_updated()

    def showTheseListView_doubleClicked(self,a0):
        self.showtheselist.remove(a0.groupid);
        self.showTheseListView.takeItem(a0)
        del a0;
        self.showThese_updated()

#    def update_images(self):
#        """ adds the group information to images """
#        def add_gid_to_childgroups_images(gid, loopgid):
#            for id in self.curdb.groups[loopgid][3]:
#                if not gid in self.curdb.img[id][2]:
#                    self.curdb.img[id][2].append(gid)
#            for group in self.curdb.groups[loopgid][4]:
#                add_gid_to_childgroups_images(gid, group)
#
#        for gid in self.curdb.groups.keys():
#            add_gid_to_childgroups_images(gid,gid)
##            for id in group[3]:
##                if not gid in self.curdb.img[id][2]:
##                    self.curdb.img[id][2].append(gid)
##            for gid2 in group[4]:
##                for id in self.curdb.groups[gid2][3]:
##                    if not gid in self.curdb.img[id][2]:
##                        self.curdb.img[id][2].append(gid) #should be recursive, TODO4
#        self.images_updated = 1 #quick hack, TODO4

#    def reset_image_groups(self):
#        """ resets group information in curdb.img """
#        for id in self.curdb.img.keys():
#            self.curdb.img[id][2] = []
#        self.update_images()

    def andNoOtherCheckBox_stateChanged(self,a0):
#       self.reset_image_groups()
       self.showThese_updated()

    def groupLogicCombo_activated(self, a0):
       self.showThese_updated()

    def belongsto(self,id):
        for i in self.curdb.img[id][2]:
            print "    " + self.curdb.groups[i][0]

    def getAcceptedIdx(self):
    #TODO2: test more
    #somewhere there can be still some problems (bugs)... try following:
    # create folders 1 and 2 and a child 3 to folder 2. Then drop the same file to 1 and 3.
    # it should now be seen if you select by groups 1 AND 2 ( I think I remember it didn't).
        """ Helper which collects accepted files into a file list (by group-tab)"""
        def parents(gid):
            gidlist = []
            while self.curdb.groups[gid][2] != -1:
                gidlist.append(gid)
                gid = self.curdb.groups[gid][2]
            #print "gidlist: ", gidlist
            return gidlist
        def childgroups(gid):
            gidlist = []
            for gid2 in self.curdb.groups[gid][4]:
                gidlist.append(gid2)
                gidlist = gidlist + childgroups(gid2)
            return gidlist
        def intersection(list1, list2):
            resultlist = []
            for i in list1[:]:
                if i in list2:
                    resultlist.append(i)
            #print "intersection of ", list1, list2, " is ", resultlist
            return resultlist

        accepted = [] #list of idx
        #print "and inters."
        if str(self.groupLogicCombo.currentText()) == "AND": #must belong to all groups or their parents
            add = 0
            for idx, image in self.curdb.img.items():
                for reqid in self.showtheselist:
                    if reqid in image[2]:
                        add = 1
                    elif len(intersection(parents(reqid), image[2])) > 0:
                        add = 1
                    else:
                        add = 0
                        break;
                if add:
                    if not idx in accepted:
                        accepted.append(idx)
        else:
            for idx, image in self.curdb.img.items():
                for reqid in self.showtheselist:
                    if reqid in image[2]:
                        if not idx in accepted:
                            accepted.append(idx);
                        break

        if self.andNoOtherCheckBox.isChecked():
            for idx in accepted[:]: # may belong to child groups, though
                for group in self.curdb.img[idx][2]:
                    if not group in self.showtheselist:
                        accepted.remove(idx)
                        break
        # go through 'do not show these'-list (may not belong to their child groups either)
        #print "remove inters."
        for idx in accepted[:]:
            for group in self.curdb.img[idx][2]:
                if group in self.dontshowtheselist:
                    accepted.remove(idx)
                    break
                else:
                    removed = 0
                    if len(intersection(childgroups(group), self.dontshowtheselist)) > 0:
                        accepted.remove(idx)
                        break
        return accepted

    def showThese_updated(self):
        """ Call this when IconListView must be updated (by group-tab) """

#        if not self.images_updated:
#            self.update_images()

        accepted = self.getAcceptedIdx()

        self.SearchImageIconView.clear()
        self.SearchImageIconView.displayedFiles = []
        #self.thumbLabel.orig = "By group selection , %d images"%len(accepted)
        #self.thumbLabel.setText("By group selection, %d images"%len(accepted))
        #self.BrowseIconView.shownID = -1
        #self.BrowseIconView.shownIDName = ""
        self.statusBar().message("Generating thumbnails...")
        self.SearchImageIconView.hiddenIcons = []
        for idx in accepted:
            respair = self.curdb.img[idx][0]
            self.SearchImageIconView.displayedFiles.append(respair)
            fname = rfind(respair,os.sep)
            if fname==-1:
                fname = respair
            else:
                fname = respair[fname+1:]
            self.SearchImageIconView.hiddenIcons.append([fname,respair,["id",idx]])
        self.populateMoreSearchIcons(80)
        self.statusBar().message("Ready.")

    def promptForBatch(self):
        """ prompt user for select a batch. Returns batch id """
        lst = QStringList()
        for bm in self.curdb.batches:
            lst.append(self.curdb.batches[bm][0])
        fac = QInputDialog.getItem("imgSeek","Choose which batch you want to export:" ,lst,0,0)
        if not fac[1]: return None
        fac = str(fac[0])
        # got string, now find out which batch id this name belongs to :(
        for bm in self.curdb.batches:
            if self.curdb.batches[bm][0] == fac:
                return bm
        return None

    def randomSearchBtn_clicked(self):
        self.onResultsMenuRandomQuery()

    def seeAsGqviewCollection_activated(self):
        bid = self.promptForBatch()
        if not bid: return
        ids = []
        self.curdb.crawlBatchForImg(bid,ids,dumpids = 0) # return list of img fullpaths inside the selected batch

        f = open('gqview_collection.gqv', 'w') # write on current dir
        f.write("#generated by imgSeek\n")
        for i in ids:                   # i should be a string. If it's not, then there's an error on crawlBatchForImg
            try:
                f.write(i +'\n')
            except:
                Error.PrintTB("should've been a string")
                print i
        f.close()

        os.spawnlp(os.P_NOWAIT, "gqview","gqview","gqview_collection.gqv")

    def showgrouprecursivecheck_toggled(self,a0):
        self.env.options["browse.showgrouprecursive"] = str(a0)
        self.onConfigChange()

    def SearchImportcombo_activated(self,a0):
        filename = str(a0)
        self.queryfname = str(filename)
        self.tempQueryImage = self.curdb.openImage(self.queryfname)
        if not self.tempQueryImage:
            self.tempQueryImage = None
            self.msgerror("Error loading query image provided.")
            return
        self.tempQueryImage = self.tempQueryImage.smoothScale(128,128)
        aPixmap = QPixmap()
        aPixmap.convertFromImage(self.tempQueryImage)
        self.SearchImagePixmap.setPixmap(aPixmap)

        maxres = self.SearchFromImageResultsSpin.value()
        source = "image"
        queryImage = 1
        results = self.startQuery(source,maxres,nqueryImage=queryImage)
        self.showQueryResults(source,results)

    def agressivecheck_toggled(self,a0):
        self.env.options["database.agressive"] = str(a0)
        self.onConfigChange()
        if int(self.env.options["database.agressive"]):
            self.curdb.agressive = 1
        else:
            self.curdb.agressive = 0

#################################################### MAIN
try:
    sys.excepthook = Error.ExcptHandler # set our global error handling function
except:
    print "Error setting exception handler hook."
a = QApplication(sys.argv)
w = DlgMain(a)                      # create main window
a.connect(a,SIGNAL("lastWindowClosed()"),w.onExitActions)
a.setMainWidget(w)
w.show()
a.exec_loop()
