#include <gtk/gtk.h>
#include "gstamp.h"

#include "../pixmaps/file.xpm"
#include "../pixmaps/stamp_not_working.xpm"
#include "../pixmaps/stamp_working.xpm"
#include "../pixmaps/transfer_not_working.xpm"
#include "../pixmaps/transfer_working.xpm"

/* 
   this makes the whole ui. 
   It's as clean as it can get. :) 
*/

void make_menubar(UI_Struct *ui){
  
  GtkWidget *menu_bar;
  GtkWidget *menu;
  GtkWidget *menu_item;  

  menu_bar = gtk_menu_bar_new();
  gtk_box_pack_start(GTK_BOX(ui->Vbox), menu_bar, FALSE, FALSE, 0);
  gtk_widget_show( menu_bar );
  
  menu = gtk_menu_new(); /* File menu */
  menu_item = gtk_menu_item_new_with_label("File");
  gtk_widget_show(menu_item);
  gtk_menu_item_set_submenu( GTK_MENU_ITEM(menu_item), menu );
  gtk_menu_bar_append( GTK_MENU_BAR (menu_bar), menu_item );

  menu_item = gtk_menu_item_new_with_label("Open RC"); /* add the open choice to the menu */
  gtk_signal_connect ( GTK_OBJECT(menu_item), "activate",
		       GTK_SIGNAL_FUNC(main_load_callback), ui);
  gtk_menu_append( GTK_MENU(menu), menu_item); /* add the item to the menu */
  gtk_widget_show( menu_item );

  menu_item = gtk_menu_item_new_with_label("Save RC"); /* add the open choice to the menu */
  gtk_signal_connect ( GTK_OBJECT(menu_item), "activate",
		       GTK_SIGNAL_FUNC(update_callback), ui);
  gtk_menu_append( GTK_MENU(menu), menu_item); /* add the item to the menu */
  gtk_widget_show( menu_item );

  menu_item = gtk_menu_item_new_with_label("Save RC As"); /* add the open choice to the menu */
  gtk_signal_connect ( GTK_OBJECT(menu_item), "activate",
		       GTK_SIGNAL_FUNC(main_save_callback), ui);
  gtk_menu_append( GTK_MENU(menu), menu_item); /* add the item to the menu */
  gtk_widget_show( menu_item );

  menu_item = gtk_menu_item_new();
  gtk_menu_append(GTK_MENU(menu), menu_item);
  gtk_widget_show(menu_item);

  menu_item = gtk_menu_item_new_with_label("Exit"); /* add the open choice to the menu */
  gtk_signal_connect ( GTK_OBJECT(menu_item), "activate",
		       GTK_SIGNAL_FUNC(main_delete_event), NULL);
  gtk_menu_append( GTK_MENU(menu), menu_item); /* add the item to the menu */
  gtk_widget_show( menu_item );
  
  /* - Image Menu - */
  menu = gtk_menu_new(); /* Image menu */
  menu_item = gtk_menu_item_new_with_label("Image");
  gtk_widget_show(menu_item);
  gtk_menu_item_set_submenu( GTK_MENU_ITEM(menu_item), menu );
  gtk_menu_bar_append( GTK_MENU_BAR (menu_bar), menu_item );

  menu_item = gtk_menu_item_new_with_label("Preview Image"); /* add the open choice to the menu */
  gtk_signal_connect ( GTK_OBJECT(menu_item), "activate",
		       GTK_SIGNAL_FUNC(preview_callback), ui);
  gtk_menu_append( GTK_MENU(menu), menu_item); /* add the item to the menu */
  gtk_widget_show( menu_item );

  menu_item = gtk_menu_item_new();
  gtk_menu_append(GTK_MENU(menu), menu_item);
  gtk_widget_show(menu_item);

  menu_item = gtk_menu_item_new_with_label("Stamp Image"); /* add the open choice to the menu */
  gtk_signal_connect ( GTK_OBJECT(menu_item), "activate",
		       GTK_SIGNAL_FUNC(stamp_callback), ui);
  gtk_menu_append( GTK_MENU(menu), menu_item); /* add the item to the menu */
  gtk_widget_show( menu_item );

  menu_item = gtk_menu_item_new_with_label("Stamp and Send Image"); /* add the open choice to the menu */
  gtk_signal_connect ( GTK_OBJECT(menu_item), "activate",
		       GTK_SIGNAL_FUNC(stamp_send_callback), ui);
  gtk_menu_append( GTK_MENU(menu), menu_item); /* add the item to the menu */
  gtk_widget_show( menu_item );


  /* - Help Menu - */
  menu = gtk_menu_new(); /* Image menu */
  menu_item = gtk_menu_item_new_with_label("Help");
  gtk_menu_item_right_justify(GTK_MENU_ITEM(menu_item));
  gtk_widget_show(menu_item);
  gtk_menu_item_set_submenu( GTK_MENU_ITEM(menu_item), menu );
  gtk_menu_bar_append( GTK_MENU_BAR (menu_bar), menu_item );
  
  menu_item = gtk_menu_item_new_with_label("About"); /* add the open choice to the menu */
  gtk_signal_connect ( GTK_OBJECT(menu_item), "activate",
		       GTK_SIGNAL_FUNC(help_about_callback), ui);
  gtk_menu_append( GTK_MENU(menu), menu_item); /* add the item to the menu */
  gtk_widget_show( menu_item );
}

void make_main_buttons(UI_Struct *ui){

  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *hbox; 

  hbox = gtk_hbox_new(FALSE, 5);
  gtk_box_pack_start(GTK_BOX(ui->Vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show(hbox);
  
  /* create "Preview" button */
  button = gtk_button_new_with_label ("Update RC");
  gtk_widget_set_usize( button, 80,0 );  
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (update_callback), ui);
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, FALSE, 5);
  gtk_widget_show (button);

  /* create "Preview" button */
  button = gtk_button_new_with_label ("Preview");
  gtk_widget_set_usize( button, 80,0 );  
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (preview_callback), ui);
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, FALSE, 5);
  gtk_widget_show (button);

  /* create "Stamp" button */
  button = gtk_button_new_with_label ("Stamp");
  gtk_widget_set_usize( button, 80,0 );  
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (stamp_callback), ui);
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, FALSE, 5);
  gtk_widget_show (button);

  /* create "Stamp/Send" button */
  button = gtk_button_new_with_label ("Stamp/Send");
  gtk_widget_set_usize( button, 80,0 );  
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (stamp_send_callback), ui);
  gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, FALSE, 5);
  gtk_widget_show (button);

  /* create "Quit" button */
  button = gtk_button_new_with_label ("Quit");
  gtk_widget_set_usize( button, 80,0 );  
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (main_delete_event), NULL);
  gtk_box_pack_end(GTK_BOX(hbox), button, TRUE, FALSE, 5);
  gtk_widget_show (button);

}

void make_main_icons(UI_Struct *ui){

  GtkWidget *frame;
  GtkWidget *hbox1; 
  GtkWidget *pixmapwid; 
  GtkWidget *label; 
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GtkStyle *style;

  /* ---------------------- begin Main icons -----------------------*/

  frame = gtk_frame_new(NULL);
  gtk_widget_show(frame);
  gtk_box_pack_start(GTK_BOX(ui->Vbox), frame, FALSE, FALSE, 5);

  hbox1 = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox1);
  gtk_container_add (GTK_CONTAINER (frame), hbox1);
  style = gtk_widget_get_style( frame );
  
  /* make the stamping image */
  ui->yes_stamp = gdk_pixmap_create_from_xpm_d(ui->window->window, &mask,
					       &style->bg[GTK_STATE_NORMAL],
					       (gchar **)stamp_working_xpm);
  
  ui->yes_stamp_mask = mask;
  /* make the nonstamping image and display it. */
  pixmap = gdk_pixmap_create_from_xpm_d(ui->window->window, &mask,
					&style->bg[GTK_STATE_NORMAL],
					(gchar **)stamp_not_working_xpm);
  ui->no_stamp_mask = mask;
  ui->no_stamp = pixmap;
  
  pixmapwid = gtk_pixmap_new( pixmap, mask );
  gtk_widget_show( pixmapwid );

  ui->stamp_pix = pixmapwid;

  gtk_box_pack_end(GTK_BOX(hbox1), pixmapwid, FALSE, FALSE, 2);

  /* make the transfer image */
  ui->yes_transfer = gdk_pixmap_create_from_xpm_d(ui->window->window, &mask,
						  &style->bg[GTK_STATE_NORMAL],
						  (gchar **)transfer_working_xpm);
  
  ui->yes_transfer_mask = mask;
  /* make the nontransfer image and display it. */
  pixmap = gdk_pixmap_create_from_xpm_d(ui->window->window, &mask,
					&style->bg[GTK_STATE_NORMAL],
					(gchar **)transfer_not_working_xpm);
  ui->no_transfer_mask = mask;
  ui->no_transfer = pixmap;

  pixmapwid = gtk_pixmap_new( pixmap, mask );
  ui->transfer_pix = pixmapwid;

  gtk_widget_show( pixmapwid );
  gtk_box_pack_end(GTK_BOX(hbox1), pixmapwid, FALSE, FALSE, 2);

  label = gtk_label_new("GTK Stamp! - ");
  gtk_box_pack_start(GTK_BOX(hbox1), label, FALSE, FALSE, 2);
  gtk_widget_show(label);
  
  ui->Status = gtk_label_new("Idle");
  gtk_box_pack_start(GTK_BOX(hbox1), ui->Status, FALSE, FALSE, 2);
  gtk_widget_show(ui->Status);

  /* ---------------------- end Main icons -----------------------*/

}

void make_file_page(UI_Struct *ui){

  GtkWidget *label;
  GtkWidget *vbox;
  GtkWidget *button;
  GtkWidget *hbox1; 
  GtkWidget *hbox2; 
  GtkWidget *hbox3; 
  GtkWidget *hbox4; 
  GtkWidget *hbox5; 
  GtkWidget *pixmapwid; 
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GtkStyle *style;
  GtkWidget *adjustment;
  
  
  label = gtk_label_new ("Files");
  vbox = gtk_vbox_new(FALSE, 0);
  gtk_notebook_append_page( GTK_NOTEBOOK(ui->notebook),vbox,label );
  gtk_widget_show(vbox);
  
  hbox1 = gtk_hbox_new(FALSE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox1, TRUE, TRUE, 5);
  gtk_widget_show(hbox1);
 
  hbox2 = gtk_hbox_new(FALSE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox2, TRUE, TRUE, 5);
  gtk_widget_show(hbox2);

  hbox3 = gtk_hbox_new(FALSE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox3, TRUE, TRUE, 5);
  gtk_widget_show(hbox3);

  hbox4 = gtk_hbox_new(FALSE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox4, TRUE, TRUE, 5);
  gtk_widget_show(hbox4);

  hbox5 = gtk_hbox_new(FALSE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox5, TRUE, TRUE, 5);
  gtk_widget_show(hbox5);

  ui->Infile = gtk_entry_new();
  label = gtk_label_new ("Input JPEG");
  gtk_widget_set_usize( label, 80,0 );  
  GTK_LABEL(label)->jtype = GTK_JUSTIFY_LEFT;
  gtk_box_pack_start(GTK_BOX(hbox2), label, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(hbox2), ui->Infile, TRUE, TRUE, 5);
  gtk_widget_show(label);
  gtk_widget_show(ui->Infile);

  button = gtk_button_new();

  gtk_widget_set_usize( button, 0, 0);  
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (input_file_browse_callback), ui);
  gtk_box_pack_start(GTK_BOX(hbox2), button, FALSE, FALSE, 5);
  style = gtk_widget_get_style( button );
  
  pixmap = gdk_pixmap_create_from_xpm_d(ui->window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL],
					 (gchar **)filexpm );
  pixmapwid = gtk_pixmap_new( pixmap, mask );
  gtk_widget_show( pixmapwid );
  gtk_container_add( GTK_CONTAINER(button), pixmapwid );
  gtk_widget_show (button);
  

  ui->Outfile = gtk_entry_new();
  label = gtk_label_new ("Output JPEG");
  gtk_widget_set_usize( label, 80,0 );  
  GTK_LABEL(label)->jtype = GTK_JUSTIFY_LEFT;
  gtk_box_pack_start(GTK_BOX(hbox3), label, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(hbox3), ui->Outfile, TRUE, TRUE, 5);
  gtk_widget_show(label);
  gtk_widget_show(ui->Outfile);

  style = gtk_widget_get_style( ui->window );
  pixmap = gdk_pixmap_create_from_xpm_d(ui->window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL],
					 (gchar **)filexpm );

  pixmapwid = gtk_pixmap_new( pixmap, mask );
  gtk_widget_show( pixmapwid );

  button = gtk_button_new();
  gtk_container_add( GTK_CONTAINER(button), pixmapwid );
  
  gtk_widget_set_usize( button, 0,0 );  
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (output_file_browse_callback), ui);
  gtk_box_pack_end(GTK_BOX(hbox3), button, FALSE, FALSE, 5);
  gtk_widget_show (button);

  /* now the quality settings */
  label = gtk_label_new ("JPEG Quality") ;
  gtk_widget_set_usize( label, 80,0 );  
  GTK_LABEL(label)->jtype = GTK_JUSTIFY_LEFT;
  gtk_box_pack_start(GTK_BOX(hbox4), label, FALSE, FALSE, 10);
  gtk_widget_show (label);
  
  adjustment = (GtkWidget *) gtk_adjustment_new(0.0, 0.0, 101.0, 1.0, 1.0, 1.0);
  ui->Quality = gtk_hscale_new (GTK_ADJUSTMENT (adjustment));
  gtk_scale_set_digits (GTK_SCALE(ui->Quality), 0) ;
  gtk_range_set_update_policy (GTK_RANGE (ui->Quality), GTK_UPDATE_CONTINUOUS);
  gtk_widget_show (ui->Quality);
  gtk_box_pack_start(GTK_BOX(hbox4), ui->Quality, TRUE, TRUE, 5);
  
  /* preview file */
  ui->Previewfile = gtk_entry_new();
  label = gtk_label_new ("Preview JPEG");
  gtk_widget_set_usize( label, 80,0 );  
  GTK_LABEL(label)->jtype = GTK_JUSTIFY_LEFT;
  gtk_box_pack_start(GTK_BOX(hbox5), label, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(hbox5), ui->Previewfile, TRUE, TRUE, 5);
  gtk_widget_show(label);
  gtk_widget_show(ui->Previewfile);
  
  style = gtk_widget_get_style( ui->window );
  pixmap = gdk_pixmap_create_from_xpm_d(ui->window->window, &mask,
					&style->bg[GTK_STATE_NORMAL],
					(gchar **)filexpm );
  
  pixmapwid = gtk_pixmap_new( pixmap, mask );
  gtk_widget_show( pixmapwid );

  button = gtk_button_new();
  gtk_container_add( GTK_CONTAINER(button), pixmapwid );
  
  gtk_widget_set_usize( button, 0,0 );  
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (preview_file_browse_callback), ui);
  gtk_box_pack_end(GTK_BOX(hbox5), button, FALSE, FALSE, 5);
  gtk_widget_show (button);


  /* ---------------------- End Files Frame -----------------------*/  
}

void make_strings_page(UI_Struct *ui){
  
  GtkWidget *label;
  GtkWidget *vbox;
  GtkWidget *button;
  GtkWidget *hbox1; 
  GtkWidget *hbox2; 
  GtkWidget *hbox3; 
  GtkWidget *hbox4; 
  GtkWidget *hbox5; 
  GtkWidget *pixmapwid; 
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GtkStyle *style;
  
  label = gtk_label_new ("Strings");
  vbox = gtk_vbox_new(TRUE, 0);
  gtk_notebook_append_page( GTK_NOTEBOOK(ui->notebook),vbox,label );
  gtk_widget_show(vbox);
  
  hbox1 = gtk_hbox_new(FALSE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox1, TRUE, TRUE, 5);
  gtk_widget_show(hbox1);
  
  hbox2 = gtk_hbox_new(FALSE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox2, TRUE, TRUE, 5);
  gtk_widget_show(hbox2);

  hbox3 = gtk_hbox_new(FALSE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox3, TRUE, TRUE, 5);
  gtk_widget_show(hbox3);
  
  hbox4 = gtk_hbox_new(FALSE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox4, TRUE, TRUE, 5);
  gtk_widget_show(hbox4);
  
  hbox5 = gtk_hbox_new(FALSE, 10);
  gtk_box_pack_start(GTK_BOX(vbox), hbox5, TRUE, TRUE, 5);
  gtk_widget_show(hbox5);
  
  ui->UpperString = gtk_entry_new();
  label = gtk_label_new ("Upper String");
  gtk_widget_set_usize( label, 80,0 );  
  GTK_LABEL(label)->jtype = GTK_JUSTIFY_LEFT;
  gtk_box_pack_start(GTK_BOX(hbox1), label, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(hbox1), ui->UpperString, TRUE, TRUE, 5);
  gtk_widget_show(label);
  gtk_widget_show(ui->UpperString);
  
  ui->UStringExec = gtk_check_button_new_with_label ("Execute");
  gtk_box_pack_end(GTK_BOX(hbox1), ui->UStringExec, FALSE, FALSE, 0);
  gtk_widget_show(ui->UStringExec);

  /* begin upper font */
  ui->UpperFont = gtk_entry_new();
  label = gtk_label_new ("Upper Font");
  gtk_widget_set_usize( label, 80,0 );  
  GTK_LABEL(label)->jtype = GTK_JUSTIFY_LEFT;
  gtk_box_pack_start(GTK_BOX(hbox2), label, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(hbox2), ui->UpperFont, TRUE, TRUE, 5);
  gtk_widget_show(label);
  gtk_widget_show(ui->UpperFont);

  style = gtk_widget_get_style( ui->window );
  pixmap = gdk_pixmap_create_from_xpm_d(ui->window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL],
					 (gchar **)filexpm );

  pixmapwid = gtk_pixmap_new( pixmap, mask );
  gtk_widget_show( pixmapwid );

  button = gtk_button_new();
  gtk_container_add( GTK_CONTAINER(button), pixmapwid );

  gtk_widget_set_usize( button, 0,0 );  
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (upper_font_browse_callback), ui);
  gtk_box_pack_end(GTK_BOX(hbox2), button, FALSE, FALSE, 5);
  gtk_widget_show (button);
  /* end upper font */

  ui->LowerString = gtk_entry_new();
  label = gtk_label_new ("Lower String");
  gtk_widget_set_usize( label, 80,0 );  
  GTK_LABEL(label)->jtype = GTK_JUSTIFY_LEFT;
  gtk_box_pack_start(GTK_BOX(hbox3), label, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(hbox3), ui->LowerString, TRUE, TRUE, 5);
  gtk_widget_show(label);
  gtk_widget_show(ui->LowerString);

  
  ui->LStringExec = gtk_check_button_new_with_label ("Execute");
  gtk_box_pack_end(GTK_BOX(hbox3), ui->LStringExec, FALSE, FALSE, 0);
  gtk_widget_show(ui->LStringExec);

  /* begin lower font */
  ui->LowerFont = gtk_entry_new();
  label = gtk_label_new ("Lower Font");
  gtk_widget_set_usize( label, 80,0 );  
  GTK_LABEL(label)->jtype = GTK_JUSTIFY_LEFT;
  gtk_box_pack_start(GTK_BOX(hbox4), label, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(hbox4), ui->LowerFont, TRUE, TRUE, 5);
  gtk_widget_show(label);
  gtk_widget_show(ui->LowerFont);

  style = gtk_widget_get_style( ui->window );
  pixmap = gdk_pixmap_create_from_xpm_d(ui->window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL],
					 (gchar **)filexpm );

  pixmapwid = gtk_pixmap_new( pixmap, mask );
  gtk_widget_show( pixmapwid );

  button = gtk_button_new();
  gtk_container_add( GTK_CONTAINER(button), pixmapwid );
  
  gtk_widget_set_usize( button, 0,0 );  
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC (lower_font_browse_callback), ui);
  gtk_box_pack_end(GTK_BOX(hbox4), button, FALSE, FALSE, 5);
  gtk_widget_show (button);
  /* end lower font */

  ui->Use3D = gtk_check_button_new_with_label ("Use 3D");
  gtk_box_pack_end(GTK_BOX(hbox5), GTK_WIDGET(ui->Use3D), FALSE, FALSE, 5);
  gtk_widget_show(ui->Use3D);
  
  ui->Rotate = gtk_check_button_new_with_label ("Sideways");
  gtk_box_pack_end(GTK_BOX(hbox5), ui->Rotate, FALSE, FALSE, 5);
  gtk_widget_show(ui->Rotate);

  /* ---------------------- End Strings Frame -----------------------*/  

}

void make_color_page(UI_Struct *ui) {

  GtkWidget *label;
  GtkWidget *vbox;
  GtkWidget *button;
  GtkWidget *hbox1; 
  GtkWidget *hbox2; 
  GtkWidget *hbox3; 
  GtkWidget *hbox4; 
  GtkWidget *adjustment; 

  label = gtk_label_new ("Color");
  
  vbox = gtk_vbox_new(FALSE, 5);
  gtk_notebook_append_page( GTK_NOTEBOOK(ui->notebook),vbox,label );
  gtk_widget_show(vbox);
  
  hbox1 = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox1, TRUE, FALSE, 0);
  gtk_widget_show(hbox1);

  hbox2 = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox2, TRUE, FALSE, 0);
  gtk_widget_show(hbox2);

  hbox3 = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox3, TRUE, FALSE, 0);
  gtk_widget_show(hbox3);
  
  hbox4 = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox4, TRUE, FALSE, 0);
  gtk_widget_show(hbox4);

  /* begin color button 1 */
  ui->ColorButton1 = gtk_button_new_with_label ("");
  gtk_widget_set_usize( ui->ColorButton1, 30,0 );  
  label = gtk_label_new ("Text Color");
  gtk_widget_set_usize( label, 80,0 );  
  GTK_LABEL(label)->jtype = GTK_JUSTIFY_LEFT;
  gtk_signal_connect (GTK_OBJECT (ui->ColorButton1), "clicked",
		      GTK_SIGNAL_FUNC (color_callback_1), ui);
  gtk_box_pack_start(GTK_BOX(hbox1), label, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(hbox1), ui->ColorButton1, TRUE, FALSE, 5);
  gtk_widget_show (label);
  gtk_widget_show (ui->ColorButton1);

  /* end color button 1 */
  
  /* begin color button 2 */
  ui->ColorButton2 = gtk_button_new_with_label ("");
  gtk_widget_set_usize( ui->ColorButton2, 30,0 );  
  label = gtk_label_new ("Shade Color");
  gtk_widget_set_usize( label, 80,0 );  
  GTK_LABEL(label)->jtype = GTK_JUSTIFY_LEFT;
  gtk_signal_connect (GTK_OBJECT (ui->ColorButton2), "clicked",
		      GTK_SIGNAL_FUNC (color_callback_2), ui);
  gtk_box_pack_start(GTK_BOX(hbox2), label, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(hbox2), ui->ColorButton2, TRUE, FALSE, 5);
  gtk_widget_show (label);
  gtk_widget_show (ui->ColorButton2);
  
  /* now the shaderate */
  label = gtk_label_new ("Shade Rate");
  gtk_widget_set_usize( label, 80,0 );  
  GTK_LABEL(label)->jtype = GTK_JUSTIFY_LEFT;
  gtk_box_pack_start(GTK_BOX(hbox3), label, FALSE, FALSE, 10);
  gtk_widget_show (label);
  
  adjustment = (GtkWidget *) gtk_adjustment_new(0.0, 0.0, 256.0, 1.0, 1.0, 1.0);

  ui->ShadeRate = gtk_hscale_new (GTK_ADJUSTMENT (adjustment));
  gtk_scale_set_digits (GTK_SCALE(ui->ShadeRate), 0) ;
  gtk_range_set_update_policy (GTK_RANGE (ui->ShadeRate), GTK_UPDATE_CONTINUOUS);
  gtk_widget_show (ui->ShadeRate);

  gtk_box_pack_start(GTK_BOX(hbox3), ui->ShadeRate, TRUE, TRUE, 5);
  
  ui->UseColors = gtk_check_button_new_with_label ("Color Shading");
  gtk_box_pack_end(GTK_BOX(hbox4), GTK_WIDGET(ui->UseColors), FALSE, FALSE, 5);
  gtk_widget_show(ui->UseColors);
  
  
  /* ---------------------- End color Frame -----------------------*/
}


void make_ftp_page(UI_Struct *ui){

  GtkWidget *label;
  GtkWidget *vbox;
  GtkWidget *button;
  GtkWidget *hbox1; 
  GtkWidget *hbox2; 
  GtkWidget *hbox3; 
  GtkWidget *hbox4; 
  GtkWidget *hbox5; 
  
  label = gtk_label_new ("FTP");
  
  vbox = gtk_vbox_new(TRUE, 0);
  gtk_notebook_append_page( GTK_NOTEBOOK(ui->notebook),vbox,label );
  gtk_widget_show(vbox);
  
  hbox1 = gtk_hbox_new(FALSE, 5);
  gtk_box_pack_start(GTK_BOX(vbox), hbox1, TRUE, TRUE, 5);
  gtk_widget_show(hbox1);
  
  hbox2 = gtk_hbox_new(FALSE, 5);
  gtk_box_pack_start(GTK_BOX(vbox), hbox2, TRUE, TRUE, 5);
  gtk_widget_show(hbox2);
  
  hbox3 = gtk_hbox_new(FALSE, 5);
  gtk_box_pack_start(GTK_BOX(vbox), hbox3, TRUE, TRUE, 5);
  gtk_widget_show(hbox3);
  
  hbox4 = gtk_hbox_new(FALSE, 5);
  gtk_box_pack_start(GTK_BOX(vbox), hbox4, TRUE, TRUE, 5);
  gtk_widget_show(hbox4);

  hbox5 = gtk_hbox_new(FALSE, 5);
  gtk_box_pack_start(GTK_BOX(vbox), hbox5, TRUE, TRUE, 5);
  gtk_widget_show(hbox5);
  
  
  ui->Host = gtk_entry_new();
  label = gtk_label_new ("Host");
  gtk_widget_set_usize( label, 80,0 );  
  GTK_LABEL(label)->jtype = GTK_JUSTIFY_LEFT;
  gtk_box_pack_start(GTK_BOX(hbox1), label, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(hbox1), ui->Host, TRUE, TRUE, 5);
  gtk_widget_show(label);
  gtk_widget_show(ui->Host);

  ui->Login = gtk_entry_new();
  gtk_widget_set_usize( ui->Login, 80,0 );  
  label = gtk_label_new ("Login");
  gtk_widget_set_usize( label, 80,0 );  
  GTK_LABEL(label)->jtype = GTK_JUSTIFY_LEFT;
  gtk_box_pack_start(GTK_BOX(hbox2), label, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(hbox2), ui->Login, TRUE, TRUE, 5);
  gtk_widget_show(label);
  gtk_widget_show(ui->Login);

  ui->Passwd = gtk_entry_new();
  gtk_entry_set_visibility(GTK_ENTRY(ui->Passwd),FALSE);
  gtk_widget_set_usize( ui->Passwd, 80,0 );  
  label = gtk_label_new ("Password");
  gtk_widget_set_usize( label, 0,0 );  
  GTK_LABEL(label)->jtype = GTK_JUSTIFY_LEFT;
  gtk_box_pack_start(GTK_BOX(hbox2), label, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(hbox2), ui->Passwd, TRUE, TRUE, 5);
  gtk_widget_show(label);
  gtk_widget_show(ui->Passwd);

  ui->Path = gtk_entry_new();
  label = gtk_label_new ("Path");
  gtk_widget_set_usize( label, 80,0 );  
  GTK_LABEL(label)->jtype = GTK_JUSTIFY_LEFT;
  gtk_box_pack_start(GTK_BOX(hbox3), label, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(hbox3), ui->Path, TRUE, TRUE, 5);
  gtk_widget_show(label);
  gtk_widget_show(ui->Path);

  ui->Upload = gtk_entry_new();
  label = gtk_label_new ("Upload File Name");
  gtk_widget_set_usize( label, 80,0 );  
  GTK_LABEL(label)->jtype = GTK_JUSTIFY_LEFT;
  gtk_box_pack_start(GTK_BOX(hbox4), label, FALSE, FALSE, 10);
  gtk_box_pack_start(GTK_BOX(hbox4), ui->Upload, TRUE, TRUE, 5);
  gtk_widget_show(label);
  gtk_widget_show(ui->Upload);

  label = gtk_label_new ("Remember to call stamp with the -f option to use these settings.");
  gtk_widget_set_usize( label, 0, 0);  
  GTK_LABEL(label)->jtype = GTK_JUSTIFY_LEFT;
  gtk_box_pack_start(GTK_BOX(hbox5), label, FALSE, FALSE, 10);
  gtk_widget_show(label);

}

void make_about_page(UI_Struct *ui){
  GtkWidget *label;
  GtkWidget *hbox;
  char tmpstring[1024];
  
  label = gtk_label_new ("About");
  hbox = gtk_hbox_new(TRUE, 1);
  gtk_notebook_append_page( GTK_NOTEBOOK(ui->notebook),hbox,label );
  sprintf(tmpstring, "GTK Stamp - Version %s\n",VERSION); 
  strcat(tmpstring,  "Copyright (C) 1999 Patrick Keane, Joshua Kirby, Eric Werner\nThis program comes with NO WARRANTY.  You may redistribute\ncopies of this program under the terms of the GNU General Public License.\nFor more information about these matters, see the file named COPYING.");
  label = gtk_label_new (tmpstring);
  GTK_LABEL(label)->jtype = GTK_JUSTIFY_LEFT;
  gtk_widget_show(label);
  gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 10);
  gtk_widget_show(hbox);
  
}

void make_tooltips (UI_Struct *ui){
  ui->tooltips = (GtkWidget *)gtk_tooltips_new();

  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->Infile,
			"This is the original JPEG image on which stamp will be executed.", NULL) ;

  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->Outfile,
			"This is the name of the file where stamp will place the freshly-stamped JPEG image.", NULL) ;

  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->Quality,
			"This is the quality setting for the resulting JPEG.", NULL) ;

  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->Previewfile,
			"This is the name of the file that will be used for the Preview.", NULL) ;

  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->UpperString,
			"The string to place along the top of the JPEG image.", NULL) ;

  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->UStringExec,
			"If this button is checked, the string will be executed as a command and the ouput of the command will be placed onto the image.",
			NULL);

  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->UpperFont,
			"This is the font which will be used on the upper string.", NULL) ;

  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->LowerString,
			"The string to place along the bottom of the JPEG image.", NULL) ;

  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->LStringExec,
			"If this button is checked, the string will be executed as a command and the ouput of the command will be placed onto the image.",
			NULL);
  
  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->LowerFont,
			"This is the font which will be used on the lower string.", NULL) ;
  
  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->Use3D,
			"When checked, text in the upper and lower strings will be given a 3 dimensional look.", NULL) ;

  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->Rotate, 
			"When checked, the upper string will be placed vertically along the right hand side of the image, and the lower string will be placed vertically along the left hand side of the image.  In other words, sideways.", NULL) ;
  
  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->ColorButton1,
			"Choose a text color.", NULL) ;
  
  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->ColorButton2,
			"Choose a shade color.", NULL) ;

  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->ShadeRate,
			"This specifies how many shades darker each successive line in the shade area becomes.  A value of 0 will eliminate the shading entirely.  Increasingly higher values will cause the shade area to become darker more quickly.", NULL) ;
  
  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->UseColors,
			"If this is specified, then the shade color will be used when shading the image.  Otherwise, the image will be shaded transparently.", NULL) ;
  
  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->Host,
			"This is the host where the resulting JPEG file will be sent.", NULL) ;

  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->Login,
			"This is the login name that will be used when connecting to the FTP host.", NULL) ;

  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->Passwd,
			"This is the password that will be used when connecting to the FTP host.  For security, your password will not be shown.", NULL) ;

  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->Path,
			"This is the path where the resulting file will be placed on the host.", NULL) ;

  gtk_tooltips_set_tip( GTK_TOOLTIPS(ui->tooltips), ui->Upload,
			"This is the name of the file as it will be uploaded.", NULL) ;


}

UI_Struct *make_ui (struct ArgStruct *arg) {

  char *titlestring ;
  UI_Struct *ui;
  GtkWidget *window;       /* Main Application Window */
  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *adjustment;
  GtkWidget *scroll;
  GtkWidget *tmp;
  GtkWidget *pixmapwid; 
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GtkStyle *style;
  
  


  /* Make our global ui structure, and zero it out just in case */
  ui = (UI_Struct *)g_malloc (sizeof(UI_Struct));
  bzero(ui, sizeof(UI_Struct));
  
  
  /* Misc Window setup. */

  /* make the main window */
  ui->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  
  /* make the title */
  titlestring = g_malloc(strlen("GTK Stamp! - ") + 
			 strlen(arg->RCFile)+ strlen(VERSION) + 5) ;
  ui->Titlebase = g_malloc(strlen("GTK Stamp! - ") + strlen(VERSION) + 5) ;
  strcpy(titlestring, "GTK Stamp! ") ;
  strcat(titlestring, VERSION) ; 
  strcat(titlestring, " - ") ; 
  strcpy(ui->Titlebase, titlestring);
  strcat(titlestring, arg->RCFile) ; 
  gtk_window_set_title(GTK_WINDOW (ui->window), titlestring) ;
  g_free(titlestring);

  /* main window delete signal */
  gtk_signal_connect (GTK_OBJECT (ui->window), "delete_event",
		      GTK_SIGNAL_FUNC (main_delete_event), NULL);
  gtk_container_border_width (GTK_CONTAINER (ui->window), 5);
  gtk_window_position (GTK_WINDOW(ui->window), GTK_WIN_POS_CENTER);
  gtk_widget_realize(ui->window);

  /* --- Begin The main vbox --- */
  ui->Vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add (GTK_CONTAINER (ui->window), ui->Vbox);
  gtk_widget_show (ui->Vbox);
  /* --- Begin The main vbox --- */
  
  
  make_menubar(ui);

  /* --- Initialize the Notebook --- */
  ui->notebook = gtk_notebook_new();
  gtk_box_pack_start(GTK_BOX(ui->Vbox), ui->notebook, TRUE, TRUE, 5);
  /* --- End Initialize the Notebook --- */

  make_main_buttons(ui);
  make_main_icons(ui);
  make_file_page(ui);
  make_strings_page(ui);
  make_color_page(ui); 
  make_ftp_page(ui);
  /* don't need this anymore since we have the Help menu.
     make_about_page(ui);
  */
  make_tooltips(ui);
  gtk_widget_show (ui->notebook);

  /* now make our helper dialogs */
  make_file_dialog(ui);
  make_yes_no_dialog(ui);
  make_colorsel_dialog(ui);
  make_preview_dialog(ui);
  make_message_dialog(ui);

  /* copy the stamp structure into the ui */
  args_to_ui(arg, ui);

  /* we're not currently stamping */
  ui->GSTMP_STAMPING = 0;

  /* show our window */
  gtk_widget_show (ui->window);

  return ui;  
}


