/***************************************************************************
                          animationctrl.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Sep 30 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "animationctrl.h"
#include "../basecontroller.h"

AnimationCtrl::AnimationCtrl(QWidget *parent, const char *name) : QDialog(parent,name)
{
	initDialog();
	sldrFrame->setTracking(true);
	sldrFrame->setRange(1, max_frame);
    connect(btnPlay, SIGNAL(clicked()), SLOT(play()));
    connect(btnStop, SIGNAL(clicked()), SLOT(stop()));
    connect(btnFirst, SIGNAL(clicked()), SLOT(first()));
    connect(btnLast, SIGNAL(clicked()), SLOT(last()));
    connect(btnSave, SIGNAL(clicked()), SLOT(saveKeyframe()));
    connect(btnDelete, SIGNAL(clicked()), SLOT(deleteKeyframe()));
    connect(sldrFrame, SIGNAL(sliderMoved(int)), SLOT(slide(int)));
    timer = BaseController::getInstance();
}

AnimationCtrl::~AnimationCtrl(){

}

void AnimationCtrl::slide(int index)
{
//	int index = sldrFrame->value();
	current_frame = index;
	lblCurrentFrame->setText(QString().setNum(current_frame));
	timer->load(current_frame);
}

void AnimationCtrl::play()
{
	int i = current_frame;
	for(current_frame=i; current_frame<250; current_frame++){
		sldrFrame->setValue(current_frame);
		lblCurrentFrame->setText(QString().setNum(current_frame));	
		timer->load(current_frame);	
	}
}
void AnimationCtrl::stop()
{
}
void AnimationCtrl::first()
{
	current_frame = 1;
	lblCurrentFrame->setText("1");
	sldrFrame->setValue(1);
	timer->load(current_frame);
}
void AnimationCtrl::last()
{
	current_frame = max_frame;
	lblCurrentFrame->setText(QString().setNum(max_frame));
	sldrFrame->setValue(max_frame);
	timer->load(current_frame);
}

void AnimationCtrl::saveKeyframe()
{
	int saved_frame = fldKeyNumber->text().toInt();
	current_frame = saved_frame;
	if (max_frame < saved_frame)
		max_frame = saved_frame;
	
	lblCurrentFrame->setText(QString().setNum(current_frame));	
   lblMaxFrame->setText(QString().setNum(max_frame));
   sldrFrame->setRange(1, max_frame);
   sldrFrame->setValue(current_frame);
   timer->save(current_frame);
}
void AnimationCtrl::deleteKeyframe()
{
}
	
	



