/***************************************************************************
                         vertex.h  -  description                              
                            -------------------                                         
   begin                : Sat Aug 14 1999                                           
   copyright            : (C) 1999 by Jon Anderson                         
   email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef CTRLPT_H
#define CTRLPT_H

//QT includes

//local includes
#include "vertex.h"

/** CtrlPts are a special case of vertices that are used in parametric curves and surfaces.
 * The only differences are that they have special logic to alert their parent when they are modified.
 * Also, they maintain a rotation that affects their derivative, and therefore, the curve
 *
 * @author Jonathan E. Anderson
 */

class CtrlPt : public Vertex
{
   public:
      CtrlPt( float x, float y, float z, Object *parent = 0 );
      CtrlPt( Object *parent = 0 );
      ~CtrlPt();


      int draw( int mode );

      void loadState();
      void saveState();


      /** rotate the vertex */
      void rotate( float amount, float x, float y, float z, float px, float py, float pz );
      void move( float x, float y, float z );
      void scale( float x, float y, float z, float ox = 0, float oy = 0, float oz = 0 );

      void setMapping( int x, int y ) {i = x; j = y;};

      int i, j;


   private:
      Vector4 tangent;



};

#endif



















