/***************************************************************************
                         idata.cpp  -  description
                            -------------------
   begin                : Tue Apr 24 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "idata.h"

IDataMap IData::m_registry;

IData::IData( string s )
{

   m_tag = s;
}

IData::~IData()
{
}

IData* IData::clone()
{
   return new IData( m_tag );
}

IData * IData::create( string tag )
{
   IDataMap::iterator it = m_registry.find( tag );

   IData *c;

   if ( it == m_registry.end() )
   {
      cerr << "Creating generic IData for unknown data type:" << tag << endl;
      c = new IData( tag );
   }

   else
   {
      cerr << "Found existing IData to clone:" << tag << endl;
      c = it->second;
   }

   return c -> clone();
}

int IData::registerData( IData *d )
{
   IDataMap::iterator it = m_registry.find( d -> getTag() );

   if ( it != m_registry.end() )
   {
      //already registered
      return -1;
   }

   cerr << "Registering IData:" << d->getTag() << endl;
   m_registry.insert( IDataEntry( d->getTag(), d ) );

   return m_registry.size();
}
