/***************************************************************************
                         light.h  -  description                              
                            -------------------                                         
   begin                : Sat Aug 14 1999                                           
   copyright            : (C) 1999 by Jon Anderson                         
   email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef LIGHT_H
#define LIGHT_H

//QT includes

//local includes
#include "entity.h"
#include "texturematerial.h"
#include <GL/glut.h>

/** Lights are used to illuminate the scene.  Each light is essentially a
 * specialized entity that contains specialized color sources..Other than that
 * this is just a convenience class
 * @author Jonathan E. Anderson
 */

class Light : public Entity
{
   public:
      Light( Vector4 &p, Entity *parent = 0 );
      Light( Entity *parent = 0 );
      virtual ~Light();


      void initLight();
      void refreshLight();

      virtual int draw( int d_options = 0 );

      static int _num;
      static GLenum lights[ 7 ];

      /**Returns the material describing this lights properties.
        */
      TextureMaterial * getTextureMaterial() { return m;};

      /**Sets the material describing this lights properties.
        */
      void setTextureMaterial( TextureMaterial *_m ) {m = _m;};

      static int TYPE;

   protected:
      GLenum light_id;

      TextureMaterial *m;

};

#endif













