/***************************************************************************
                         Poly.h  -  description
                            -------------------                                         
   begin                : Sat Aug 14 1999                                           
   copyright            : (C) 1999 by Jon Anderson                         
   email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef Poly_H
#define Poly_H

//QT includes
#include <GL/glu.h>

//local includes
#include "spline.h"

class Face;

class Vertex;

class Mesh;

class Line;


/** Polys are filled line loops.
 *
 * @author Jonathan E. Anderson
 */

class Poly : public Spline
{
   public:
      Poly( Entity *parent = 0 );
      Poly( Vector4 & );

      virtual ~Poly();

      virtual void copyFrom( Entity * );

      int draw( int d_options = 0 );

      void reverse();
      void breakSpline();
      void closeSpline();
      void triangulate();

      void drawPolyTris();

      void extend( Vector4 & );

      void setDrawable( bool b ) { drawable = b; };

      virtual Entity * sweep( Spline &s );
      virtual Entity * revolve( Spline &s, int degrees, int segments );


      Poly & operator=( Poly&rhs );
      Poly & operator=( Line &rhs );

      virtual Entity * clone();

      static int TYPE;

   public:
      static bool filled;

   private:
      vector<int> tris;
      Line * getProfile( Vector4 &, Vector4 &, Vector4 & );

      bool drawable;



};

#endif






















