/***************************************************************************
                         primitive.cpp  -  description
                            -------------------
   begin                : Fri Apr 20 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "primitive.h"

Primitive::~Primitive()
{
}


void Primitive::extend( Vector4 &pt )
{
   // create a new vertex;
   createVertex( pt );

   switch ( m_type )
   {
      case POINTS:
         break;
      case TRIANGLES:
         addTriangle();
         break;
      case QUADS:
         addQuad();
         break;
      case TRISTRIP:
         addTStrip();
         break;
      case QUADSTRIP:
         addQStrip();
         break;
      default:
         break;
   }

   return ;
}

void Primitive::terminate()
{

   /*
     //delete any loose hangin vertices.
     switch( m_type ) {
       case TRIANGLES:
         cleanupTriangle();
         break;
       case QUADS:
         cleanupQuad();
         break;
       case QUADSTRIP:
         cleanupQuadStrip();
         break;
       default:
         break;
     }
     */
}



void Primitive::addTriangle()
{
   int n = numVerts();

   if ( n < 3 )
      return ;

   if ( ( numVerts() % 3 ) == 0 )
   {
      //create a triangle from the last three verts
      createFace( n - 3, n - 2, n - 1 );
   }
}

void Primitive::addQuad()
{
   int n = numVerts();

   if ( n < 4 )
      return ;

   if ( ( numVerts() % 4 ) == 0 )
   {
      //create a triangle from the last three verts
      createFace( n - 4, n - 3, n - 2, n - 1 );
   }
}

void Primitive::addTStrip()
{
   int n = numVerts();

   if ( n < 3 )
      return ;

   if ( n == 3 )
   {
      addTriangle();
      return ;
   }

   if ( n % 2 == 0 )
      createFace( n - 2, n - 3, n - 1 );
   else
      createFace( n - 3, n - 2, n - 1 );

}


void Primitive::addQStrip()
{
   int n = numVerts();

   if ( n < 4 )
      return ;

   if ( n == 4 )
   {
      addQuad();
      return ;
   }

   if ( n % 2 == 0 )
   {
      int q = n / 2;

      if ( q % 2 == 1 )
         createFace( n - 1, n - 2, n - 3, n - 4 );
      else
         createFace( n - 2, n - 1, n - 4, n - 3 );
   }


}


void Primitive::cleanupTriangle()
{
   int n = numVerts();
   int dn = n % 3;

   if ( dn == 0 )
      return ;

   if ( dn > 0 )
      verts[ n - 1 ] -> detach( true );

   if ( dn > 1 )
      verts[ n - 2 ] -> detach( true );

   cleanSubObjects();

}

void Primitive::cleanupQuad()
{
   int n = numVerts();
   int dn = n % 3;

   if ( dn == 0 )
      return ;

   if ( dn > 0 )
      verts[ n - 1 ] -> detach( true );

   if ( dn > 1 )
      verts[ n - 2 ] -> detach( true );

   if ( dn > 2 )
      verts[ n - 3 ] -> detach( true );

   cleanSubObjects();
}

void Primitive::cleanupQuadStrip()
{
   int n = numVerts();
   int dn = n % 2;

   if ( dn == 0 )
      return ;

   if ( dn == 1 )
      verts[ n - 1 ] -> detach( true );

   cleanSubObjects();

}

