/***************************************************************************
                         tesselator.h  -  description
                            -------------------
   begin                : Sun Jan 2 2000
   copyright            : (C) 2000 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TESSELATOR_H
#define TESSELATOR_H


#include <GL/gl.h>
#include <GL/glu.h>
#include <vector>


#define POLY_CW 1
#define POLY_CCW 2

#include <Math/vector4.h>

/**The Tesselator class is used to tesselate polygons.
  *It takes a list of points in Vector form, and returns a list of ints, where
  *each int is an index into the original list.
  *Every three ints is considered a triangle.
  *@author Jon Anderson
  */

class Tesselator
{
   public:
      Tesselator() {};

      ~Tesselator();
      /** Tesselate the given vertex list into the given face list */
      vector<int> & tesselate( vector<Vector4> &v, int mode );

   protected:


   private:
      //  GLUtesselator *tobj;
      GLUtriangulatorObj *tobj;
};

#endif
