#include "pmeshdlg.h"

#include <qlabel.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qlistbox.h>
#include <qvalidator.h>

#include <Entities/mesh.h>

/*
 *  Constructs a PMeshDlg which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
PMeshDlg::PMeshDlg( QWidget* parent, const char* name, bool modal, WFlags fl )
      : IPMeshDlg( parent, name, modal, fl )
{
   QDoubleValidator * d = new QDoubleValidator( this );

   fldPX -> setValidator( d );
   fldPY -> setValidator( d );
   fldPZ -> setValidator( d );
   fldRX -> setValidator( d );
   fldRY -> setValidator( d );
   fldRZ -> setValidator( d );


}

/*
 *  Destroys the object and frees any allocated resources
 */
PMeshDlg::~PMeshDlg()
{
   // no need to delete child widgets, Qt does it all for us
}

/*
 * public slot
 */
void PMeshDlg::slotApply()
{
   accept();
}

/*
 * public slot
 */
void PMeshDlg::slotAccept()
{
   accept();
}

void PMeshDlg::setEnableAll( bool b )
{
   fldPX -> setEnabled( b );
   fldPY -> setEnabled( b );
   fldPZ -> setEnabled( b );
   fldRX -> setEnabled( b );
   fldRY -> setEnabled( b );
   fldRZ -> setEnabled( b );

   fldNotes -> setEnabled( b );
   fldName -> setEnabled( b );
   lstData -> setEnabled( b );

}

void PMeshDlg::setMesh( Mesh * m )
{
   assert( m );
   Vector4 v = m -> getPosition();
   //set up the position.
   QString s;
   s.setNum( v.x );
   fldPX -> setText( s );
   s.setNum( v.y );
   fldPY -> setText( s );
   s.setNum( v.z );
   fldPZ -> setText( s );

   //set up the orientation.
   v = m -> getOrientation() . getEuler();
   s.setNum( v.x );
   fldRX -> setText( s );
   s.setNum( v.y );
   fldRY -> setText( s );
   s.setNum( v.z );
   fldRZ -> setText( s );

   //set up the name and notes.
   fldName -> setText( m -> getName() . c_str() );
   fldNotes -> setText( m -> getNotes() . c_str() );

   //set up the faces and vertices.
   s.setNum( m -> numFaces() );
   lblFaces -> setText( s );
   s.setNum( m -> numVerts() );
   lblVertices -> setText( s );

   //list all the  data attached to the mesh.
   IDataMap *data = m -> getAllData();
   lstData -> clear();

   IDataMap::iterator it = data -> begin();

   while ( it != data -> end() )
   {
      IData * d = static_cast<IData *>( it -> second );
      lstData -> insertItem( d -> getTag() . c_str() );
      ++it;
   }


}

string PMeshDlg::getName()
{
   return fldName -> text() . ascii();
}

string PMeshDlg::getNotes()
{
   return fldNotes -> text() . ascii();
}

Vector4 PMeshDlg::getPosition()
{
   Vector4 v;

   v.x = atof( fldPX -> text() . ascii() );
   v.y = atof( fldPY -> text() . ascii() );
   v.z = atof( fldPZ -> text() . ascii() );

   v.w = 1;
   return v;

}

Quat PMeshDlg::getOrientation()
{
   Vector4 v;
   Quat q;
   v.x = atof( fldRX -> text() . ascii() );
   v.y = atof( fldRY -> text() . ascii() );
   v.z = atof( fldRZ -> text() . ascii() );

   v.w = 1;

   q.setEuler( v );

   return q;

}


void PMeshDlg::setFaces( int x )
{
   QString s;
   s.setNum( x );
   lblFaces -> setText( s );
}

void PMeshDlg::setVertices( int x )
{
   QString s;
   s.setNum( x );
   lblVertices -> setText( s );
}
