/***************************************************************************
                         surfacecreator.cpp  -  description
                            -------------------
   begin                : Thu Apr 19 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "surfacecreator.h"
#include <Entities/nurbssurface.h>
#include <i3d.h>
#include <i3dworkspace.h>
#include "csurfacedlg.h"

#include "vertexmodifier.h"

int SurfaceCreator::TYPE = IControl::getUID();

SurfaceCreator::SurfaceCreator() : Creator()
{
   setName( "Sur&faces..." );
   QPopupMenu *plane = new QPopupMenu();

   plane -> insertItem( "&XY", this, SLOT( slotCreateXYPatch() ) );
   plane -> insertItem( "X&Z", this, SLOT( slotCreateXZPatch() ) );
   plane -> insertItem( "&YZ", this, SLOT( slotCreateYZPatch() ) );


   m_popup -> insertItem( "&Sphere", this, SLOT( slotCreateSphere() ) );
   m_popup -> insertItem( "&Torus", this, SLOT( slotCreateTorus() ) );
   m_popup -> insertItem( "&Patch", plane );
   m_popup -> insertItem( "&Custom Patch", this, SLOT( slotCreateCustom() ) );


   m_surface = 0;

}

SurfaceCreator::~SurfaceCreator()
{}

void SurfaceCreator::mousePress( Vector4 &plane, Vector4 &pt, int i )
{
   if ( m_surface != 0 )
   {
      cerr << "Inserting surface" << endl;
      //insert the mesh and move to the given point.
      Command *c = new DBCommand( m_surface, ADD );
      c->execute();
      c->save();

      m_surface -> move( pt.x, pt.y, pt.z );

      //reset
      m_surface = 0;
      I3D::getWorkspace() -> revertControl();
      updateViews();
      setStatusDone();
   }

   else
   {
      cerr << "No surface to insert" << endl;
   }


}


void SurfaceCreator::keyEvent( QKeyEvent * c )
{
   //ignore any key presses for now.
   setStatusDone();
   I3D::getWorkspace() -> revertControl();
}

/** Set this creator to be active.
  */
void SurfaceCreator::activate()
{
   I3D::activateControl( VertexModifier::TYPE );
   I3D::setModeMsg( " Create Mode " );
   I3D::getWorkspace() -> setCurrentControl( this );
}

/** Clean up as control leaves this creator.
  */

void SurfaceCreator::deactivate()
{
   /* User skipped out before actually adding the mesh
    */

   if ( m_surface != 0 )
      delete m_surface;

}


/** Creates the default sphere
  */
void SurfaceCreator::slotCreateSphere()
{
   activate();
   m_surface = new NurbsSurface();
   Vector4 p( 0, 0, 0, 1 );
   m_surface -> makeSphere( p );
   setStatus( "Creating sphere:  Click to add surface" );
}

/** Creates the default cylinder
  */
void SurfaceCreator::slotCreateTorus()
{
   activate();
   m_surface = new NurbsSurface();
   Vector4 p( 0, 0, 0, 1 );
   m_surface -> makeTorus( p );
   setStatus( "Creating torus:  Click to add surface" );

}

/** Creates the default plane
  */
void SurfaceCreator::slotCreateXYPatch()
{
   activate();

   m_surface = new NurbsSurface();
   Vector4 p( 0, 0, 0, 1 );
   m_surface -> makePlane( p, 0, 4, 4 );
   setStatus( "Creating XY Patch:  Click to add surface" );

}

/** Creates the default plane
  */
void SurfaceCreator::slotCreateXZPatch()
{
   activate();

   m_surface = new NurbsSurface();
   Vector4 p( 0, 0, 0, 1 );
   m_surface -> makePlane( p, 1, 4, 4 );
   setStatus( "Creating XZ Patch:  Click to add surface" );
}

/** Creates the default plane
  */
void SurfaceCreator::slotCreateYZPatch()
{
   activate();

   m_surface = new NurbsSurface();
   Vector4 p( 0, 0, 0, 1 );
   m_surface -> makePlane( p, 2, 4, 4 );
   setStatus( "Creating YX Patch:  Click to add surface" );
}


/** Creates a custom mesh.
  */
void SurfaceCreator::slotCreateCustom()
{
   activate();
   setStatus( "Creating a custom patch: Click to add surface" );

   /* Popup custom dialog here.
    */
   CSurfaceDlg *dlg = new CSurfaceDlg( 0, "Create Custom Patch", true );

   if ( dlg -> exec() )
   {

      m_surface = new NurbsSurface();
      Vector4 p( 0, 0, 0, 1 );
      m_surface -> makePlane( p, dlg->getPlane(), dlg->getU(), dlg->getV() );
      m_surface -> setName( dlg->getName().ascii() );
      m_surface -> setNotes( dlg->getNotes().ascii() );

   }

   else
   {
      I3D::getWorkspace() -> revertControl();
      updateViews();
      setStatusDone();
   }

   delete dlg;

}

