/***************************************************************************
                          dynamiclibrary.h  -  description
                             -------------------
    begin                : Fri Feb 11 2000
    copyright            : (C) 2000 by Jon Anderson, Will DeVore
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DYNAMICLIBRARY_H
#define DYNAMICLIBRARY_H

#include "ltdl.h"

/**This class encapsulates the work of loading dynamic libraries
for plugins.
  *@author Jon Anderson
  */

//typedef void *(*DLPROC)();
typedef void *(*lt_dlfunction)();

class DynamicLibrary {
public: 
	DynamicLibrary();
	DynamicLibrary(const char * libname);	
	~DynamicLibrary();
	
	bool loadLibrary(const char * libname);
	bool unloadLibrary();
	bool isLoaded(void) const { return (libHandle != 0); };
	
	lt_dlfunction getProcAddr(const char *procName) const;
	lt_dlfunction getProcAddrCached(const char *procName, unsigned int procId);
	
private:
	lt_dlhandle libHandle;
	
};

#endif
