#ifndef _KCS_CTL_H
#define _KCS_CTL_H

typedef struct device_id_response
  {
  unsigned char device_id;

  unsigned char device_revision         :4;
  unsigned char reserved                :3;
  unsigned char provides_sdr            :1;

  unsigned char major_firmware_revision :7;
  #define NORMAL_OPERATION  0
  #define DEVICE_BUSY       1
  unsigned char device_available        :1;

  unsigned char minor_firmware_revision;

  unsigned char ipmi_version_major      :4;
  unsigned char ipmi_version_minor      :4;

  unsigned char supports_sensor_device  :1;
  unsigned char supports_sdr_device     :1;
  unsigned char supports_sel_device     :1;
  unsigned char supports_fru_device     :1;
  unsigned char supports_ipmb_receiver  :1;
  unsigned char supports_ipmb_generator :1;
  unsigned char supports_bridge         :1;
  unsigned char supports_chassis_device :1;

  unsigned char manufacturer_id1;
  unsigned char manufacturer_id2;
  unsigned char manufacturer_id3;

  unsigned short product_id;
  } DEVICE_ID_RESPONSE;

typedef struct set_watchdog
  {
  unsigned char timer_use         :3;
  unsigned char res1              :4;
  unsigned char dontlog           :1;
  
  unsigned char timeout_action    :3;
  unsigned char res2              :1;
  unsigned char pre_irq           :3;
  unsigned char res3              :1;
  
  unsigned char pretimeout_interval;
  
  unsigned char tuefc_res1        :1;
  unsigned char tuefc_biosfrb2    :1;
  unsigned char tuefc_biospost    :1;
  unsigned char tuefc_osload      :1;
  unsigned char tuefc_smsos       :1;
  unsigned char tuefc_oem         :1;
  unsigned char tuefc_res2        :1;
  unsigned char tuefc_res3        :1;
  
  unsigned short initial_count;
  } SET_WATCHDOG;
 
typedef struct get_watchdog_response
  {
  unsigned char timer_use    :3;
  unsigned char res1         :3;
  unsigned char timer_status :1;
  unsigned char sel_log      :1;

  unsigned char timeout_act  :3;
  unsigned char res2         :1;
  unsigned char pre_irq_act  :3;
  unsigned char res3         :1;

  unsigned char pre_timeout __attribute__ ((packed));

  unsigned char timer_use_xp  __attribute__ ((packed));

  unsigned short init_count  __attribute__ ((packed));
  unsigned short current_count __attribute__ ((packed));
  } GET_WATCHDOG_RESPONSE;

#define BOARD_AREA_NUM_FIELDS  4
#define BOARD_MANUFACTURER   0
#define BOARD_PRODUCT_NAME   1
#define BOARD_SERIAL         2
#define BOARD_PART           3

#define PRODUCT_AREA_NUM_FIELDS  6
#define PRODUCT_MANUFACTURER   0
#define PRODUCT_NAME           1
#define PRODUCT_PART           2
#define PRODUCT_VERSION        3
#define PRODUCT_SERIAL         4
#define PRODUCT_ASSET          5

typedef struct kcs_fru_area_info
  {
  unsigned short  size  __attribute__ ((packed));

#define ACCESSMODE_BYTE  0
#define ACCESSMODE_WORD  1
  unsigned char    accessmode:1;
  unsigned char    reserved:7;
  } FRU_AREA_INFO;

typedef struct fru_data_req_ipmi_10
  {
	unsigned char		 devid	 __attribute__ ((packed));
  unsigned short   offset  __attribute__ ((packed));
  unsigned char    count    __attribute__ ((packed));
  } FRU_DATA_REQ_IPMI_10;

typedef struct fru_data_req_ipmi_09
  {
  unsigned short   offset  __attribute__ ((packed));
  unsigned char    count    __attribute__ ((packed));
  } FRU_DATA_REQ_IPMI_09;

typedef struct fru_data_chunk
	{
	unsigned char	count;
	unsigned char	data[16];
	} FRU_DATA_CHUNK;

typedef struct fru_data_write_req_ipmi_09
	{
	unsigned short	offset __attribute__((packed));
	unsigned char		data[0];
	} FRU_DATA_WRITE_REQ_IPMI_09;

typedef struct fru_data_write_req_ipmi_10
	{
	unsigned char		dev_id __attribute__((packed));
	unsigned short	offset __attribute__((packed));
	unsigned char		data[0];
	} FRU_DATA_WRITE_REQ_IPMI_10;

typedef struct fru_common_header
  {
  unsigned char common_header_format_version;
  unsigned char internal_use_offset;
  unsigned char chassis_info_offset;
  unsigned char board_area_offset;
  unsigned char product_info_offset;
  unsigned char multirecord_area_offset;
  unsigned char pad;
  unsigned char checksum;
  } FRU_COMMON_HEADER;

typedef struct type_length
  {
  unsigned char  num_bytes  :6;
  unsigned char  type_code  :2;
  } TL;

#define CMD_GET_FRU_INV_AREA_INFO   0x10
#define CMD_READ_FRU_INV_DATA       0x11
#define CMD_WRITE_FRU_INV_DATA      0x12
#define CMD_ADD_SEL_ENTRY           0x44
#define CMD_WATCHDOG_SET            0x24
#define CMD_WATCHDOG_GET            0x25
#define CMD_WATCHDOG_RESET          0x22
#define CMD_GET_DEVICE_ID           0x01

#endif
