/*
	IRE:		Core Data structures

	Version: 	2.0, 29/2/00

*/

#ifndef __IRCORE
#define __IRCORE

#define IKV "0.92"           // IRE Kernel Version

#define W_SIZE 10
#define ACT_STACK 8             // Sub-Activity stack

#define RANDOM_TILE 0xffff      // Appears as an eyesore

#define CHAR_U 0  // Directions for the sequence cache in CHlist
#define CHAR_D 1
#define CHAR_L 2
#define CHAR_R 3

#define FP_DIAGONAL 1   // Pathfinder flags
#define FP_FINDROUTE 2

#define KILLROOF	1
#define KILLMAP		2

#define MAPSIG 0xf15e0005

#define MAX_W 8192
#define MAX_H 8192
#define MAX_MEMBERS 128

#define MAP_POS(x,y) (ytab[y]+(x))

#include <allegro.h>

#ifndef __VMTYPE
#define __VMTYPE
typedef union VMTYPE
{
void *ptr;
unsigned int u32;
unsigned short u16;
unsigned char u8;
int i32;
short i16;
char i8;
} VMTYPE;
#endif

///////////////////////////////////////////////////////////////////////////
//  Script Processing Data Structures                                    //
///////////////////////////////////////////////////////////////////////////

// NPC Flags

typedef struct NPC_FLAGS
{
unsigned int female			:1; // Male or Female
unsigned int know_name		:1; // Do I know you?
unsigned int is_hero		:1; // Is this the hero?
unsigned int cant_eat		:1; // Can it eat and drink? (Robots can't)
unsigned int critical		:1; // Has gone critical
unsigned int no_shutdoor	:1; // Won't shut doors after themselves
unsigned int symlink		:1; // Owner is the NPC, not object (phones etc)
unsigned int biological		:1; // Affected by poison etc
unsigned int guard			:1; // Policeman
unsigned int spawned		:1; // Dynamically created (and destroyed ;-)
unsigned int no_opendoor	:1; // Can't open doors
unsigned int in_bed			:1; // In bed
unsigned int ignoreschedule	:1; // temporary monomania (e.g. for a plot event)
unsigned int spare			:18;
} NPC_FLAGS;

typedef struct NPC_RECORDING
{
char *page;
struct OBJECT *player;
struct NPC_RECORDING *next;
} NPC_RECORDING;

typedef struct CHAR_LABELS
{
char *rank;
char *race;
char *party;
char *location;
} CHAR_LABELS;

// Statistics

typedef struct STATS
{
int hp;
int dex;
int str;
int intel;
int weight;
int quantity;
int armour;
int tick;                   // Animation timer
NPC_FLAGS npcflags;
int damage;                 // Damage (caused by a weapon)
int radius;
struct OBJECT *owner;
int karma;                  // Have you been a good little boy? (or girl)
int bulk;
int range;
int speed;
int level;                  // skill level
} STATS;


// Temporary data for a game in progress
// Changing this may well break savegame compatability

typedef struct USEDATA
{
int user[20];
int poison;
int unconscious;
int potion[10]; // space for 10 potions
int dx,dy;      // Used by the pathfinder
int vigilante;  // If this is set, you have a license to kill people
int edecor;     // Used by the Editor
int counter;    // Counter.  Used by eggs or the pathfinder
int experience; // Experience points
int magic;      // Magic points
int archive;    // Used when switching worlds
int oldhp;      // Previous hp, used internally
struct OBJECT *arcpocket; // Used when switching worlds
struct OBJECT *pathgoal;  // For the long-range pathfinder

// Sub-Activities
int actlist[ACT_STACK];
struct OBJECT *acttarget[ACT_STACK];
int actptr,actlen;

int fx_func; // Special effects function number or 0

NPC_RECORDING *npctalk;     // Used to record what you've said for continuity
NPC_RECORDING *lFlags;      // Local Flags
} USEDATA;

// Archive states for objects as they move between worlds

enum
	{
	UARC_NORMAL,
	UARC_ONCEONLY,
	UARC_SYSPOCKET,
	UARC_INPOCKET,
	UARC_SYSLIST,
	};

// A single sprite

typedef struct S_POOL
{
char *name;
char *fname;
RLE_SPRITE *image;
int thumbcol;

int w,h;
unsigned int wxh;
int x,y;
unsigned char flags;
int darkness;
} S_POOL;

// A single lightmap sprite

typedef struct L_POOL
{
char *fname;
BITMAP *image;
} L_POOL;

// A complete animation sequence

typedef struct SEQ_POOL
{
char *name;
S_POOL **seq;
int frames;
unsigned int flags;	// See SEQ_FLAGS
int x,y;
unsigned char speed;
S_POOL *overlay;        // This is always drawn on top of the sprite
                        // but it has no physical existence
struct SEQ_POOL *jumpto;// Sequence to jump to on exit if necessary
int hookfunc;           // Optional script call
int translucency;       // Translucency amount
} SEQ_POOL;

#define SEQFLAG_PINGPONG		0x00000001
#define SEQFLAG_LOOP			0x00000002
#define SEQFLAG_RANDOM			0x00000004
#define SEQFLAG_UNISYNC			0x00000005
#define SEQFLAG_ANIMCODE		0x00000007 // mask covering animation flags

#define SEQFLAG_STEPPED			0x00000010
#define SEQFLAG_JUMPTO			0x00000020
#define SEQFLAG_CHIMNEY			0x00000040
#define SEQFLAG_POSTOVERLAY		0x00000080
#define SEQFLAG_WALL			0x00000100
#define SEQFLAG_ASYNC			0x00000200


// Scripts

typedef struct PEM
	{
	char *name;
	char *file;
	char *code;
	int codelen;
	int size;
	char hidden; // local function
	char Class;
	} PEM;

typedef struct DT_ITEM
	{
	char *ks;
	int ki;
	char *is;
	int ii;
	} DT_ITEM;

typedef struct DATATABLE
	{
	char *name;
	int entries;

	char keytype;
	char listtype;

	DT_ITEM *list;
	} DATATABLE;

//////////////////////////////////////////////////////////////////
//  Object Data Structures                                      //
//////////////////////////////////////////////////////////////////

typedef struct S_FLAGS
{
unsigned int on	:1;     // active?
unsigned int willopen:1;    // Is is always impassible?
unsigned int window:1;      // Is it a window?
unsigned int solid:1;       // Is it solid to people?
unsigned int fragile:1;     // Will it break if you drop it?
unsigned int trigger:1;     // Is it a trigger?
unsigned int invisible:1;   // Will it only appear in the editor?
unsigned int party:1;       // Is it a Party Member? (affects solidity)
unsigned int fixed:1;       // Is is nailed to the ground (can't move)
unsigned int container:1;   // Is is a container?
unsigned int translucent:1; // Is it translucent?
unsigned int large :1;      // Object bigger than 1 tile
unsigned int spikeproof:1;  // Isn't hurt by objects below
unsigned int wield :1;      // Can it be wielded?
unsigned int stepupdated :1;// Was just updated (used by stepping code)
unsigned int setsequence :1; // Has setsequence just been used?
unsigned int blocklight :1; // Does it blocklight?
unsigned int tabletop   :1; // Can you drop things on it even if it's solid?
unsigned int didinit    :1; // Have we done the INIT function?
unsigned int didupdate  :1; // Have we moved just now (prevent runaway)?
unsigned int person     :1; // Is a person
unsigned int horror     :1; // Will the very sight of it affect NPCs
unsigned int quantity   :1; // Can it be a pile of things?
unsigned int watery     :1; // Can it go on water (or is it a water tile?)
unsigned int shadow     :1; // Is it just a dark patch?
unsigned int decor      :1; // Is it a decoration?
unsigned int system     :1; // Hidden from the player (markers, triggers)?
unsigned int spare      :6;
} S_FLAGS;

typedef struct FUNCS            // This is called when you...
{
char use[32];           // USE it
int  ucache;
char *suse;             // This is a pointer to the string array, for PEscript

char talk[128];          // TALK to it
int  tcache;
char *stalk;

char kill[32];          // KILL/BREAK it
int  kcache;
char *skill;

char look[32];          // LOOK at it
int  lcache;
char *slook;

char stand[32];         // STAND on it
int  scache;
char *sstand;

char hurt[32];          // HURT/DAMAGE it
int  hcache;
char *shurt;

char init[32];          // Called when object first created
int  icache;
char *sinit;

// The ?cache number succeeding each entry is the index in the array of VRMs
// to the one that will be called, and is used for optimisation.

char contains[8][32];
int contents;
// Up to 8 objects can be put in the object when it's first created

char resurrect[32];          // Object it becomes when resurrected
char *sresurrect;

char wield[32];          // Called when object is wielded/removed
int  wcache;
char *swield;

char attack[32];          // Attack with it
int  acache;
char *sattack;

char user1[32];
char *suser1;

char user2[32];
char *suser2;

char horror[32];          // NPC sees something truly awful
int  hrcache;
char *shorror;

char quantity[32];          // Quantity is changed
int  qcache;
char *squantity;

} FUNCS;

// Tiles

typedef struct TILE
{
char *name;
S_FLAGS flags;
SEQ_POOL *form;		// Direct access to animation
char seqname[32];	// Name of animation (in editor)
int sptr;			// Animation counter
int cost;			// movement cost
int sdir,tick;		// animation info
int sdx,sdy;		// Scroll delta x,y
int sx,sy;			// scroll coordinates x,y
int standfunc;		// Function to be called if stood
char *desc;			// description
SEQ_POOL **alternate;// Alternate tiles (for blanked corners) or NULL
} TILE;

// AI objects

typedef struct SCHEDULE
{
char ok,hour,minute;

char vrm[32];
int call;
struct OBJECT *target;
} SCHEDULE;


typedef struct WIELD
{
struct OBJECT *head;
struct OBJECT *neck;
struct OBJECT *body;
struct OBJECT *legs;
struct OBJECT *feet;
struct OBJECT *arms;
struct OBJECT *l_hand;
struct OBJECT *r_hand;
struct OBJECT *l_finger;
struct OBJECT *r_finger;
struct OBJECT *spare1;
struct OBJECT *spare2;
struct OBJECT *spare3;
struct OBJECT *spare4;
} WIELD;

// Moving object entity

typedef struct OBJECT
{
char *name;
S_FLAGS flags;
int w,h,mw,mh;
int x,y,z;
char *personalname;
SCHEDULE *schedule;
SEQ_POOL *form;
int sptr,SPARE,sdir; // animation info
STATS *maxstats;    // Statistics structure
STATS *stats;       // Current stats
FUNCS *funcs;       // VRM Function table
int curdir;
short dir[4];       // u,d,l,r
char *desc;         // Examine Description
char *shortdesc;    // Short Description
struct OBJECT *target; // Current target object (behaviour goal, if any)
int   tag;          // Tags are used for triggering things
int   activity;     // Current activity VRM
struct USEDATA *user;      // User data for a game in progress
unsigned char hblock[4]; // xywh
unsigned char vblock[4]; // xywh
unsigned char harea[4]; // xywh
unsigned char varea[4]; // xywh
int hotx,hoty;          // attack hotspot
int save_id;     // Assigned object number (during saving and loading)
int inside_id;   // Assigned parent number (needed for 0.7 compatability)
int light;        // Light it casts
CHAR_LABELS *labels;    // Tags and labels for the object that don't change.
struct OBJECT *enemy;
struct OBJECT **wield;
struct OBJECT *pocket;
struct OBJECT *next;
struct OBJECT *parent;
} OBJECT;


typedef struct OBJREGS
{
OBJECT *player;
OBJECT *current;
OBJECT *me;
OBJECT *victim;
} OBJREGS;


#define BLK_X 0
#define BLK_Y 1
#define BLK_W 2
#define BLK_H 3

// World structure

typedef struct WORLD
{
unsigned int sig;			// Signature
int w,h;
unsigned short *physmap;	// Physical world
OBJECT *object;				// Linked list of objects
unsigned char *roof;		// Rooftop
OBJECT **objmap;			// Object Map
unsigned char *light;		// Static Lighting
unsigned char *lightst;
int con_n,con_s,con_e,con_w;// map connections
int *temp[25];
} WORLD;

typedef struct OBJLIST
{
OBJECT *ptr;
struct OBJLIST *next;
} OBJLIST;

typedef struct PEVM
	{
	OBJECT *reg[4];		// Local object registers
	char *name;			// Name of function (for debugging)
	char *file;			// Filename of function (for debugging)
	VMTYPE *code;	// code and data
	int size;			// length of code and data
	int codelen;		// length of code and data
	VMTYPE *ip;	// instruction pointer
	struct PEVM *next;	// for use as a linked-list (vmstack etc)
	} PEVM;

// Tile Linker for automatic map structure generation

typedef struct TL_DATA
	{
	int tile;
	int becomes;
	} TL_DATA;

typedef struct TILELINK
	{
	char *name;
	int tile;
	TL_DATA *n;
	TL_DATA *s;
	TL_DATA *e;
	TL_DATA *w;
	TL_DATA *ne;
	TL_DATA *nw;
	TL_DATA *se;
	TL_DATA *sw;
	int nt;
	int st;
	int et;
	int wt;
	int net;
	int nwt;
	int set;
	int swt;
	} TILELINK;

typedef struct USERSTRING
{
int len;
char *ptr;
} USERSTRING;


// Externals

extern OBJLIST *MasterList;
#ifdef __cplusplus
extern "C"
	{
#endif

extern int gamewinsize;
extern BITMAP *gamewin;
extern BITMAP *roofwin;
extern int VSW; // Tiles
extern int VSH;
extern int VSA;
extern int VSMIDX;
extern int VSMIDY;
extern int VSW32; // Pixels
extern int VSH32;
extern int VSA32;

extern char imgcachedir[];

	#ifdef __cplusplus
	}
	#endif

#endif

