/*
 *      Game state information
 */

#define LMSIZE 32
#define VIEWDIST 10 // was 4

// Pathfinder results
#define PATH_FINISHED 0
#define PATH_WAITING -1
#define PATH_BLOCKED -2

#ifdef __cplusplus
extern "C" {
#endif

extern OBJECT *syspocket;          // Storage area for GUI objects
extern OBJECT *player;             // The player
extern OBJECT *victim;             // Global variable
extern OBJECT *person;             // Current person being moved
extern OBJECT *current_object;     // Global variable
extern OBJECT *fx_obj;             // Object special effect is centred around
extern TILE *current_tile;         // Global variable
extern OBJECT **party;
extern char **partyname;
extern WORLD *curmap;               // pointer to current world
extern WORLD worldcache[];

extern int game_minute;     // Script engine doesn't support char
extern int game_hour;
extern int game_day;
extern int game_month;
extern int game_year;
extern int days_passed;
extern int day_of_week;

extern int mapx,mapy,mapx2,mapy2; // Coordinates for Seer
extern int new_x,new_y;           // Seer parameters
extern int Fader;                 // Lighting control
extern int SoundFixed;            // Stop sounds fading with distance if 1
extern int irekey;                // Key pressed by user
extern int show_roof;             // Project the roof? (Yes)
extern int force_roof;            // Force the roof to appear? (-1,0,1)
extern char fullrestore;          // Do we revert all objects to their defaults?
extern int ytab[MAX_H];           // Fast access to parts of the map
extern int buggy;                 // Were warnings detected?
extern int ire_running;
extern int combat_mode;
extern int mu_volume,sf_volume;	  // Audio levels

extern int change_map,change_map_x,change_map_y,change_map_tag;

// Global vars, intended for use with the conversation engine
extern int pe_usernum1,pe_usernum2,pe_usernum3,pe_usernum4,pe_usernum5;


extern OBJECT *largemap[LMSIZE][LMSIZE];  // Large Object caches
extern OBJECT *solidmap[LMSIZE][LMSIZE];
extern int decorxmap[LMSIZE][LMSIZE];
extern int decorymap[LMSIZE][LMSIZE];
extern OBJLIST *ActiveList;       // List of all active objects
extern OBJECT limbo;

extern BITMAP *MouseOverPtr; // New mouse pointer

// Cached ID numbers for 'system' VRMs

extern int Sysfunc_scheduler, Sysfunc_status, Sysfunc_follower;
extern int Sysfunc_splash, Sysfunc_trackstop, Sysfunc_updatelife;
extern int Sysfunc_erase, Sysfunc_wakeup;
extern int mapnumber,fx_func;

// Resource Data

extern SEQ_POOL *SQlist; // Sequences in the SQlist
extern long SQtot;       // no. of sequences
extern OBJECT *CHlist;   // Array of characters
extern long CHtot;       // no. of characters
extern S_POOL *SPlist;   // Array of sprites
extern long SPtot;       // number of sprites
extern TILE *TIlist;   // Array of sprites
extern long TItot;       // number of sprites
extern S_POOL *RTlist;   // Array of sprites
extern long RTtot;       // number of sprites
extern L_POOL *LTlist;   // Array of sprites
extern long LTtot;       // number of sprites
extern long PEtot;	 // number of user functions
extern PEM *PElist;	// List of user functions
extern char **pe_files;	 // List of user script files (not funcs)
extern DATATABLE *DTlist;   // Array of lookups
extern long DTtot;       // number of lookups
extern TILELINK *TLlist;   // Array of tile links
extern long TLtot;       // number of tile links

extern long spr_alloc;
extern long seq_alloc;
extern long vrm_alloc;
extern long chr_alloc;
extern long til_alloc;
extern long mus_alloc;
extern long wav_alloc;
extern long rft_alloc;
extern long lgt_alloc;
extern long pef_alloc;
extern long tab_alloc;
extern long tli_alloc;

// Special Effects registers

extern int tfx_sx,tfx_sy;
extern int tfx_dx,tfx_dy;
extern int tfx_Brushsize,tfx_Colour,tfx_Alpha,tfx_intensity,tfx_falloff;
extern int tfx_picdelay1,tfx_picdelay2,tfx_picdelay3;
extern int tfx_radius,tfx_drift,tfx_speed;

extern void VM_RestoreRegs(OBJREGS *o);
extern void VM_SaveRegs(OBJREGS *o);


#ifdef __cplusplus
}
#endif
