(cl:defpackage :ironclad
  (:use :cl)
  (:nicknames :crypto)
  (:export
   ;; hash functions
   #:digest-sequence #:digest-stream #:digest-file
   #:make-digest #:copy-digest #:update-digest #:produce-digest

   ;; HMACs
   #:make-hmac #:update-hmac #:hmac-digest

   ;; introspection
   #:cipher-supported-p #:list-all-ciphers
   #:digest-supported-p #:list-all-digests
   #:mode-supported-p #:list-all-modes
   #:block-length #:digest-length #:key-lengths

   ;; high-level block cipher operators
   #:make-cipher #:encrypt #:decrypt

   ;; block cipher classes
   #:aes-context #:square-context #:blowfish-context #:idea-context
   #:twofish-context #:misty1-context #:rc5-context #:rc6-context
   #:des-context #:cast5-context #:tea-context #:xtea-context #:3des-context

   ;; public-key encryption operations
   #:make-public-key #:make-private-key
   #:sign-message #:verify-signature
   #:encrypt-message #:decrypt-message

   ;; public-key slot readers
   #:dsa-key-p #:dsa-key-q #:dsa-key-g #:dsa-key-y #:dsa-key-x
   #:dsa-signature-r #:dsa-signature-s

   ;; conditions
   #:ironclad-error #:initialization-vector-not-supplied
   #:invalid-initialization-vector #:invalid-key-length
   #:unsupported-cipher #:unsupported-mode

   ;; utilities
   #:ascii-string-to-byte-array #:byte-array-to-hex-string
   #:octets-to-integer #:integer-to-octets
   #:make-octet-input-stream #:make-octet-output-stream
   #:get-output-stream-octets))
