/*
 sample.c : sample plugin for irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <irssi-plugin.h>
#include "proxy.h"

static PLUGIN_REC *plug;

gchar *plugin_description(void)
{
    return "IRC proxy plugin";
}

gint plugin_version(void)
{
    return PLUGIN_LAYER_VERSION;
}

/* If we call plugin_deinit() in this code, it doesn't necessarily point to
   _THIS_ module's plugin_deinit() but instead some other module's.. So,
   we create static deinit() function which should be used.. */
static void deinit(PLUGIN_REC *plugin)
{
    PLUGIN_DATA *data = plugin->data;

    if (data->loaded)
    {
        printtext(NULL, NULL, MSGLEVEL_CLIENTNOTICE, "Proxy plugin unloaded");
	plugin_proxy_listen_deinit(plugin->data);
    }

    g_free(data);
}


void plugin_deinit(PLUGIN_REC *plugin)
{
    deinit(plugin);
}

gboolean plugin_init(gint gui, PLUGIN_REC *plugin, gchar *args)
{
    PLUGIN_DATA *data;

    plug = plugin;
    plugin->data = data = g_new0(PLUGIN_DATA, 1);
    data->plugin = plugin;
    data->gui = gui;
    data->port = 2777;

    if (args != NULL && *args != '\0')
    {
	gchar *params, *password, *addr, *port;

	params = cmd_get_params(args, 3, &password, &addr, &port);

	if (*password != '\0')
	{
	    /* args = password */
	    data->password = g_strdup(password);
	}
	if (*addr != '\0')
	{
	    /* specify ip address to listen */
	    memcpy(&data->ip, net_host2ip(addr), sizeof(IPADDR));
	}
	if (*port != '\0')
	{
	    /* specify port to use */
	    sscanf(port, "%d", &data->port);
	}
	g_free(params);
    }

    if (data->password == NULL)
    {
	/* no password - bad idea! */
	printtext(NULL, NULL, MSGLEVEL_CLIENTNOTICE, "Warning!! Password not specified, everyone can use this proxy! Use /load proxy <password> instead to set it");
    }

    if (servers == NULL)
    {
	/* FIXME: not good */
	printtext(NULL, NULL, MSGLEVEL_CLIENTERROR, "You need to specify IP address to listen with /load proxy <password> <address>");
	deinit(plugin);
	return FALSE;
    }
    else
    {
	SERVER_REC *server;

	server = servers->data;
	if (!net_getsockname(server->handle, &data->ip, NULL))
	{
	    deinit(plugin);
	    return FALSE;
	}
    }

    printtext(NULL, NULL, MSGLEVEL_CLIENTNOTICE, "Proxy plugin loaded - listening in interface %s port %d", net_ip2host(&data->ip), data->port);

    plugin_proxy_listen_init(data);

    data->loaded = TRUE;
    return TRUE;
}
