/*
 gtk-speech.c : GTK specific functions for plugin

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <irssi-plugin.h>
#include <irssi-plugin-gui.h>
#include "speech.h"

static GtkWidget *setup_dialog;

static gboolean sig_setup_apply(GtkWidget *dialog, PLUGIN_REC *plugin)
{
    setup_write("plugin_speech", plugin_speech_options);
    plugin_speech_get_setup(plugin);
    return TRUE;
}

static gboolean setup_festival(GtkWidget *dialog)
{
#ifdef HAVE_GNOME
    GtkWidget *table, *entry, *label, *spin, *hbox;
    GtkAdjustment *adj;

    setup_dialog = dialog;

    table = gtk_table_new(3, 2, FALSE);
    gtk_container_border_width(GTK_CONTAINER(table), 7);
    gtk_table_set_col_spacing(GTK_TABLE(table), 0, 5);

    entry = gui_create_tablelabelentry(table, 0, 0, _("Address"),
                                       *((gchar **) plugin_speech_options[OPTION_FESTIVAL_ADDRESS].data));
    plugin_speech_options[OPTION_FESTIVAL_ADDRESS].widget = entry;

    label = gtk_label_new(_("Port"));
    gtk_misc_set_alignment(GTK_MISC(label), 1, .5);
    gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 0, 0);

    hbox = gtk_hbox_new(FALSE, 0); /* to left justify the spin.. couldn't think of any other way.. */
    gtk_table_attach(GTK_TABLE(table), hbox, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 0, 0);

    adj = (GtkAdjustment *) gtk_adjustment_new (*((gint *) plugin_speech_options[OPTION_FESTIVAL_PORT].data),
                                                1, G_MAXINT, 1, 100, 0);
    spin = gtk_spin_button_new(adj, 0, 0);
    plugin_speech_options[OPTION_FESTIVAL_PORT].widget = spin;
    gtk_widget_set_usize(spin, 60, -1);
    gtk_box_pack_start(GTK_BOX(hbox), spin, FALSE, FALSE, 0);

    entry = gui_create_tablelabelentry(table, 0, 2, _("Initialization command"),
                                       *((gchar **) plugin_speech_options[OPTION_FESTIVAL_INIT].data));
    plugin_speech_options[OPTION_FESTIVAL_INIT].widget = entry;

    setup_finish_init(dialog, plugin_speech_options);

    gnome_property_box_append_page(GNOME_PROPERTY_BOX(dialog),
                                   table, gtk_label_new(_("Festival")));
#endif
    return TRUE;
}

static void plugin_setup(gpointer widget, PLUGIN_REC *plugin)
{
    static GtkWidget *dialog = NULL;

    setup("plugin speech setup", &dialog, plugin);
}

void plugin_speech_gtk_init(PLUGIN_REC *plugin)
{
    plugin_bind(plugin, "plugin speech setup apply", (SIGNAL_FUNC) sig_setup_apply, FALSE);
    plugin_bind(plugin, "plugin speech setup", (SIGNAL_FUNC) setup_festival, FALSE);

    signal_emit("plugin add menu", 3, "Settings...", plugin_setup, plugin);
}
