/*
 gui-nicklist-popup.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"
#include "gui-dcc.h"

/* Kick OK */
static void sig_kick_ok(GtkWidget *window)
{
    CHANNEL_REC *channel;
    GtkWidget *entry;
    GList *nicks;
    gchar *str, *reason, *func;
    GtkObject *nickobject;

    g_return_if_fail(window != NULL);

    entry = gtk_object_get_data(GTK_OBJECT(window), "entry");
    func = gtk_object_get_data(GTK_OBJECT(window), "command");

    reason = gtk_entry_get_text(GTK_ENTRY(entry));
    if (*reason != '\0')
    {
        nickobject = gtk_object_get_data(GTK_OBJECT(window), "data");
        nicks =  gtk_object_get_data(GTK_OBJECT(nickobject), "nicks");
        channel = gtk_object_get_data(GTK_OBJECT(window), "channel");

        while (nicks != NULL)
        {
            str = g_strdup_printf(func, (gchar *) nicks->data, reason);
            signal_emit("send command", 3, str, channel->server, channel);
            g_free(str);

            nicks = nicks->next;
        }

        gtk_object_unref(nickobject);
    }

    gtk_widget_destroy(window);
}

/* popup menu: KNOCKOUT */
static void nicklist_kick(GtkWidget *widget, gchar *command)
{
    GtkWidget *window;
    GtkObject *nickobject;

    g_return_if_fail(widget != NULL);

    nickobject = gtk_object_get_data(GTK_OBJECT(widget), "nickobject");
    gtk_object_ref(nickobject);

    window = gui_entry_dialog(_("Kick reason:"), NULL, "KickReason", GTK_SIGNAL_FUNC(sig_kick_ok), nickobject);
    gtk_object_set_data(GTK_OBJECT(window), "channel",
                        gtk_object_get_data(GTK_OBJECT(widget), "channel"));
    gtk_object_set_data(GTK_OBJECT(window), "command", command);
}

static void nicklist_multiple_cmd(GtkWidget *widget, gchar *func, gchar separator)
{
    CHANNEL_REC *channel;
    GList *nicks;
    GString *str;
    gchar *nick, *cmd;

    g_return_if_fail(widget != NULL);
    g_return_if_fail(func != NULL);

    nicks = gtk_object_get_data(GTK_OBJECT(widget), "nicks");
    channel = gtk_object_get_data(GTK_OBJECT(widget), "channel");

    str = g_string_new(NULL);
    while (nicks != NULL)
    {
	nick = nicks->data;

	if (str->len + strlen(nick)+1 > 500)
	{
	    /* starting to get too big, split to next line */
	    signal_emit(func, 3, str->str, channel->server, channel);
            g_string_truncate(str, 0);
	}

        if (str->len == 0)
            g_string_append(str, nick);
        else
            g_string_sprintfa(str, "%c%s", separator, nick);
        nicks = nicks->next;
    }

    cmd = g_strdup_printf(func, str->str);
    signal_emit("send command", 3, cmd, channel->server, channel);
    g_free(cmd);
    g_string_free(str, TRUE);
}

static void nicklist_cmd(GtkWidget *widget, gchar *func)
{
    nicklist_multiple_cmd(widget, func, ' ');
}

static void nicklist_commacmd(GtkWidget *widget, gchar *func)
{
    nicklist_multiple_cmd(widget, func, ',');
}

static void nicklist_singlecmd(GtkWidget *widget, gchar *func)
{
    CHANNEL_REC *channel;
    GList *nicks;
    gchar *str;

    g_return_if_fail(widget != NULL);
    g_return_if_fail(func != NULL);

    nicks = gtk_object_get_data(GTK_OBJECT(widget), "nicks");
    channel = gtk_object_get_data(GTK_OBJECT(widget), "channel");

    while (nicks != NULL)
    {
	str = g_strdup_printf(func, nicks->data);
	signal_emit("send command", 3, str, channel->server, channel);
	g_free(str);
        nicks = nicks->next;
    }
}

static void window_nicklist_popup_add(GtkWidget *menu, gchar *label, gpointer func, gpointer subfunc, CHANNEL_REC *channel, GtkObject *nickobject)
{
    GtkWidget *popup;
    GList *nicks;

    g_return_if_fail(menu != NULL);
    g_return_if_fail(label != NULL);
    g_return_if_fail(func != NULL);

    nicks = gtk_object_get_data(nickobject, "nicks");

    popup = popup_add(menu, label, func, subfunc);
    gtk_object_set_data(GTK_OBJECT(popup), "channel", channel);
    gtk_object_set_data(GTK_OBJECT(popup), "nicks", nicks);
    gtk_object_set_data(GTK_OBJECT(popup), "nickobject", nickobject);
}

static void nickpopup_free(GList *list)
{
    g_list_foreach(list, (GFunc) g_free, NULL);
    g_list_free(list);
}

/* Nicklist's popup menu */
void gui_nicklist_popup(GtkWidget *menu, CHANNEL_REC *channel, gchar *nick, GdkEventButton *event)
{
    /*GtkWidget *ctcpmenu, *opmenu;*/
    gboolean showmenu;
    GtkCList *clist;
    GList *list, *tmp, *menus;
    NICK_REC *nickrec;
    GtkObject *listobject;

    g_return_if_fail(channel != NULL);
    g_return_if_fail(event != NULL);

    if (nick != NULL)
    {
        if (channel->type == CHANNEL_TYPE_DCC_CHAT) nick++;
        list = g_list_append(NULL, g_strdup(nick));
    }
    else
    {
        clist = GTK_CLIST(WINDOW_GUI(CHANNEL_PARENT(channel))->nicklist);

        list = NULL;
        for (tmp = g_list_first(clist->selection); tmp != NULL; tmp = tmp->next)
        {
            nickrec = gtk_clist_get_row_data(clist, GPOINTER_TO_INT(tmp->data));
            if (nickrec != NULL)
                list = g_list_append(list, g_strdup(nickrec->nick));
        }
    }

    showmenu = menu == NULL;
    if (menu == NULL) menu = gtk_menu_new();

    /* create GtkObject for list so we can use reference counting.. */
    listobject = gtk_object_new(GTK_TYPE_OBJECT, NULL);
    gtk_object_set_data(listobject, "nicks", list);
    gtk_signal_connect_object(listobject, "destroy",
                              GTK_SIGNAL_FUNC(nickpopup_free), (GtkObject *) list);

    /* destroy list after menu is closed */
    gtk_signal_connect_object(GTK_OBJECT(menu), "selection_done",
                              GTK_SIGNAL_FUNC(gtk_object_unref), listobject);

    menus = g_list_append(NULL, menu);
    for (tmp = popups; tmp != NULL; tmp = tmp->next)
    {
	LIST_REC *rec = tmp->data;

	if (g_strcasecmp(rec->key, "<SEP>") == 0)
	{
            /* insert separator */
	    if (menu != NULL) popup_add(menu, NULL, NULL, NULL);
	}
	else if (g_strncasecmp(rec->key, "<MENU>", 6) == 0)
	{
	    /* open new submenu */
	    if (menu == NULL || (g_strncasecmp(rec->key+6, "<OP>", 3) == 0 && !channel->chanop))
	    {
		/* this menu is displayed only when you're chanop */
		menu = NULL;
	    }
	    else
	    {
		menu = gtk_menu_new();
		popup_add_sub(g_list_last(menus)->data, rec->value, menu);
	    }
	    menus = g_list_append(menus, menu);
	}
	else if (g_strcasecmp(rec->key, "</MENU>") == 0)
	{
	    /* close submenu */
	    if (menus->next != NULL)
	    {
		GList *link;

		link = g_list_last(menus);
		menus = g_list_remove_link(menus, link);
		g_list_free_1(link);
	    }
	    menu = g_list_last(menus)->data;
	}
	else if (menu != NULL)
	{
	    /* new menuitem */
	    if (g_strncasecmp(rec->key, "<MULTI>", 7) == 0)
		window_nicklist_popup_add(menu, rec->key+7, nicklist_cmd, rec->value, channel, listobject);
	    else if (g_strncasecmp(rec->key, "<MULTICOMMA>", 12) == 0)
		window_nicklist_popup_add(menu, rec->key+12, nicklist_commacmd, rec->value, channel, listobject);
	    else if (g_strncasecmp(rec->key, "<KICK>", 6) == 0)
		window_nicklist_popup_add(menu, rec->key+6, nicklist_kick, rec->value, channel, listobject);
            else
		window_nicklist_popup_add(menu, rec->key, nicklist_singlecmd, rec->value, channel, listobject);
	}
    }
    menu = menus->data;

    if (showmenu)
        gtk_menu_popup (GTK_MENU(menu), NULL, NULL, NULL, NULL, event->button, event->time);
}

void gui_nicklist_popup_init(void)
{
}

void gui_nicklist_popup_deinit(void)
{
}
