/*
 irssi.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"

gboolean quitting;

/* redraw irssi's screen.. */
void irssi_redraw(void)
{
    clear();

    /* current window */
    gui_window_redraw(CHANNEL_PARENT(cur_channel));
    /* statusbar */
    gui_statusbar_redraw(-1);
    /* entry line */
    gui_entry_redraw();
}

static void textui_init(void)
{
    static struct poptOption options[] = {
	POPT_AUTOHELP
        { NULL, '\0', 0, NULL }
    };

    args_register(options);

    /*FIXME:this is just to get list_() functions linked in! something weird.. */
    list_find(NULL, "");

    irssi_gui = IRSSI_GUI_TEXT;
    mainloop_first_init();
    irc_base_init();
    irc_extra_init();
    ui_common_init();
    mainloop_init();
    setup_init();
}

static void textui_finish_init(void)
{
    quitting = FALSE;

    screen_refresh_freeze();
    gui_channels_init();
    gui_entry_init();
    gui_mainwindows_init();
    gui_printtext_init();
    gui_readline_init();
    gui_textwidget_init();
    gui_windows_init();

    ui_common_finish_init();

    gui_statusbar_init();
    gui_statusbar_items_init();

    signal_emit("irssi init finished", 0);
    screen_refresh_thaw();
}

static void textui_deinit(void)
{
    quitting = TRUE;
    signal(SIGINT, SIG_DFL);

    gui_textwidget_deinit();
    gui_statusbar_items_deinit();
    gui_statusbar_deinit();
    gui_printtext_deinit();
    gui_readline_deinit();
    gui_mainwindows_deinit();
    gui_windows_deinit();
    gui_entry_deinit();
    gui_channels_deinit();
    deinit_screen();

    mainloop_deinit();
    ui_common_deinit();
    irc_extra_deinit();
    setup_deinit();
    irc_base_deinit();
}

int main(int argc, char **argv)
{
#ifdef HAVE_SOCKS
    SOCKSinit(argv[0]);
#endif

    textui_init();
    args_execute(argc, argv);

    if (!init_screen())
    {
        printf("Can't initialize screen handling, quitting.\n");
        return 1;
    }

    textui_finish_init();
    main_loop();
    textui_deinit();

#ifdef MEM_DEBUG
    ig_mem_profile();
#endif

    return 0;
}
