#ifndef __PLUGIN_COMMANDS_H
#define __PLUGIN_COMMANDS_H

/* plugin_bind/unbind: these functions does the same thing as signal_add()
   and signal_remove(). The difference is that when plugin is unloaded,
   signals created with plugin_bind() automatically remove themself.

   So, you should always use these functions with plugins to ensure that
   irssi won't crash when you forgot to unbind some signal..

   see ../signal.doc for list of all signals irssi sends
*/

void plugin_bind(PLUGIN_REC *plugin, gchar *signal, SIGNAL_FUNC func, gboolean last);
void plugin_unbind(PLUGIN_REC *plugin, gchar *signal, SIGNAL_FUNC func);

void plugin_commands_init(void);
void plugin_commands_deinit(void);

#endif
