////
///  genfisuffix - a Finnish affix table generator for ispell
//   Copyright (C) 2000  Pauli Virtanen <pauli.virtanen@saunalahti.fi>
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//   The program's output is also subject to this license, and considered
//   program source code.
//
//////////////////////////////////////////////////////////////////////////////
//
//
#include <vector>
#include <string>
#include "genfisuffix.hh"

vector<string> generate_n_possessive_suffix(const vector<string> &strs)
{
        if (!options.use_possessive_suffixes)
                return vector<string>();

        vector<string> new_strings;

        vector<string>::const_iterator i;
        for (i = strs.begin(); i != strs.end(); ++i)
        {
                string str = *i;

                if (!str.empty() && (*(str.end() - 1) == 'n' ||
                                     *(str.end() - 1) == 'N'))
                {
                        str.erase(str.end()-1, str.end());
                }
                if (str.length() >= 2 &&
                    (*(str.end() - 1) == *(str.end() - 2) ||
                     *(str.end() - 2) == 'i' || *(str.end() - 2) == 'I'))
                {
                        continue;
                }
                if (!str.empty())
                {
                        str += *(str.end() - 1);
                }
                str += 'n';
                new_strings.push_back(str);
        }
        return new_strings;
}
