#!/bin/sh

BUILDRPM_DIR="/usr/src/RPM"
RPM_BASENAME="$1"
VERSION="$2"

if [ "$RPM_BASENAME" = "" ] || [ "$VERSION" = "" ]; then
    echo "usage: $0 <rpmbasename> <version>"
    exit 1
fi

SRC_PACKAGE="spell-uk-$VERSION.tgz"


if [ "$RPM_BASENAME" != "myspell-uk" ]; then

RPMNAME=$RPM_BASENAME-$VERSION
echo "Making $RPMNAME..."

cp dist/$SRC_PACKAGE /tmp
cp pkg/$RPM_BASENAME.spec /tmp

else

RPMNAME=${RPM_BASENAME}_UA-$VERSION
echo "Making $RPMNAME..."

cp dist/$SRC_PACKAGE /tmp
cp pkg/${RPM_BASENAME}.spec /tmp

fi

su -c "mv /tmp/$SRC_PACKAGE $BUILDRPM_DIR/SOURCES; \
	mv /tmp/$RPM_BASENAME.spec $BUILDRPM_DIR/SPECS; \
	cd $BUILDRPM_DIR/SPECS; \
	rpm -ba $RPM_BASENAME.spec"
