'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) disjointlistbox.n 1.21 94/12/17 16:04:44
'/" 
.so man.macros
.HS disjointlistbox iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
disjointlistbox \- Create and manipulate a disjointlistbox widget
.SH SYNOPSIS
\fBdisjointlistbox\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- Disjointlistbox
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBactiveBackground\fR   \fBselectBorderWidth\fR  \fBselectForeground\fR
\fBactiveForeground\fR   \fBactiveRelief\fR       \fBbackground\fR
\fBborderWidth\fR        \fBbuttonPlacement\fR    \fBclientData\fR
\fBcursor\fR             \fBforeground\fR         \fBhighlightColor\fR
\fBhighlightThickness\fR \fBdisabledForeground\fR \fBelementBorderWidth\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBlhsButtonLabel\fR \fBrhsButtonLabel\fR
.fi
.LP
See the "button" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBlabelFont\fR \fBlhsLabelText\fR \fBrhsLabelText\fR
.fi
.LP
See the "label" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBjump\fR \fBtroughColor\fR
.fi
.LP
See the "scrollbar" widget class manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBtextBackground\fR \fBtextFont\fR
\fBlhsItems\fR \fBrhsItems\fR
.fi
.LP
See the "scrolledlistbox" widget manual entry for details on the above
associated options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBbuttonPlacement\fR
Class:	\fBButtonPlacement\fR
Command-Line Switch:	\fB-buttonplacement\fR
.fi
.IP
Specifies the placement of the insertion and removal buttons relative to the
scrolledlistbox widgets\fBn\fR, 
\fBbottom\fR, or \fBcenter\fR.  The default is bottom.
.LP
.nf
Name:	\fBlhsLabelText\fR
Class:	\fBLabelText\fR
Command-Line Switch:	\fB-lhslabeltext\fR
.fi
.IP
Specifies the text for the label of the lhs scrolledlistbox.
The default is "Available".
.LP
.nf
Name:	\fBrhsLabelText\fR
Class:	\fBLabelText\fR
Command-Line Switch:	\fB-rhslabeltext\fR
.fi
.IP
Specifies the text for the label of the rhs scrolledlistbox.
The default is "Available".
.LP
.nf
Name:	\fBlhsButtonLabel\fR
Class:	\fBLabelText\fR
Command-Line Switch:	\fB-lhsbuttonlabel\fR
.fi
.IP
Specifies the text for the button of the lhs scrolledlistbox.
The default is "Insert >>".
.LP
.nf
Name:	\fBrhsButtonLabel\fR
Class:	\fBLabelText\fR
Command-Line Switch:	\fB-rhsbuttonlabel\fR
.fi
.IP
Specifies the text for the button of the rhs scrolledlistbox.
The default is "<< Remove".
.LP
.BE
.SH DESCRIPTION
.PP
The \fBdisjointlistbox\fR command creates a disjoint pair of listboxs
similar to the OSF/Motif "Book" printing dialog of the "FrameMaker"
program.  It is implementation constists of a two Scrolledlistboxs,
2 buttons, and 2 labels.

The disjoint behavior of this widget exists between the interaction of
the two Scrolledlistboxes with one another.  That is, a given instance
of a Disjointlistbox will never exist, without the aid of a hack magician,
which has Scrolledlistbox widgets with items in common.  That means the
relationship between the two is maintained similar to that of disjoint sets.

Users may transfer items between the two Listbox widgets using the
the two buttons.

Options exists which include the ability to configure the "items" displayed by
the 2 Scrolledlistboxes and to control the placement of the insertion and
removal buttons.
.SH "METHODS"
.PP
The \fBdisjointlistbox\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for disjointlistbox widgets:

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBdisjointlistbox\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBdisjointlistbox\fR
command.
.TP
\fIpathName \fBsetlhs\fR
Set the current contents of the left-most Scrolledlistbox with the input list
of items.  Removes all (if any) items from the right-most Scrolledlistbox
which exist in the input list option to maintain the disjoint property
between the two
.TP
\fIpathName \fBsetrhs\fR
Set the current contents of the right-most Scrolledlistbox with the input list
of items.  Removes all (if any) items from the left-most Scrolledlistbox
which exist in the input list option to maintain the disjoint property
between the two
.TP
\fIpathName \fBgetlhs\fR
Returns the current contents of the left-most Scrolledlistbox
.TP
\fIpathName \fBgetrhs\fR
Returns the current contents of the right-most Scrolledlistbox
.TP
\fIpathName \fBinsertlhs\fR
Add the input list of items to the current contents of the left-most
Scrolledlistbox.  Removes all (if any) items from the right-most Scrolledlistbox
which exist in the input list option to maintain the disjoint property
between the two
.TP
\fIpathName \fBinsertrhs\fR
Add the input list of items to the current contents of the right-most
Scrolledlistbox.  Removes all (if any) items from the left-most Scrolledlistbox
which exist in the input list option to maintain the disjoint property
between the two.
.TP
.SH "COMPONENTS"
.LP
.nf
Name:	\fBlhs\fR
Class:	\fBScrolledlistbox\fR
.fi
.IP
The lhs component is the scrolledlistbox for the rhs button.
See the "scrolledlistbox" widget manual entry for details on the lhs 
component item.
.LP
.nf
Name:	\fBrhs\fR
Class:	\fBScrolledlistbox\fR
.fi
.IP
The rhs component is the scrolledlistbox for the rhs button.
See the "scrolledlistbox" widget manual entry for details on the rhs
component item.
.LP
.nf
Name:	\fBlhsbutton\fR
Class:	\fButton\fR
.fi
.IP
The lhsbutton component is the button for users to remove selected items
from the lhs Scrolledlistbox.
See the "button" widget manual entry for details  on the lhs button component.
.LP
.nf
Name:	\fBrhsbutton\fR
Class:	\fBButton\fR
.fi
.IP
The rhsbutton component is the button for users to remove selected items
from the rhs Scrolledlistbox.
See the "button" widget manual entry for details  on the rhs button component.
.LP
.nf
Name:	\fBlhsCount\fR
Class:	\fBLabel\fR
.fi
.IP
The lhsCount component is the label for displaying a count of the current items in
the Scrolledlistbox.
See the "Label" widget manual entry for details  on the lhsCount label component.
.LP
.nf
Name:	\fBrhsCount\fR
Class:	\fBLabel\fR
.fi
.IP
The rhsCount component is the label for displaying a count of the current items in
the Scrolledlistbox.
See the "Label" widget manual entry for details  on the rhsCount label component.
.fi
.IP
.SH EXAMPLE
.DS
disjointlistbox .dlb
pack .dlb -padx 10 -pady 10 -fill both -expand yes 
.DE
.SH AUTHOR(S)
John A. Tucker
.DE
Anthony Parent
.SH KEYWORDS
disjointlistbox, widget
