/****************************************************************************
 *                           LogInstLevel.h
 * Author: Matthew Ballance
 * Desc:  
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "LogInstLevel.h"


/********************************************************************
 * LogInstLevel()
 ********************************************************************/
LogInstLevel::LogInstLevel(LogInstance *inst, LogMgr::DebugLevel dbgLevel) :
            logInst(inst), debugLevel(dbgLevel) 
{ 
    ; 
}

/********************************************************************
 * LogInstLevel()
 ********************************************************************/
LogInstLevel::LogInstLevel() : logInst(0), debugLevel(LogMgr::DebugLevel_Off) 
{ 
    ; 
}

/********************************************************************
 * operator ()
 ********************************************************************/
void LogInstLevel::operator () (LogInstance *inst, LogMgr::DebugLevel dbgLevel) 
{
    logInst = inst;
    debugLevel = dbgLevel;
}

/********************************************************************
 * print()
 ********************************************************************/
int LogInstLevel::print(const char *fmt, ...) 
{
    va_list  ap;
    va_start(ap,fmt);
    if (logInst) {
        return logInst->vprint(debugLevel, fmt, ap);
    } else {
        return 0;
    }
}

/********************************************************************
 * operator ()
 ********************************************************************/
int LogInstLevel::operator () (const char *fmt, ...) 
{
    va_list  ap;
    va_start(ap,fmt);
    if (logInst) {
        return logInst->vprint(debugLevel, fmt, ap);
    } else {
        return 0;
    }
}


/********************************************************************
 * enter()
 ********************************************************************/
void LogInstLevel::enter(const char *fmt, ...)
{
    va_list ap;
    va_start(ap,fmt);

    if (logInst) {
        logInst->venter(debugLevel, fmt, ap);
    }
}

/********************************************************************
 * leave
 ********************************************************************/
void LogInstLevel::leave(const char *fmt, ...)
{
    va_list ap;
    va_start(ap,fmt);

    if (logInst) {
        logInst->vleave(debugLevel, fmt, ap);
    }
}


