/****************************************************************************
 *                             ObjWidgetBase.h
 *
 * Author: Matthew Ballance
 * Desc:   Implements a base-class for all TCL-aware objects...
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_OBJ_WIDGET_BASE_H
#define INCLUDED_OBJ_WIDGET_BASE_H
#include "WidgetManager.h"
#include "ivi_String.h"
#include "types.h"
#include <tcl.h>

class ObjWidgetBase {

    public:
        /************************************************************
         * ObjWidgetBase()
         ************************************************************/
        ObjWidgetBase(
                Tcl_Interp        *interp,
                Uint32             objc,
                Tcl_Obj           *const objv[]);

        /************************************************************
         * ~ObjWidgetBase()
         ************************************************************/
         virtual ~ObjWidgetBase();

        /************************************************************
         * InstCmd()
         ************************************************************/
         virtual int InstCmd(
                 Uint32        objc,
                 Tcl_Obj      *const objv[]);

        /************************************************************
         * CmdStruct
         ************************************************************/
         struct CmdStruct {
             const char        *cmdStr;
             Int32              cmdIdx;
         };

        /************************************************************
         * getCmdStructs()
         *
         * Gets the list of sub-commands. The derived object 
         * overrides this method to provide its own list of commands
         ************************************************************/
        virtual CmdStruct *getCmdStructs();

        /************************************************************
         * CmdSwitch
         ************************************************************/
        Int32 CmdSwitch(const char *cmd);

        /************************************************************
         * CmdSwitch()
         ************************************************************/
        static Int32 CmdSwitch(ObjWidgetBase::CmdStruct *cmds, const char *cmd);

        /************************************************************
         * WidgetInit()
         ************************************************************/
        static int WidgetInit(
                Tcl_Interp        *interp,
                const char        *WidgetName,
                const char        *WidgetVersion,
                const char        *WidgetCmd,
                Tcl_ObjCmdProc    *cmdProc);

        /************************************************************
         * suff_args()
         *
         * Checks to be sure that there are at least 'req_argc'.
         ************************************************************/
        int suff_args(int argc, int req_argc);

        /************************************************************
         * getInstName()
         ************************************************************/
        char *getInstName() const { return d_instName.value(); }

        Uint32            ok;

    /****************************************************************
     * Protected Data
     ****************************************************************/
    protected:
        Tcl_Interp       *d_interp;

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:
        String            d_instName;
        Tcl_Command       d_cmdToken;

        static int InstCmd(
                ClientData        clientData,
                Tcl_Interp       *interp,
                int               objc,
                Tcl_Obj          *const objv[]);
};

#endif /* INCLUDED_OBJ_WIDGET_BASE_H */
