/****************************************************************************
 *                             PixmapObj.cc
 *
 * Author: Matthew Ballance
 * Desc:   Implements a wrapper around a pixmap... This allows us to 
 *         implement various back-ends and use the same drawing code...
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "PixmapObj.h"
#include <stdio.h>

#define FP      stderr
#undef DEBUG_PIXMAP

#ifdef DEBUG_PIXMAP
#define DBG_MSG(x)   fprintf x
#else
#define DBG_MSG(x)
#endif

/********************************************************************
 * PixmapObj()
 ********************************************************************/
PixmapObj::PixmapObj() 
{
    d_background = 0;
}

/********************************************************************
 * ~PixmapObj()
 ********************************************************************/
PixmapObj::~PixmapObj()
{
    for (Uint32 i=0; i<d_gcObjs.length(); i++) {
        GCObj      *gc = d_gcObjs.idx(i);

        d_gcObjs.idx(i)->setAttached(0);
        d_gcObjs.idx(i)->setPixmap(0);
    }
}

/********************************************************************
 * line()
 ********************************************************************/
void PixmapObj::line(GC gc, Uint32 x1, Uint32 y1, 
        Uint32 x2, Uint32 y2)
{
}

/********************************************************************
 * rect()
 ********************************************************************/
void PixmapObj::rect(GC gc, Uint32 x, Uint32 y, 
        Uint32 width, Uint32 height)
{
}

/********************************************************************
 * fill_rect()
 ********************************************************************/
void PixmapObj::fill_rect(GC gc, Uint32 x, Uint32 y, 
        Uint32 width, Uint32 height)
{
}

/********************************************************************
 * createGC()
 ********************************************************************/
GC PixmapObj::createGC(GCObj &gcObj)
{
    return 0;
}

/********************************************************************
 * freeGC()
 ********************************************************************/
void PixmapObj::freeGC(GCObj &gcObj)
{
}

/********************************************************************
 * PixmapPt operator ()
 ********************************************************************/
PixmapPt PixmapObj::operator () (Uint32 x, Uint32 y)
{
    return PixmapPt(this, x, y);
}

/********************************************************************
 * PixmapRange operator ()
 ********************************************************************/
PixmapRange PixmapObj::operator () (
        Uint32 x, Uint32 y, Uint32 width, Uint32 height)
{
    return PixmapRange(this, x, y, width, height);
}

/********************************************************************
 * operator ()
 ********************************************************************/
PixmapRange PixmapObj::operator () ()
{
    return PixmapRange(this, 0, 0, d_width, d_height);
}

/********************************************************************
 * operator =
 *
 * this          = dest
 * rng.d_pixmap  = src
 ********************************************************************/
void PixmapPt::operator = (const PixmapRange &rng)
{
    PixmapObj   *dest = d_pixmap, *src = rng.d_pixmap;

    /**** Now, copy rng.d_pixmap to this.d_pixmap ****/
    
    dest->copy(src, rng.d_x, rng.d_y, rng.d_width, rng.d_height,
            d_x, d_y);
}

/********************************************************************
 * operator =
 ********************************************************************/
void PixmapObj::operator = (const PixmapRange &rng)
{
    PixmapObj *src = rng.d_pixmap;

    copy(src, rng.d_x, rng.d_y, rng.d_width, rng.d_height);
}

/********************************************************************
 * copy()
 ********************************************************************/
void PixmapObj::copy(
        PixmapObj *src, Uint32 x, Uint32 y, Uint32 width,
        Uint32 height, Uint32 x1, Uint32 y1)
{
#ifdef UNDEFINED
    DBG_MSG((FP, "----> copy(%x, %d, %d, %d, %d, %d, %d) %x = dest\n",
                src, x, y, width, height, x1, y1, this));

    /**** Copy data from obj to this pixmap... ****/
    XCopyArea(d_display, src->getPixmap(), getPixmap(), getCopyGC(),
            x, y, width, height, x1, y1);

    DBG_MSG((FP, "<---- copy(%x, %d, %d, %d, %d, %d, %d) %x = dest\n",
                src, x, y, width, height, x1, y1, this));
#endif
}

/********************************************************************
 * copy()
 ********************************************************************/
void PixmapObj::copy(
        PixmapObj *obj, Uint32 x, Uint32 y, Uint32 width, Uint32 height)
{
    copy(obj, x, y, width, height, 0, 0);
}

/********************************************************************
 * width_height()
 ********************************************************************/
void PixmapObj::width_height(Uint32 width, Uint32 height)
{
}

/********************************************************************
 * ComputeTextLayout()
 ********************************************************************/
Tk_TextLayout PixmapObj::ComputeTextLayout(
                Tk_Font font, Char *str, Int32 len, Int32 wraplen,
                Tk_Justify justify, Int32 flags, Int32 *width, Int32 *height)
{
    return 0;
}

/********************************************************************
 * DrawTextLayout()
 ********************************************************************/
void PixmapObj::DrawTextLayout(GC gc, Tk_TextLayout layout, 
        Uint32 x, Uint32 y, Int32 start, Int32 end)
{
}

/********************************************************************
 * FreeTextLayout()
 ********************************************************************/
void PixmapObj::FreeTextLayout(Tk_TextLayout layout)
{
    Tk_FreeTextLayout(layout);
}

/********************************************************************
 * blank()
 ********************************************************************/
void PixmapObj::blank()
{
}

/********************************************************************
 * getType()
 ********************************************************************/
PixmapObj::PixmapType PixmapObj::getType() const
{
    return PixmapNone;
}

/********************************************************************
 * addGC()
 ********************************************************************/
void PixmapObj::addGC(GCObj &gc)
{
    PixmapObj   *pObj = 0;

    /**** See if the GC is already attached to another pixmap... ****/
    if ((pObj = gc.getPixmap())) {

        /**** If this pixmap is already attached to the GC, then nothing
         **** more to do...
         ****/
        if (pObj == this) {
            return;
        }

        /**** Remove the gc... ****/
        removeGC(gc);
    }

    /**** Now, add the GC to this pixmap's list of GCs ****/
    d_gcObjs.append(&gc);
    gc.setPixmap(this);
}

/********************************************************************
 * addGCs()
 ********************************************************************/
void PixmapObj::addGCs(GCObj *objs, Uint32 num_objs)
{
    for (Uint32 i=0; i<num_objs; i++) {
        addGC(objs[i]);
    }
}

/********************************************************************
 * removeGCs()
 ********************************************************************/
void PixmapObj::removeGCs(GCObj *objs, Uint32 num_objs)
{
    for (Uint32 i=0; i<num_objs; i++) {
        removeGC(objs[i]);
    }
}

/********************************************************************
 * removeGC()
 ********************************************************************/
void PixmapObj::removeGC(GCObj &gc)
{
    PixmapObj   *pObj = 0;

    if ((pObj = gc.getPixmap())) {
        if (gc.isAttached()) {
            pObj->d_gcObjs.remove(&gc);
            gc.setAttached(0);
            gc.setPixmap(0);
        }
    }
}


