/****************************************************************************
 *                           RemoteCmdStub.cc
 *
 * Author: Matthew Ballance
 * Desc:   Implements the server side of a remotely-implemented command
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "RemoteCmdStub.h"
#include "RemoteAppTclCmdListener.h"

/********************************************************************
 * RemoteCmdStub()
 ********************************************************************/
RemoteCmdStub::RemoteCmdStub(
        Tcl_Interp                  *interp,
        const char                  *cmd_name,
        RemoteAppTclCmdListener     *cmd_chan)
{
    d_cmdChan = cmd_chan;
    d_interp  = interp;

    d_cmdToken = Tcl_CreateObjCommand(interp, cmd_name, 
            &RemoteCmdStub::StubCommand, this, 0);
}

/********************************************************************
 * StubCommand()
 ********************************************************************/
int RemoteCmdStub::StubCommand(int objc, Tcl_Obj *const objv[])
{
    int ret;

    for (int i=0; i<objc; i++) {
        fprintf(stderr, "objv[%d] = %s\n", i, Tcl_GetString(objv[i]));
    }

    ret = d_cmdChan->Command(d_interp, objc, objv);

    fprintf(stderr, "Result: %s\n", Tcl_GetStringResult(d_interp));

    return ret;
}

