/****************************************************************************
 *                           StimulusSeq.cc
 *
 * Author: Matthew Ballance
 * Desc:   The StimulusSeq class is the template for sequences of values. 
 *         A StimSeqInst object uses a StimulusSeq to generate a waveform
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "StimulusSeq.h"
#include "StimulusMgr.h"

/********************************************************************
 * StimulusSeq()
 ********************************************************************/
StimulusSeq::StimulusSeq(const char *inst_name, StimulusMgr *mgr) :
    instName(inst_name), d_bitWidth(1)
{

    initDelay     = 0;
    repeatDelay   = 0;
    numRepeat     = 0;
    repeat        = 0;
    parent        = mgr;

    values = new Vector<StimulusItem>();

    if (inst_name && inst_name[0]) {
        mgr->addSeq(this);
    }

    parent = mgr;
}

/********************************************************************
 * setMaxBitWidth()
 ********************************************************************/
void StimulusSeq::setMaxBitWidth(Uint32 width)
{
    if (width > d_bitWidth) {
        d_bitWidth = width;
    }
}

#ifdef UNDEFINED
/********************************************************************
 * Start()
 *
 * This method is invoked in the following cases:
 * - 0-time offset on initial element. More than one element 
 *   (next one with >0-time offset)
 *
 * - One element with zero-time offset.
 ********************************************************************/
void StimulusSeq::Start()
{
    StimulusItem    *item = values->idx(seq_idx);
    s_vpi_value      value_s;
    IviSim          *sim = parent->getSim();
    Uint32           cb_time;
    s_vpi_time       time_s;

    /**** Set the value now... ****/
    if (initDelay == 0) {
        value_s.format    = vpiBinStrVal;
        value_s.value.str = item->value->rawValue();
        sim->vpi_put_value(vpiHndl, &value_s, NULL, vpiNoDelay);

        item = values->idx(++seq_idx);
    } 

    /**** Schedule the next callback if it exists... ****/
    if (item) {
        time_s.type = vpiSimTime;
        sim->vpi_get_time(0, &time_s);

        cb_data.time->type = vpiSimTime;
        cb_data.time->low  = time_s.low+(!seq_idx)?initDelay:item->delay;

        sim->vpi_register_cb(&cb_data);
    } else {
        delete this;
    }
}
#endif /* UNDEFINED */


