/****************************************************************************
 *                             StrAccObj.h
 *
 * Author: Matthew Ballance
 * Desc:   
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_STR_ACC_OBJ_H
#define INCLUDED_STR_ACC_OBJ_H
#include "FileAccObj.h"

class StrAccObj : public FileAccObj {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * StrAccObj()
         ************************************************************/
        StrAccObj();

        /************************************************************
         * operator ()
         ************************************************************/
        virtual void operator () (const char *string);

        /************************************************************
         * read_bytes() 
         ************************************************************/
        virtual int read_bytes(Uint8 *buf, Uint32 len);

        /************************************************************
         * eof()
         ************************************************************/
        virtual int eof();

    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:
        char        *d_store;
        Uint32       d_idx;
        Uint32       d_len;
};

#endif /* INCLUDED_STR_ACC_OBJ_H */
