/****************************************************************************
 *                               Tokenizer.h
 *
 * Author: Matthew Ballance
 * Desc:   Implements a simple tokenizer that extracts words from a stream
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_TOKENIZER_H
#define INCLUDED_TOKENIZER_H
#include "FileAccObj.h"

class Tokenizer {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * Tokenizer()
         ************************************************************/
        Tokenizer();

        /************************************************************
         * operator ()
         ************************************************************/
        void operator () (FileAccObj *f_acc);

        /************************************************************
         * nextToken()
         ************************************************************/
        char *nextToken();

        /************************************************************
         * getToken()
         ************************************************************/
        char *getToken();

        /************************************************************
         * isTokSep()
         ************************************************************/
        virtual bool isTokSep(char ch);

    /****************************************************************
     * Public Data
     ****************************************************************/
    public:

    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:
        char skipWhite(char ch);
        char skipComment(char ch);
        char getChar();

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:
        FileAccObj        *d_accObj;
        String             d_store;

};


#endif /* INCLUDED_TOKENIZER_H */

