/****************************************************************************
 *                               XPixmapObj.h
 *
 * Author: Matthew Ballance
 * Desc:   Implements a wrapper around a pixmap... This allows us to 
 *         implement various back-ends and use the same drawing code...
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_XPIXMAP_OBJ_H
#define INCLUDED_XPIXMAP_OBJ_H
#include <tk.h>
#include "vector.h"
#include "types.h"
#include "GCObj.h"
#include "PixmapObj.h"

class GCObj;
class PixmapPt;
class PixmapRange;
class XPixmapObj : public PixmapObj {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * XPixmapObj()
         ************************************************************/
        XPixmapObj();

        /************************************************************
         * XPixmapObj()
         ************************************************************/
        XPixmapObj(Tk_Window window);

        /************************************************************
         * ~XPixmapObj()
         ************************************************************/
        virtual ~XPixmapObj();

        /************************************************************
         * line()
         ************************************************************/
        virtual void line(GC gc, Uint32 x1, Uint32 y1, Uint32 x2, Uint32 y2);

        /************************************************************
         * rect()
         ************************************************************/
        virtual void rect(GC gc, Uint32 x, Uint32 y, 
                Uint32 width, Uint32 height);

        /************************************************************
         * fill_rect()
         ************************************************************/
        virtual void fill_rect(GC gc, Uint32 x, Uint32 y, 
                Uint32 width, Uint32 height);

        /************************************************************
         * ComputeTextLayout()
         ************************************************************/
        virtual Tk_TextLayout ComputeTextLayout(
                Tk_Font font, Char *str, Int32 len, Int32 wraplen,
                Tk_Justify justify,
                Int32 flags, Int32 *width, Int32 *height);

        /************************************************************
         * DrawTextLayout()
         ************************************************************/
        virtual void DrawTextLayout(
                GC gc, Tk_TextLayout layout, Uint32 x, Uint32 y, 
                Int32 first, Int32 last);

        /************************************************************
         * FreeTextLayout()
         ************************************************************/
        virtual void FreeTextLayout(Tk_TextLayout layout);

        /************************************************************
         * createGC()
         ************************************************************/
        virtual GC createGC(GCObj &gcObj);

        /************************************************************
         * freeGC()
         ************************************************************/
        virtual void freeGC(GCObj &gcObj);

        /************************************************************
         * setWindow()
         ************************************************************/
        void setWindow(Tk_Window win);

        /************************************************************
         * copy 
         *
         * Copy data from (x,y)-(x+width,y+height) to (x1, y1)
         ************************************************************/
        virtual void copy(PixmapObj *obj, Uint32 x, Uint32 y, 
                Uint32 width, Uint32 height, Uint32 x1, Uint32 y1);

        /************************************************************
         * copy 
         *
         * Copy data from (x,y)-(x+width,y+height) to (x1, y1)
         ************************************************************/
        virtual void copy(PixmapObj *obj, Uint32 x, Uint32 y, 
                Uint32 width, Uint32 height);

        /************************************************************
         * blank()
         *
         * sets the color of the pixmap to the background color...
         ************************************************************/
        virtual void blank();

        /************************************************************
         * operator =
         ************************************************************/
        virtual void operator = (const PixmapRange &rng);

        /************************************************************
         * getPixmap()
         ************************************************************/
        Pixmap getPixmap() const { 
            return (d_pixmap)?d_pixmap:Tk_WindowId(d_window); 
        }

        /************************************************************
         * width_height()
         ************************************************************/
        virtual void width_height(Uint32 width, Uint32 height);

        /************************************************************
         * getType()
         *
         * returns the type of this pixmap...
         ************************************************************/
        virtual PixmapObj::PixmapType getType() const;

    /****************************************************************
     * Public Data
     ****************************************************************/
    public:

    /****************************************************************
     * Private Methods
     ****************************************************************/
    private:
        GC getCopyGC();

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:
        Pixmap        d_pixmap;
        bool          d_winPixmap;
        Display      *d_display;
        Tk_Window     d_window;

/*        Tk_3DBorder   d_background; */

        GC            d_copyGC;
};

#endif /* INCLUDED_XPIXMAP_OBJ_H */

