#****************************************************************************
#*                             DialogBox.tcl
#*
#* Author: Matthew Ballance
#* Desc:   TCL file to create labled frames.
#* <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
#*
#*    This source code is free software; you can redistribute it
#*    and/or modify it in source code form under the terms of the GNU
#*    General Public License as published by the Free Software
#*    Foundation; either version 2 of the License, or (at your option)
#*    any later version.
#*
#*    This program is distributed in the hope that it will be useful,
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*    GNU General Public License for more details.
#*
#*    You should have received a copy of the GNU General Public License
#*    along with this program; if not, write to the Free Software
#*    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#*
#* </Copyright>
#****************************************************************************
namespace eval DialogBox {
    namespace export DialogBox

    variable title ""
}

#********************************************************************
#* DialogBox
#********************************************************************
proc DialogBox::DialogBox {path args} {

    toplevel $path

    wm withdraw $path

    while {[llength $args] > 0} {
        set arg [lindex $args 0]
        set shift 1

        if {$arg == "-title" || $arg == "-text"} {
            wm title $path [lindex $args 1]
            set shift 2
        } else {
            error "unknown DialogBox option \"$arg\""
        }

        set args [lrange $args $shift end]
    }

    bind $path <Destroy> "DialogBox::destroy_cb $path"
    grid propagate $path true

    rename $path ::$path:cmd
    proc ::$path { cmd args } \
        "return \[eval DialogBox::cmd $path \$cmd \$args\]"

    upvar 0 $path data
    set data(dummy) 0

    return $path
}

#********************************************************************
#* cmd
#*
#* - popup
#* - withdraw
#********************************************************************
proc DialogBox::cmd {path cmd args} {
    upvar #0 $path data
    global $path
    set wait "$path.wait"
    global $wait

    if {$cmd == "popup"} {
        wm deiconify $path
    } elseif {$cmd == "withdraw"} {
        wm withdraw $path
    } elseif {$cmd == "wait"} {
        set old_focus [focus]
        focus $path
        grab $path

        set $wait none
        tkwait variable $wait

        set ret ""
        if {[winfo exists $path]} {
            grab release $path
            set ret $wait
        }

        focus $old_focus
        return $ret
    } elseif {$cmd == "ok"} {
        set okb [DialogBox::cmd $path subwidget ok]
        if {[$okb cget -state] == "normal" || \
            [$okb cget -state] == "active"} {
            set $wait ok
            set data(wait) ok
        }
    } elseif {$cmd == "subwidget"} {
        set sw [lindex $args 0]

        if {[array get data "w:$sw"] != ""} {
            set vl [array get data "w:$sw"]
            set w [lindex $vl 1]
            return $w
        } else {
            error "no subwidget \"$sw\" exists"
        }
    } elseif {$cmd == "widget_list"} {
        while {[llength $args] > 0} {
            set w [lindex $args 0]
            set v [lindex $args 1]

            set args [lrange $args 2 end]
            set data(w:$w) $v
        }
    } elseif {$cmd == "center"} {
        update idletasks
        set w $path
        if {[llength $args] > 0} {
            set over ".[lindex [split [lindex $args 0] {.}] 1]"

            set cx [expr {int ([winfo rootx $over] + \
                [winfo width $over] /2)}]
            set cy [expr {int ([winfo rooty $over] + \
                [winfo height $over] / 2)}]
            set x  [expr {$cx - int ([winfo reqwidth $w] / 2)}]
            set y  [expr {$cy - int ([winfo reqheight $w] / 2)}]
        } else {
            set x [expr {int (([winfo screenwidth $w] - \
                [winfo reqwidth $w])/2)}]
            set y [expr {int (([winfo screenheight $w] - \
                [winfo reqheight $w])/2)}]
            set over ""
        }

        wm geometry $w +${x}+${y}
        wm positionfrom $w user

        update idletasks
    } else {
        error "unknown command $cmd"
    }
}

#********************************************************************
#* destroy_cb
#********************************************************************
proc DialogBox::destroy_cb {path} {
    upvar 0 $path data

    set wait "$path.wait"
    global $wait

    set $wait cancel
}



