#****************************************************************************
#*                            IviToolbar.tcl
#*
#* Author: Matthew Ballance
#* Desc:   Implements a wrapper around the ButtonBox to implement a toolbar
#*         Essentially, this makes life simpler for the MenuMgr code...
#* <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
#*
#*    This source code is free software; you can redistribute it
#*    and/or modify it in source code form under the terms of the GNU
#*    General Public License as published by the Free Software
#*    Foundation; either version 2 of the License, or (at your option)
#*    any later version.
#*
#*    This program is distributed in the hope that it will be useful,
#*    but WITHOUT ANY WARRANTY; without even the implied warranty of
#*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#*    GNU General Public License for more details.
#*
#*    You should have received a copy of the GNU General Public License
#*    along with this program; if not, write to the Free Software
#*    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#*
#* </Copyright>
#****************************************************************************


namespace eval IviToolbar {

}


#********************************************************************
#* IviToolbar
#********************************************************************
proc IviToolbar::IviToolbar {path args} {
    set path [frame $path]

    array set $path {_dummy _dummy}
    upvar #0 $path data


    set data(numBBox) 0
    set data(numSeps) 0
    set data(currBBox) ""

    rename $path ::$path:cmd
    proc ::$path {cmd args} "return \[eval IviToolbar::cmd $path \$cmd \$args]"

    return $path
}

#********************************************************************
#* cmd
#********************************************************************
proc IviToolbar::cmd {path cmd args} {
    upvar #0 $path data

    if {$cmd == "add_button"} {
        eval IviToolbar::add_button $path $args
    } elseif {$cmd == "add_sep"} {
        eval IviToolbar::add_sep $path $args
    } elseif {$cmd == "subwidget"} {
        return $data(w:[lindex $args 0])
    } elseif {$cmd == "add_combo"} {
        eval IviToolbar::add_combo $path $args
    } elseif {$cmd == "add_script"} {
        eval IviToolbar::add_script $path $args
    } else {
        error "Unknown subcmd $cmd"
    }
}

#********************************************************************
#* find_image
#********************************************************************
proc IviToolbar::find_image {path img_name} {
    set img ""

    if {[info globals ImgPath] != ""} {
        global ImgPath

        foreach path $ImgPath {
            if {[file exists [file join $path $img_name]]} {
                set img [Bitmap::get [file join $path $img_name]]
                return $img
            }
        }
    }

    if {[info globals IVI_IMG_PATH] != ""} {
        global IVI_IMG_PATH

        foreach path $IVI_IMG_PATH {
            if {[file exists [file join $path $img_name]]} {
                set img [Bitmap::get [file join $path $img_name]]
                return $img
            }
        }
    }

    if {[file exists $img_name]} {
        set img [Bitmap::get $img_name]
        return $img
    }

    error "Cannot find image \"$img_name\"" 
}

#********************************************************************
#* add_button
#********************************************************************
proc IviToolbar::add_button {path args} {
    upvar #0 $path data

    if {$data(currBBox) == ""} {
        set data(currBBox) [ButtonBox "$path.bbox$data(numBBox)" \
            -spacing 0 -padx 1 -pady 1]
        incr data(numBBox)
        pack $data(currBBox) -side left -anchor w
    }

    set button [$data(currBBox) add -highlightthickness 0 -takefocus 0 \
        -relief link -borderwidth 1 -padx 1 -pady 1]

    set data(w:[lindex $args 0]) $button

    for {set i 1} {$i < [llength $args]} {incr i} {
        set opt [lindex $args $i]

        if {$opt == "-image"} {
            incr i
            set img_name [lindex $args $i]
            set img [find_image $path $img_name]

            $button configure -image $img
        } elseif {$opt == "-helptext"} {
            incr i

            $button configure -helptext [lindex $args $i]
        } else {
            $button configure [lindex $args $i] [lindex $args [expr $i + 1]]
            incr i
        }
    }
}

#********************************************************************
#* add_sep
#********************************************************************
proc IviToolbar::add_sep {path args} {
    upvar #0 $path data

    set sep [Separator "$path.sep$data(numSeps)" -orient vertical]
    incr data(numSeps)
    pack $sep -side left -fill y -padx 4 -anchor w

    set data(w:[lindex $args 0]) $sep

    set data(currBBox) ""
}

#********************************************************************
#* add_combo
#********************************************************************
proc IviToolbar::add_combo {path args} {
    upvar #0 $path data

    set name [lindex $args 0]
    set args [linsert [lrange $args 1 end] 0 "$path.[lindex $args 0]"]
    set cb [eval [linsert $args 0 ComboBox]]

    pack $cb -side left -padx 4 -anchor w

    set data(w:$name) $cb

    set data(currBBox) ""
}

#********************************************************************
#* add_script
#*
#* $script <
#********************************************************************
proc IviToolbar::add_script {path name args} {
    upvar #0 $path data

    set el [eval [linsert $args 1 $path $name]]

    set data(w:$name) $el
    set data(currBBox) ""
}

