/****************************************************************************
 *                           IviRemoteSDBClnt.cc
 *
 * Author: Matthew Ballance
 * Desc:   Implements the client side of the SDB.
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *         
 *         The SDB client receives commands via the RemoteAppConnection
 *         channel. It then satisfies these requests by 
 ****************************************************************************/
#include "IviRemoteSDBClnt.h"
#include "RemoteAppConnectionListener.h"
#include "RemoteAppConnection.h"
#include "IviRemoteProto.h"
#include "IviRemoteSDBProto.h"
#include "DFIOTrace.h"

class IviRemoteSDBClntListener : public RemoteAppConnectionListener {

    public:

        IviRemoteSDBClntListener(IviRemoteSDBClnt *sdb_clnt) :
            RemoteAppConnectionListener(REMOTE_SDB_IDX)
        {
            d_sdbClnt = sdb_clnt;
        }

        virtual void Receive(Uint32 idx, Uint32 len, Uchar *data)
        {
            d_sdbClnt->Receive(len, data);
        }

    private:
        IviRemoteSDBClnt      *d_sdbClnt;
};

/********************************************************************
 * IviRemoteSDBClnt()
 ********************************************************************/
IviRemoteSDBClnt::IviRemoteSDBClnt(
        RemoteAppConnection        *conn,
        Tcl_Interp                 *interp,
        Uint32                      argc,
        Char                      **argv) : 
    SigDB(interp, argc, argv), d_conn(conn)
{
    d_listener = new IviRemoteSDBClntListener(this);
    d_conn->AddListener(d_listener);
}

/********************************************************************
 * ~IviRemoteSDBClnt()
 ********************************************************************/
IviRemoteSDBClnt::~IviRemoteSDBClnt()
{

}

/********************************************************************
 * Receive()
 ********************************************************************/
void IviRemoteSDBClnt::Receive(Uint32 len, Uchar *data)
{
    Uint32               cmd, idx=0;
    Vector<DFIOTrace>   *newSigs;
    String               buf(16);

    cmd = RemoteAppConnection::ReadUint32(data, idx);

    if (cmd != IviRemoteSDB_AddSignal) {
        fprintf(stderr, "ERROR: received cmd=%d (expect "
                "IviRemoteSDB_AddSignal)\n");
    }

    newSigs = addSignal((char *)&data[idx]);

    buf="";
    for (Uint32 i=0; i<newSigs->length(); i++) {
        buf += newSigs->idx(i)->name.value();
        if ((i+1) < newSigs->length()) {
            buf += ",";
        }
    }

    d_conn->Send(REMOTE_SDB_IDX, buf.length()+1, (Uchar *)buf.value());
}

