/****************************************************************************
 *                            iviSplitString.cc
 *
 * Author: Matthew Ballance
 * Desc:   Utility function to split a writable string into white-space
 *         separated tokens
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "iviSplitString.h"
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>


/********************************************************************
 * iviSplitString()
 ********************************************************************/
void iviSplitString(char *str, int *argcp, char ***argvp)
{
    int    argc = 0;
    char **argv;
    char  *strp = str;
    char  *stre;

    while (*strp) {

        /**** First, discard any whitespace ****/
        while (*strp && isspace(*strp)) { strp++; }

        /**** Now, scan to the end of the token ****/
        stre = strp;
        while (*stre && !isspace(*stre)) { stre++; }

        if (*strp) {
            /**** See if we need to reallocate ****/
            if (argc) {
                argv = (char **)realloc(argv, sizeof(char *)*(argc+1));
            } else {
                argv = (char **)malloc(sizeof(char *));
            }

            argv[argc++] = strp;

            if (*stre) {
                strp = stre+1;
                *stre = 0;
            } else {
                strp = stre;
            }
        } else if (*stre) {
            strp = stre+1;
        }
    }

    *argvp = argv;
    *argcp = argc;
}

/********************************************************************
 * iviFreeStringArr()
 ********************************************************************/
void iviFreeStringArr(char **argv)
{
    free(argv);
}

