/****************************************************************************
 *                            ShmDFIOChgBlk.h
 *
 * Author: Matthew Ballance
 * Desc:  
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_SHM_DFIO_CHG_BLK_H
#define INCLUDED_SHM_DFIO_CHG_BLK_H
#include "ShmDFIOHeader.h"
#include "DFIO.h"

/********************************************************************
 * ShmDFIOChgBlkData
 *
 * Represents the Shm version of the ChgBlk
 ********************************************************************/
struct ShmDFIOChgBlkData {
    Uint32               d_currChange;
    Uint64               d_startTime;
    Uint64               d_endTime;

    ShmDFIOPtr           d_nextBlock;

    DFIOValChg           d_changes[1];
};

/********************************************************************
 * ShmDFIOChgBlkData_Size()
 ********************************************************************/
#define ShmDFIOChgBlkData_Size(bitwidth, changes) \
    (sizeof(ShmDFIOChgBlkData) + DFIOValChg_Size((bitwidth), (changes)-1))

/********************************************************************
 * ShmDFIOChgBlk
 *
 * The in-memory version 
 ********************************************************************/
struct ShmDFIOChgBlk {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * ShmDFIOChgBlk()
         ************************************************************/
        ShmDFIOChgBlk(ShmDFIOPtr blkStorePtr) {
            d_blkStorePtr = blkStorePtr;
            d_currChange  = 0;
        }

    /****************************************************************
     * Public Data
     ****************************************************************/
    public:
        ShmDFIOPtr          d_blkStorePtr;

        Uint32              d_currChange;
        Uint64              d_startTime;
        Uint64              d_endTime;
};

#endif /* INCLUDED_SHM_DFIO_CHG_BLK_H */
