/****************************************************************************
 *                            ShmDFIOWriter.cc
 *
 * Author: Matthew Ballance
 * Desc:   Implements the writer interface to a shared-mem file
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "ShmDFIOWriter.h"
#include "ShmDFIOTrace.h"
#include <unistd.h>
#include "ivi_print.h"

#undef  DEBUG_SHM_DFIO_WRITER

#define FP stderr
#ifdef DEBUG_SHM_DFIO_WRITER
#define DBG_MSG(x) fprintf x ; fflush(FP)
#else
#define DBG_MSG(x)
#endif

/********************************************************************
 * ShmDFIOWriter()
 ********************************************************************/
ShmDFIOWriter::ShmDFIOWriter(
        Tcl_Interp    *interp,
        int            argc,
        char         **argv) : ShmDFIO(interp, argc, argv)
{
    Uint32      mappedSize = 1024*1;
    ok = false;

    mappedSize = d_pagesize;

    d_file = new ShmDFIOFile(d_filename, false);

    if (!d_file->ok) {
        ivi_print("ERROR: problem constructing ShmDFIOFile\n");
        return;
    }

    DBG_MSG((FP, "----> Writer initially maps file\n")); 
    d_file->map(mappedSize);
    DBG_MSG((FP, "<---- Writer initially maps file\n")); 

    d_header = (ShmDFIOHeader *)d_file->getMapBase();

    d_header->d_mappedSize  = mappedSize;
    d_header->d_usedSize    = sizeof(ShmDFIOHeader);
    d_header->d_owner       = 0;
    d_header->d_locks       = 0;
    d_header->d_traceList   = 0;
    d_header->d_traceCount  = 0;
    d_header->d_changeInfo  = 0;
    d_header->d_blockSize   = 1024;
    d_header->d_timeUnit    = -9;     /* ns by default */
    d_header->d_maxTime     = 0;

//    d_file->dump("writer", sizeof(ShmDFIOHeader));

    ok = true;
}

/********************************************************************
 * ~ShmDFIOWriter()
 ********************************************************************/
ShmDFIOWriter::~ShmDFIOWriter()
{

}

/********************************************************************
 * newTrace()
 ********************************************************************/
DFIOTrace *ShmDFIOWriter::newTrace(
        Char              *name,
        Uint32             rows,
        Uint32             msb,
        Uint32             lsb,
        Uint32             traceType)
{
    char             *base = d_file->getMapBase();
    ShmDFIOPtr        traceDesc; 
    ShmDFIOPtr        thisTracePtr, nextTracePtr;
    ShmDFIOTraceDesc *thisTrace;
    ShmDFIOTrace     *trace;

    trace = new ShmDFIOTrace(this, name, rows, msb, lsb, traceType);

    traceDesc = trace->getTraceDescPtr();

    d_header->d_traceCount++;

    if (!d_header->d_traceList) {
        d_header->d_traceList = traceDesc;
    } else {
        /**** Okay, have to go searching... ****/
        thisTracePtr = d_header->d_traceList;

        while (thisTracePtr) {
            thisTrace = (ShmDFIOTraceDesc *)ShmPtr2Ptr(thisTracePtr);

            if (!thisTrace->nextTrace) {
                /**** Done... ****/
                thisTrace->nextTrace = traceDesc;
                break;
            } else {
                thisTracePtr = thisTrace->nextTrace;
            }
        }
    }

    return trace;
}


