/*****************************************************************************
 *                            ValChgBlkVector.h
 *
 * Author: Matthew Ballance
 * Desc:   Implements a vector optimized for data blocks
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *
 *****************************************************************************/
#ifndef INCLUDED_BLK_VECTOR_H
#define INCLUDED_BLK_VECTOR_H
#include "vector.h"
#include "ValChgBlock.h"
#include <stdio.h>

class ValChgBlkVector : public Vector<DFIOValChg> {

public:
    ValChgBlkVector(Uint32 bitWidth);
    virtual ~ValChgBlkVector(void);

    virtual inline DFIOValChg *idx(Uint32 idx);
    virtual inline Uint32 length(void) { 
        return (elem_length)?(elem_length - init_idx):0; }

    void append(ValChgBlock *newBlk); 

    inline void set_init_idx(Uint32   init_idx) {
        this->init_idx = init_idx;
    }

    inline void decLen(Uint32 amt) {
        if (amt > this->elem_length) {
            fprintf(stderr, "ERROR: removing %d from %d\n",
                    amt, elem_length);
        }
        this->elem_length -= amt;
    }

    inline void incLen(Uint32 amt) {
        this->elem_length += amt;
    }

    void *operator new (size_t size);
    void  operator delete (void *ptr);

private:
    Vector<ValChgBlock>      *blk_store;
    ValChgBlock              *blk_cache;
    Uint32                    blk_size;
    Uint32                    blk_try_cache;
    Uint32                    idx_try_cache;
    Uint32                    cnt_cache;
    Uint32                    elem_length;
    Uint32                    init_idx;
    Uint32                    d_bitWidth;

    static ValChgBlkVector   *prv_AllocList;

    ValChgBlkVector          *next;
};


#endif /* INCLUDED_BLK_VECTOR_H */
